/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.world;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.LightningStrikeEvent;

public class LightningStrikesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static LightningStrikesScriptEvent instance;
    public LocationTag location;
    public LightningStrikeEvent event;

    public LightningStrikesScriptEvent() {
        instance = this;
        this.registerCouldMatcher("lightning strikes");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "lightning": {
                return new EntityTag((Entity)this.event.getLightning());
            }
            case "location": {
                return this.location;
            }
            case "world": {
                BukkitImplDeprecations.worldContext.warn();
                return new WorldTag(this.location.getWorld());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onLightningStrikes(LightningStrikeEvent event) {
        this.location = new LocationTag(event.getLightning().getLocation());
        this.event = event;
        this.fire((Event)event);
    }
}

