/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.bukkit;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.core.CooldownCommand;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptHelper;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;

public class BukkitScriptProperties
implements Property {
    public static final String[] handledMechs = new String[0];
    ScriptTag script;

    public static boolean describes(ObjectTag script) {
        return script instanceof ScriptTag;
    }

    public static BukkitScriptProperties getFrom(ObjectTag script) {
        if (!BukkitScriptProperties.describes(script)) {
            return null;
        }
        return new BukkitScriptProperties((ScriptTag)script);
    }

    private BukkitScriptProperties(ScriptTag script) {
        this.script = script;
    }

    public static void registerTags() {
        PropertyParser.registerTag(BukkitScriptProperties.class, ElementTag.class, "cooled_down", (attribute, script) -> {
            PlayerTag player;
            PlayerTag playerTag = player = attribute.hasParam() ? attribute.paramAsType(PlayerTag.class) : ((BukkitScriptEntryData)attribute.getScriptEntry().entryData).getPlayer();
            if (player != null && player.isValid()) {
                return new ElementTag(CooldownCommand.checkCooldown(player, script.script.getContainer().getName()));
            }
            return null;
        }, new String[0]);
        PropertyParser.registerTag(BukkitScriptProperties.class, DurationTag.class, "cooldown", (attribute, script) -> {
            PlayerTag player = attribute.hasParam() ? attribute.paramAsType(PlayerTag.class) : ((BukkitScriptEntryData)attribute.getScriptEntry().entryData).getPlayer();
            return CooldownCommand.getCooldownDuration(player, script.script.getName());
        }, new String[0]);
        PropertyParser.registerTag(BukkitScriptProperties.class, ElementTag.class, "step", (attribute, script) -> {
            PlayerTag player;
            PlayerTag playerTag = player = attribute.hasParam() ? attribute.paramAsType(PlayerTag.class) : ((BukkitScriptEntryData)attribute.getScriptEntry().entryData).getPlayer();
            if (player != null && player.isValid()) {
                return new ElementTag(InteractScriptHelper.getCurrentStep(player, script.script.getContainer().getName()));
            }
            return null;
        }, new String[0]);
        PropertyParser.registerTag(BukkitScriptProperties.class, TimeTag.class, "step_expiration", (attribute, script) -> {
            PlayerTag player;
            PlayerTag playerTag = player = attribute.hasParam() ? attribute.paramAsType(PlayerTag.class) : ((BukkitScriptEntryData)attribute.getScriptEntry().entryData).getPlayer();
            if (player != null && player.isValid()) {
                return InteractScriptHelper.getStepExpiration(player, script.script.getContainer().getName());
            }
            return null;
        }, new String[0]);
        PropertyParser.registerStaticTag(BukkitScriptProperties.class, ElementTag.class, "default_step", (attribute, script) -> {
            String step = ((InteractScriptContainer)script.script.getContainer()).getDefaultStepName();
            return new ElementTag(step);
        }, new String[0]);
    }

    @Override
    public String getPropertyString() {
        return null;
    }

    @Override
    public String getPropertyId() {
        return "BukkitScriptProperties";
    }

    @Override
    public void adjust(Mechanism mechanism) {
    }
}

