/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.generator;

import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.BooleanArg;
import com.denizenscript.denizencore.scripts.commands.generator.LinearArg;
import com.denizenscript.denizencore.scripts.commands.generator.PrefixedArg;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.codegen.CodeGenUtil;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class CommandExecutionGenerator {
    public static long totalGenerated = 0L;
    public static final String COMMAND_EXECUTION_GENERATOR_TYPENAME = Type.getInternalName(CommandExecutionGenerator.class);
    public static final String COMMAND_EXECUTOR_INTERFACE_PATH = Type.getInternalName(CommandExecutor.class);
    public static final Method COMMAND_EXECUTOR_NTERFACE_EXECUTE_METHOD = ReflectionHelper.getMethod(CommandExecutor.class, "execute", ScriptEntry.class);
    public static final String COMMAND_EXECUTORINTERFACE_EXECUTE_DESCRIPTOR = Type.getMethodDescriptor(COMMAND_EXECUTOR_NTERFACE_EXECUTE_METHOD);
    private static final int LOCAL_SCRIPTENTRY = 1;
    public static final String PREFIXARGDATA_PATH = Type.getInternalName(PrefixArgData.class);
    public static final String PREFIXARGDATA_DESCRIPTOR = "L" + PREFIXARGDATA_PATH + ";";
    public static Method HELPER_PREFIX_ENTRY_METHOD = ReflectionHelper.getMethod(CommandExecutionGenerator.class, "helperPrefixEntryArg", ScriptEntry.class, PrefixArgData.class);
    public static final String HELPER_PREFIX_ENTRY_DESCRIPTOR = Type.getMethodDescriptor(HELPER_PREFIX_ENTRY_METHOD);
    public static final String SCRIPTENTRY_SHOULDDEBUG_DESCRIPTOR = Type.getMethodDescriptor(ReflectionHelper.getMethod(ScriptEntry.class, "dbCallShouldDebug", new Class[0]));
    public static final String DEBUG_REPORT_DESCRIPTOR = Type.getMethodDescriptor(ReflectionHelper.getMethod(Debug.class, "report", Debuggable.class, String.class, Object[].class));

    public static ObjectTag helperPrefixEntryArg(ScriptEntry entry, PrefixArgData arg) {
        if (arg.required) {
            return entry.requiredArgForPrefix(arg.prefix, arg.type);
        }
        return entry.argForPrefix(arg.prefix, arg.type, arg.throwTypeError);
    }

    public static CommandExecutor generateExecutorFor(Class<? extends AbstractCommand> cmdClass, AbstractCommand cmd) {
        try {
            int i;
            Method method = Arrays.stream(cmdClass.getDeclaredMethods()).filter(m -> Modifier.isStatic(m.getModifiers()) && m.getName().equals("autoExecute")).findFirst().orElse(null);
            if (method == null) {
                return null;
            }
            String cmdCleanName = CodeGenUtil.TAG_NAME_PERMITTED.trimToMatches(cmdClass.getSimpleName().replace('.', '_'));
            if (cmdCleanName.length() > 50) {
                cmdCleanName = cmdCleanName.substring(0, 50);
            }
            String className = "com/denizenscript/_generated_/commands/CommandExecutor" + totalGenerated++ + "_" + cmdCleanName;
            ClassWriter cw = new ClassWriter(3);
            cw.visit(52, 1, className, null, "java/lang/Object", new String[]{COMMAND_EXECUTOR_INTERFACE_PATH});
            cw.visitSource("GENERATED_CMD_EXEC", null);
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            Label startLabel = new Label();
            mv.visitLabel(startLabel);
            mv.visitLineNumber(0, startLabel);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitLocalVariable("this", "L" + className + ";", null, startLabel, startLabel, 0);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            ArrayList<PrefixArgData> args = new ArrayList<PrefixArgData>();
            MethodVisitor mv2 = cw.visitMethod(17, "execute", COMMAND_EXECUTORINTERFACE_EXECUTE_DESCRIPTOR, null, null);
            mv2.visitCode();
            Label returnLabel = new Label();
            int line = 1;
            Label startLabel2 = new Label();
            mv2.visitLabel(startLabel2);
            mv2.visitLineNumber(line++, startLabel2);
            boolean hasScriptEntry = false;
            for (Parameter param : method.getParameters()) {
                LinearArg linearArg;
                BooleanArg booleanArg;
                Class<?> paramType = param.getType();
                if (paramType == ScriptEntry.class && !hasScriptEntry) {
                    hasScriptEntry = true;
                    continue;
                }
                PrefixedArg prefixArg = param.getAnnotation(PrefixedArg.class);
                if (prefixArg != null) {
                    cmd.setPrefixesHandled(prefixArg.prefix());
                    if (ObjectTag.class.isAssignableFrom(paramType)) {
                        mv2.visitVarInsn(25, 1);
                        mv2.visitFieldInsn(178, className, "staticArgHolder" + args.size(), PREFIXARGDATA_DESCRIPTOR);
                        mv2.visitMethodInsn(184, COMMAND_EXECUTION_GENERATOR_TYPENAME, "helperPrefixEntryArg", HELPER_PREFIX_ENTRY_DESCRIPTOR, false);
                        mv2.visitTypeInsn(192, Type.getInternalName(paramType));
                        mv2.visitVarInsn(58, 2 + args.size());
                        PrefixArgData argData = new PrefixArgData();
                        argData.prefix = prefixArg.prefix();
                        argData.required = prefixArg.required();
                        argData.throwTypeError = prefixArg.throwTypeError();
                        argData.type = paramType;
                        args.add(argData);
                        continue;
                    }
                    if (paramType == Boolean.TYPE) {
                        // empty if block
                    }
                }
                if ((booleanArg = param.getAnnotation(BooleanArg.class)) != null && paramType == Boolean.TYPE) {
                    cmd.setBooleansHandled(booleanArg.name());
                }
                if ((linearArg = param.getAnnotation(LinearArg.class)) != null) {
                    // empty if block
                }
                Debug.echoError("Cannot generate executor for command '" + cmdClass.getName() + "': autoExecute method has param '" + param.getName() + "' of type '" + paramType.getName() + "' which is not supported.");
                return null;
            }
            mv2.visitLineNumber(line++, startLabel2);
            Label afterDebugLabel = new Label();
            mv2.visitVarInsn(25, 1);
            mv2.visitMethodInsn(182, CodeGenUtil.SCRIPTENTRY_PATH, "dbCallShouldDebug", SCRIPTENTRY_SHOULDDEBUG_DESCRIPTOR, false);
            mv2.visitJumpInsn(153, afterDebugLabel);
            mv2.visitVarInsn(25, 1);
            mv2.visitLdcInsn(cmd.getName());
            mv2.visitIntInsn(17, args.size());
            mv2.visitTypeInsn(189, CodeGenUtil.JAVA_OBJECT_PATH);
            for (i = 0; i < args.size(); ++i) {
                mv2.visitInsn(89);
                mv2.visitIntInsn(17, i);
                mv2.visitVarInsn(25, 2 + i);
                mv2.visitInsn(83);
            }
            mv2.visitMethodInsn(184, CodeGenUtil.DEBUG_PATH, "report", DEBUG_REPORT_DESCRIPTOR, false);
            mv2.visitLabel(afterDebugLabel);
            mv2.visitLineNumber(line++, afterDebugLabel);
            if (hasScriptEntry) {
                mv2.visitVarInsn(25, 1);
            }
            for (i = 0; i < args.size(); ++i) {
                mv2.visitVarInsn(25, 2 + i);
            }
            mv2.visitMethodInsn(184, Type.getInternalName(cmdClass), method.getName(), Type.getMethodDescriptor(method), false);
            mv2.visitLabel(returnLabel);
            mv2.visitLineNumber(line, returnLabel);
            mv2.visitInsn(177);
            mv2.visitLocalVariable("scriptEntry", CodeGenUtil.SCRIPTENTRYT_LOCAL_TYPE, null, startLabel2, returnLabel, 1);
            for (i = 0; i < args.size(); ++i) {
                mv2.visitLocalVariable("arg" + i, "L" + Type.getInternalName(((ArgData)args.get((int)i)).type) + ";", null, startLabel2, returnLabel, 2 + i);
            }
            mv2.visitMaxs(0, 0);
            mv2.visitEnd();
            for (int i2 = 0; i2 < args.size(); ++i2) {
                cw.visitField(9, "staticArgHolder" + i2, "L" + Type.getInternalName(((ArgData)args.get(i2)).getClass()) + ";", null, null);
            }
            cw.visitEnd();
            byte[] compiled = cw.toByteArray();
            Class<?> generatedClass = CodeGenUtil.loader.define(className.replace('/', '.'), compiled);
            for (int i3 = 0; i3 < args.size(); ++i3) {
                ReflectionHelper.setFieldValue(generatedClass, "staticArgHolder" + i3, null, args.get(i3));
            }
            Object result = generatedClass.getConstructors()[0].newInstance(new Object[0]);
            return (CommandExecutor)result;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public static class PrefixArgData
    extends ArgData {
        public String prefix;
        public boolean throwTypeError;
    }

    public static abstract class ArgData {
        public Class type;
        public boolean required;
    }

    public static interface CommandExecutor {
        public void execute(ScriptEntry var1);
    }
}

