/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.generator;

import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.BooleanArg;
import com.denizenscript.denizencore.scripts.commands.generator.LinearArg;
import com.denizenscript.denizencore.scripts.commands.generator.PrefixedArg;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.codegen.CodeGenUtil;
import com.denizenscript.denizencore.utilities.codegen.MethodGenerator;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.shaded.org.objectweb.asm.ClassWriter;
import com.denizenscript.shaded.org.objectweb.asm.Label;
import com.denizenscript.shaded.org.objectweb.asm.Type;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;

public class CommandExecutionGenerator {
    public static long totalGenerated = 0L;
    public static final String COMMAND_EXECUTOR_INTERFACE_PATH = Type.getInternalName(CommandExecutor.class);
    public static final Method COMMAND_EXECUTOR_NTERFACE_EXECUTE_METHOD = ReflectionHelper.getMethod(CommandExecutor.class, "execute", ScriptEntry.class);
    public static final String COMMAND_EXECUTORINTERFACE_EXECUTE_DESCRIPTOR = Type.getMethodDescriptor(COMMAND_EXECUTOR_NTERFACE_EXECUTE_METHOD);
    public static final Method HELPER_PREFIX_ENTRY_METHOD = ReflectionHelper.getMethod(CommandExecutionGenerator.class, "helperPrefixEntryArg", ScriptEntry.class, PrefixArgData.class);
    public static final Method SCRIPTENTRY_SHOULDDEBUG_METHOD = ReflectionHelper.getMethod(ScriptEntry.class, "dbCallShouldDebug", new Class[0]);
    public static final Method DEBUG_REPORT_METHOD = ReflectionHelper.getMethod(Debug.class, "report", Debuggable.class, String.class, Object[].class);

    public static ObjectTag helperPrefixEntryArg(ScriptEntry entry, PrefixArgData arg) {
        if (arg.required) {
            return entry.requiredArgForPrefix(arg.prefix, arg.type);
        }
        return entry.argForPrefix(arg.prefix, arg.type, arg.throwTypeError);
    }

    public static CommandExecutor generateExecutorFor(Class<? extends AbstractCommand> cmdClass, AbstractCommand cmd) {
        try {
            Method method = Arrays.stream(cmdClass.getDeclaredMethods()).filter(m -> Modifier.isStatic(m.getModifiers()) && m.getName().equals("autoExecute")).findFirst().orElse(null);
            if (method == null) {
                return null;
            }
            String cmdCleanName = CodeGenUtil.TAG_NAME_PERMITTED.trimToMatches(cmdClass.getSimpleName().replace('.', '_'));
            if (cmdCleanName.length() > 50) {
                cmdCleanName = cmdCleanName.substring(0, 50);
            }
            String className = "com/denizenscript/_generated_/commands/CommandExecutor" + totalGenerated++ + "_" + cmdCleanName;
            ClassWriter cw = new ClassWriter(3);
            cw.visit(52, 1, className, null, "java/lang/Object", new String[]{COMMAND_EXECUTOR_INTERFACE_PATH});
            cw.visitSource("GENERATED_CMD_EXEC", null);
            MethodGenerator.genDefaultConstructor(cw, className);
            ArrayList<PrefixArgData> args = new ArrayList<PrefixArgData>();
            ArrayList<MethodGenerator.Local> argLocals = new ArrayList<MethodGenerator.Local>();
            MethodGenerator gen = MethodGenerator.generateMethod(className, cw, 17, "execute", COMMAND_EXECUTORINTERFACE_EXECUTE_DESCRIPTOR);
            MethodGenerator.Local scriptEntryLocal = gen.addLocal("scriptEntry", ScriptEntry.class);
            boolean hasScriptEntry = false;
            for (Parameter param : method.getParameters()) {
                LinearArg linearArg;
                BooleanArg booleanArg;
                Class<?> paramType = param.getType();
                if (paramType == ScriptEntry.class && !hasScriptEntry) {
                    hasScriptEntry = true;
                    continue;
                }
                PrefixedArg prefixArg = param.getAnnotation(PrefixedArg.class);
                if (prefixArg != null) {
                    cmd.setPrefixesHandled(prefixArg.prefix());
                    if (ObjectTag.class.isAssignableFrom(paramType)) {
                        MethodGenerator.Local argLocal = gen.addLocal("arg_" + args.size() + "_" + CodeGenUtil.TAG_NAME_PERMITTED.trimToMatches(prefixArg.prefix()), paramType);
                        gen.loadLocal(scriptEntryLocal);
                        gen.loadStaticField(className, argLocal.name, PrefixArgData.class);
                        gen.invokeStatic(HELPER_PREFIX_ENTRY_METHOD);
                        gen.cast(paramType);
                        gen.storeLocal(argLocal);
                        PrefixArgData argData = new PrefixArgData();
                        argData.prefix = prefixArg.prefix();
                        argData.required = prefixArg.required();
                        argData.throwTypeError = prefixArg.throwTypeError();
                        argData.type = paramType;
                        argLocals.add(argLocal);
                        args.add(argData);
                        continue;
                    }
                    if (paramType == Boolean.TYPE) {
                        // empty if block
                    }
                }
                if ((booleanArg = param.getAnnotation(BooleanArg.class)) != null && paramType == Boolean.TYPE) {
                    cmd.setBooleansHandled(booleanArg.name());
                }
                if ((linearArg = param.getAnnotation(LinearArg.class)) != null) {
                    // empty if block
                }
                Debug.echoError("Cannot generate executor for command '" + cmdClass.getName() + "': autoExecute method has param '" + param.getName() + "' of type '" + paramType.getName() + "' which is not supported.");
                return null;
            }
            gen.advanceAndLabel();
            Label afterDebugLabel = new Label();
            gen.loadLocal(scriptEntryLocal);
            gen.invokeVirtual(SCRIPTENTRY_SHOULDDEBUG_METHOD);
            gen.jumpIfFalseTo(afterDebugLabel);
            gen.loadLocal(scriptEntryLocal);
            gen.loadString(cmd.getName());
            gen.loadInt(args.size());
            gen.createArray(Object.class);
            for (int i = 0; i < argLocals.size(); ++i) {
                gen.stackDuplicate();
                gen.loadInt(i);
                gen.loadLocal((MethodGenerator.Local)argLocals.get(i));
                gen.arrayStore(Object.class);
            }
            gen.invokeStatic(DEBUG_REPORT_METHOD);
            gen.advanceAndLabel(afterDebugLabel);
            if (hasScriptEntry) {
                gen.loadLocal(scriptEntryLocal);
            }
            for (MethodGenerator.Local local : argLocals) {
                gen.loadLocal(local);
            }
            gen.invokeStatic(method);
            gen.advanceAndLabel();
            gen.returnNone();
            gen.end();
            for (int i = 0; i < argLocals.size(); ++i) {
                cw.visitField(9, ((MethodGenerator.Local)argLocals.get((int)i)).name, Type.getDescriptor(((ArgData)args.get(i)).getClass()), null, null);
            }
            cw.visitEnd();
            byte[] compiled = cw.toByteArray();
            Class<?> generatedClass = CodeGenUtil.loader.define(className.replace('/', '.'), compiled);
            for (int i = 0; i < argLocals.size(); ++i) {
                ReflectionHelper.setFieldValue(generatedClass, ((MethodGenerator.Local)argLocals.get((int)i)).name, null, args.get(i));
            }
            Object result = generatedClass.getConstructors()[0].newInstance(new Object[0]);
            return (CommandExecutor)result;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public static class PrefixArgData
    extends ArgData {
        public String prefix;
        public boolean throwTypeError;
    }

    public static abstract class ArgData {
        public Class type;
        public boolean required;
    }

    public static interface CommandExecutor {
        public void execute(ScriptEntry var1);
    }
}

