/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.debugging;

import com.denizenscript.denizen.utilities.AdvancedTextImpl;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizen.utilities.implementation.DenizenCoreImplementation;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.core.ConsoleOutputScriptEvent;
import com.denizenscript.denizencore.events.core.ScriptGeneratesErrorScriptEvent;
import com.denizenscript.denizencore.events.core.ServerGeneratesExceptionScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.CommandExecutor;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class Debug {
    public static boolean showStackTraces = true;
    public static boolean showColor = true;
    public static boolean showSources = false;
    public static boolean shouldTrim = true;
    public static boolean errorDuplicatePrevention = false;
    public static String lastErrorHeader = "";
    public static String ENABLE_DEBUG_MESSAGE = ChatColor.GRAY + " ... " + ChatColor.RED + "Enable debug on the script for more information.";
    public static String ERROR_HEADER_START = ChatColor.LIGHT_PURPLE + " " + ChatColor.RED + "ERROR";
    public static String ERROR_HEADER_END = "!\n" + ChatColor.GRAY + "<FORCE_ALIGN>Error Message: " + ChatColor.WHITE;
    public static String ADDITIONAL_ERROR_HEADER = ChatColor.GRAY + "Additional Error Info: " + ChatColor.WHITE;
    static long depthCorrectError = 0L;
    private static boolean throwErrorEvent = true;
    private static final Map<Class<?>, String> classNameCache = new WeakHashMap();
    private static boolean canGetClass = true;
    public static int outputThisTick = 0;

    public static void toggle() {
        CoreConfiguration.shouldShowDebug = !CoreConfiguration.shouldShowDebug;
    }

    public static void onTick() {
        outputThisTick = 0;
        errorDuplicatePrevention = false;
        lastErrorHeader = "";
    }

    public static Consumer<String> getDebugSender(Debuggable caller) {
        if (caller == null) {
            caller = CommandExecutor.currentQueue;
        }
        if (caller instanceof TagContext && ((TagContext)caller).entry != null) {
            caller = ((TagContext)caller).entry;
        }
        if (caller instanceof ScriptEntry && ((ScriptEntry)caller).getResidingQueue() != null) {
            caller = ((ScriptEntry)caller).getResidingQueue();
        }
        if (caller instanceof ScriptQueue) {
            return ((ScriptQueue)caller).debugOutput;
        }
        return null;
    }

    public static void report(Debuggable caller, String name, Object ... values) {
        if (!CoreConfiguration.shouldShowDebug || !Debug.shouldDebug(caller)) {
            return;
        }
        StringBuilder output = new StringBuilder();
        for (Object obj : values) {
            if (obj == null) continue;
            if (obj instanceof ObjectTag) {
                ObjectTag objTag = (ObjectTag)obj;
                output.append("<G>").append(objTag.getPrefix()).append("='<Y>").append(objTag.debuggable()).append("<G>'  ");
                continue;
            }
            output.append(obj);
        }
        Debug.echo("<Y>+> <G>Executing '<Y>" + name + "<G>': " + Debug.trimMessage(output.toString()), caller);
    }

    public static void report(Debuggable caller, String name, String report) {
        if (!CoreConfiguration.shouldShowDebug || !Debug.shouldDebug(caller)) {
            return;
        }
        Debug.echo("<Y>+> <G>Executing '<Y>" + name + "<G>': " + Debug.trimMessage(report), caller);
    }

    public static void echoDebug(Debuggable caller, Debug.DebugElement element) {
        if (!CoreConfiguration.shouldShowDebug || !Debug.shouldDebug(caller)) {
            return;
        }
        Debug.echoDebug(caller, element, null);
    }

    public static void echoDebug(Debuggable caller, Debug.DebugElement element, String string) {
        if (!CoreConfiguration.shouldShowDebug || !Debug.shouldDebug(caller)) {
            return;
        }
        StringBuilder sb = new StringBuilder(24);
        switch (element) {
            case Footer: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+---------------------+");
                break;
            }
            case Header: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+- ").append(string).append(ChatColor.LIGHT_PURPLE).append(" ---------+");
            }
        }
        Debug.echo(sb.toString(), caller);
    }

    public static void echoDebug(Debuggable caller, String message) {
        if (!CoreConfiguration.shouldShowDebug || !Debug.shouldDebug(caller)) {
            return;
        }
        Debug.echo(ChatColor.WHITE + Debug.trimMessage(message), caller);
        if (CoreConfiguration.debugVerbose && caller != null) {
            Debug.echo(ChatColor.GRAY + "(Verbose) Caller = " + caller, caller);
        }
    }

    public static void echoApproval(String message) {
        if (!CoreConfiguration.shouldShowDebug) {
            return;
        }
        Debug.finalOutputDebugText(ChatColor.GREEN + "OKAY! " + ChatColor.WHITE + message, null);
    }

    public static void echoError(String message) {
        Debug.echoError(null, null, message, true);
    }

    public static void echoError(ScriptEntry source, String message) {
        Debug.echoError(source, null, message, true);
    }

    public static void echoError(ScriptEntry source, String addedContext, String message, boolean reformat) {
        message = Debug.cleanTextForDebugOutput(message);
        if (errorDuplicatePrevention) {
            if (!CoreConfiguration.debugVerbose) {
                Debug.finalOutputDebugText("Error within error (??!!!! SOMETHING WENT SUPER WRONG!): " + message, source, reformat);
            }
            return;
        }
        errorDuplicatePrevention = true;
        ScriptQueue sourceQueue = CommandExecutor.currentQueue;
        if (source == null && sourceQueue != null) {
            source = sourceQueue.getLastEntryExecuted();
        }
        if (source != null && source.queue != null) {
            sourceQueue = source.queue;
        }
        ScriptTag sourceScript = null;
        if (source != null) {
            sourceScript = source.getScript();
        }
        if (throwErrorEvent) {
            throwErrorEvent = false;
            boolean cancel = ScriptGeneratesErrorScriptEvent.instance.handle(message, sourceQueue, sourceScript, source == null ? -1 : source.internal.lineNumber);
            throwErrorEvent = true;
            if (cancel) {
                errorDuplicatePrevention = false;
                return;
            }
        }
        if (!CoreConfiguration.shouldShowDebug) {
            errorDuplicatePrevention = false;
            return;
        }
        StringBuilder headerBuilder = new StringBuilder();
        headerBuilder.append(ERROR_HEADER_START);
        if (sourceScript != null) {
            headerBuilder.append(" in script '").append(ChatColor.AQUA).append(sourceScript.getName()).append(ChatColor.RED).append("'");
        }
        if (sourceQueue != null) {
            headerBuilder.append(" in queue '").append(sourceQueue.debugId).append(ChatColor.RED).append("'");
        }
        if (source != null) {
            BukkitScriptEntryData data;
            headerBuilder.append(" while executing command '").append(ChatColor.AQUA).append(source.getCommandName()).append(ChatColor.RED).append("'");
            if (sourceScript != null) {
                headerBuilder.append(" in file '").append(ChatColor.AQUA).append(sourceScript.getContainer().getRelativeFileName()).append(ChatColor.RED).append("' on line '").append(ChatColor.AQUA).append(source.internal.lineNumber).append(ChatColor.RED).append("'");
            }
            if ((data = Utilities.getEntryData(source)).hasPlayer()) {
                headerBuilder.append(" with player '").append(ChatColor.AQUA).append(data.getPlayer().getName()).append(ChatColor.RED).append("'");
            }
            if (data.hasNPC()) {
                headerBuilder.append(" with NPC '").append(ChatColor.AQUA).append(data.getNPC().debuggable()).append(ChatColor.RED).append("'");
            }
        }
        if (addedContext != null) {
            headerBuilder.append("\n<FORCE_ALIGN>").append(addedContext);
        }
        headerBuilder.append(ERROR_HEADER_END);
        String header = headerBuilder.toString();
        boolean showDebugSuffix = sourceScript != null && !sourceScript.getContainer().shouldDebug();
        String headerRef = header;
        if (header.equals(lastErrorHeader)) {
            header = ADDITIONAL_ERROR_HEADER;
            showDebugSuffix = false;
        }
        Debug.finalOutputDebugText(header + message + (showDebugSuffix ? ENABLE_DEBUG_MESSAGE : ""), sourceQueue, reformat);
        errorDuplicatePrevention = false;
        if (CoreConfiguration.debugVerbose && depthCorrectError == 0L) {
            ++depthCorrectError;
            try {
                throw new RuntimeException("Verbose info for above error");
            }
            catch (Throwable e) {
                Debug.echoError(source, e);
                --depthCorrectError;
            }
        }
        lastErrorHeader = headerRef;
    }

    public static void echoError(Throwable ex) {
        Debug.echoError(null, ex);
    }

    public static void echoError(ScriptEntry source, Throwable ex) {
        String errorMessage = Debug.getFullExceptionMessage(ex, true);
        if (throwErrorEvent) {
            throwErrorEvent = false;
            Throwable thrown = ex;
            while (thrown.getCause() != null) {
                thrown = thrown.getCause();
            }
            ScriptQueue sourceQueue = CommandExecutor.currentQueue;
            if (source != null && source.queue != null) {
                sourceQueue = source.queue;
            }
            ScriptTag sourceScript = null;
            if (source != null) {
                sourceScript = source.getScript();
            }
            boolean cancel = ServerGeneratesExceptionScriptEvent.instance.handle(thrown, errorMessage, sourceQueue, sourceScript, source == null ? -1 : source.internal.lineNumber);
            throwErrorEvent = true;
            if (cancel) {
                return;
            }
        }
        if (!CoreConfiguration.shouldShowDebug) {
            return;
        }
        boolean wasThrown = throwErrorEvent;
        throwErrorEvent = false;
        if (!showStackTraces) {
            Debug.echoError(source, "Exception! Enable '/denizen debug -s' for the nitty-gritty.");
        } else {
            ++depthCorrectError;
            Debug.echoError(source, null, errorMessage, false);
            --depthCorrectError;
        }
        throwErrorEvent = wasThrown;
    }

    public static String getFullExceptionMessage(Throwable ex, boolean includeBounding) {
        StringBuilder errorMessage = new StringBuilder();
        if (includeBounding) {
            errorMessage.append("Internal exception was thrown!\n");
        }
        String prefix = includeBounding ? ChatColor.GRAY + "[Error Continued] " + ChatColor.WHITE : "";
        boolean first = true;
        while (ex != null) {
            errorMessage.append(prefix);
            if (!first) {
                errorMessage.append("Caused by: ");
            }
            errorMessage.append(ex).append("\n");
            for (StackTraceElement ste : ex.getStackTrace()) {
                errorMessage.append(prefix).append("  ").append(ste.toString()).append("\n");
            }
            if (ex.getCause() == ex) break;
            ex = ex.getCause();
            first = false;
        }
        return errorMessage.toString();
    }

    public static void log(String message) {
        if (!CoreConfiguration.shouldShowDebug) {
            return;
        }
        String callerName = "<JVM-Block>";
        try {
            if (canGetClass) {
                Class caller;
                Class[] classes = new SecurityManagerTrick().getClassContext();
                Class clazz = caller = classes.length > 2 ? classes[2] : Debug.class;
                if (caller == DenizenCoreImplementation.class) {
                    Class clazz2 = caller = classes.length > 4 ? classes[4] : Debug.class;
                }
                if ((callerName = classNameCache.get(caller)) == null) {
                    callerName = caller.getSimpleName();
                    classNameCache.put(caller, callerName);
                }
                callerName = callerName.length() > 16 ? callerName.substring(0, 12) + "..." : callerName;
            }
        }
        catch (Throwable ex) {
            canGetClass = false;
        }
        Debug.finalOutputDebugText(ChatColor.YELLOW + "+> [" + callerName + "] " + ChatColor.WHITE + Debug.trimMessage(message), null);
    }

    public static void log(String caller, String message) {
        if (!CoreConfiguration.shouldShowDebug) {
            return;
        }
        Debug.finalOutputDebugText(ChatColor.YELLOW + "+> [" + caller + "] " + ChatColor.WHITE + Debug.trimMessage(message), null);
    }

    public static void log(Debug.DebugElement element, String message) {
        if (!CoreConfiguration.shouldShowDebug) {
            return;
        }
        StringBuilder sb = new StringBuilder(24);
        switch (element) {
            case Footer: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+---------------------+");
                break;
            }
            case Header: {
                sb.append(ChatColor.LIGHT_PURPLE).append("+- ").append(message).append(" ---------+");
                break;
            }
        }
        Debug.finalOutputDebugText(sb.toString(), null);
    }

    private static String trimMessage(String message) {
        if (!shouldTrim) {
            return message;
        }
        int trimSize = Settings.trimLength();
        if (message.length() > trimSize) {
            message = message.substring(0, trimSize - 1) + "... * snip! *";
        }
        return message;
    }

    @Deprecated
    public static boolean shouldDebug(Debuggable caller) {
        return com.denizenscript.denizencore.utilities.debugging.Debug.shouldDebug(caller);
    }

    private static void echo(String string, Debuggable caller) {
        ScriptEntry sent;
        if (!Debug.shouldDebug(caller)) {
            return;
        }
        if (!showSources || caller == null) {
            Debug.finalOutputDebugText(string, caller);
            return;
        }
        String callerId = caller instanceof ScriptContainer ? "Script:" + ((ScriptContainer)caller).getName() : (caller instanceof ScriptEntry ? (((ScriptEntry)caller).getScript() != null ? "Command:" + ((ScriptEntry)caller).getCommandName() + " in Script:" + ((ScriptEntry)caller).getScript().getName() : "Command:" + ((ScriptEntry)caller).getCommandName()) : (caller instanceof ScriptQueue ? (((ScriptQueue)caller).script != null ? "Queue:" + ((ScriptQueue)caller).id + " running Script:" + ((ScriptQueue)caller).script.getName() : "Queue:" + ((ScriptQueue)caller).id) : (caller instanceof TagContext ? (((TagContext)caller).entry != null ? ((sent = ((TagContext)caller).entry).getScript() != null ? "Tag in Command:" + sent.getCommandName() + " in Script:" + sent.getScript().getName() : "Tag in Command:" + sent.getCommandName()) : (((TagContext)caller).script != null ? "Tag in Script:" + ((TagContext)caller).script.getName() : "Tag:" + caller)) : caller.toString())));
        Debug.finalOutputDebugText(ChatColor.DARK_GRAY + "[Src:" + ChatColor.GRAY + callerId + ChatColor.DARK_GRAY + "] " + ChatColor.WHITE + string, caller);
    }

    static void finalOutputDebugText(String message, Debuggable caller) {
        Debug.finalOutputDebugText(message, caller, true);
    }

    public static String cleanTextForDebugOutput(String message) {
        return message.replace("<Y>", ChatColor.YELLOW.toString()).replace("<O>", ChatColor.GOLD.toString()).replace("<G>", ChatColor.DARK_GRAY.toString()).replace("<LG>", ChatColor.GRAY.toString()).replace("<GR>", ChatColor.GREEN.toString()).replace("<A>", ChatColor.AQUA.toString()).replace("<R>", ChatColor.DARK_RED.toString()).replace("<LR>", ChatColor.RED.toString()).replace("<W>", ChatColor.WHITE.toString());
    }

    static void finalOutputDebugText(String message, Debuggable caller, boolean reformat) {
        lastErrorHeader = "";
        if (++outputThisTick >= Settings.debugLimitPerTick()) {
            if (outputThisTick == Settings.debugLimitPerTick()) {
                ConsoleSender.sendMessage("... Debug rate limit per-tick hit, edit config.yml to adjust this limit...", true);
            }
            return;
        }
        message = Debug.cleanTextForDebugOutput(message);
        ConsoleSender.sendMessage(message, reformat);
        Consumer<String> additional = Debug.getDebugSender(caller);
        if (additional != null) {
            additional.accept(message);
        }
    }

    private static class SecurityManagerTrick
    extends SecurityManager {
        private SecurityManagerTrick() {
        }

        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }

    private static class ConsoleSender {
        static CommandSender commandSender = null;
        public static SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        static boolean skipFooter = false;

        private ConsoleSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void sendMessage(String string, boolean reformat) {
            if (commandSender == null) {
                commandSender = Bukkit.getServer().getConsoleSender();
            }
            if (string.equals(ChatColor.LIGHT_PURPLE + "+---------------------+")) {
                if (skipFooter) return;
                skipFooter = true;
            } else {
                skipFooter = false;
            }
            string = string.replace('\u0000', ' ');
            if (reformat) {
                String[] words = string.split(" ");
                StringBuilder buffer = new StringBuilder();
                int length = 0;
                int width = Settings.consoleWidth();
                for (String word : words) {
                    int strippedLength = ChatColor.stripColor((String)word).length() + 1;
                    if (length + strippedLength < width) {
                        buffer.append(word).append(" ");
                        length += strippedLength;
                    } else {
                        length = strippedLength;
                        buffer.append("\n<FORCE_ALIGN>").append(word).append(" ");
                    }
                    if (!word.contains("\n")) continue;
                    length = 0;
                }
                string = buffer.toString();
            }
            if (CoreConfiguration.shouldRecordDebug) {
                try {
                    String toRecord = " " + string.replace("<FORCE_ALIGN>", "        ") + "\n";
                    com.denizenscript.denizencore.utilities.debugging.Debug.debugRecording.append(URLEncoder.encode(dateFormat.format(new Date()) + toRecord, "UTF-8"));
                }
                catch (Throwable ex) {
                    Debug.echoError(ex);
                }
            }
            string = Settings.debugPrefix() + string.replace("<FORCE_ALIGN>", "                 ");
            if (DenizenCore.logInterceptor.redirected && !DenizenCore.logInterceptor.antiLoop) {
                DenizenCore.logInterceptor.antiLoop = true;
                try {
                    ConsoleOutputScriptEvent event = ConsoleOutputScriptEvent.instance;
                    event.message = string;
                    event = (ConsoleOutputScriptEvent)event.fire();
                    if (event.cancelled) {
                        return;
                    }
                }
                finally {
                    DenizenCore.logInterceptor.antiLoop = false;
                }
            }
            if (showColor) {
                AdvancedTextImpl.instance.sendConsoleMessage(commandSender, string);
                return;
            } else {
                commandSender.sendMessage(ChatColor.stripColor((String)string));
            }
        }
    }
}

