/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.bukkit;

import com.denizenscript.denizen.objects.BiomeTag;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.ColorTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.EnchantmentTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PluginTag;
import com.denizenscript.denizen.objects.PolygonTag;
import com.denizenscript.denizen.objects.TradeTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.scripts.containers.core.FormatScriptContainer;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.tags.core.CustomColorTagBase;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.TextWidthHelper;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.AsciiMatcher;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import java.nio.charset.StandardCharsets;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Color;

public class BukkitElementProperties
implements Property {
    public static final String[] handledMechs = new String[0];
    ElementTag element;
    public static AsciiMatcher FORMAT_CODES_MATCHER = new AsciiMatcher("klmnoKLMNO");

    public static boolean describes(ObjectTag element) {
        return element instanceof ElementTag;
    }

    public static BukkitElementProperties getFrom(ObjectTag element) {
        if (!BukkitElementProperties.describes(element)) {
            return null;
        }
        return new BukkitElementProperties((ElementTag)element);
    }

    private BukkitElementProperties(ElementTag element) {
        this.element = element;
    }

    public static String replaceEssentialsHexColors(char prefix, String input) {
        int hex = input.indexOf(prefix + "#");
        while (hex != -1 && hex < input.length() + 8) {
            StringBuilder converted = new StringBuilder(10);
            converted.append('\u00a7').append("x");
            for (int i = 0; i < 6; ++i) {
                char c = input.charAt(hex + 2 + i);
                if (!ArgumentHelper.HEX_MATCHER.isMatch(c)) {
                    return input;
                }
                converted.append('\u00a7').append(c);
            }
            input = input.substring(0, hex) + converted + input.substring(hex + 8);
            hex = input.indexOf(prefix + "#", hex + 2);
        }
        return input;
    }

    public static void registerTags() {
        PropertyParser.registerStaticTag(BukkitElementProperties.class, BiomeTag.class, "as_biome", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), BiomeTag.valueOf(object.asString(), attribute.context), "BiomeTag", attribute.hasAlternative());
        }, new String[0]);
        PropertyParser.registerTag(BukkitElementProperties.class, ChunkTag.class, "as_chunk", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), ChunkTag.valueOf(object.asString(), attribute.context), "ChunkTag", attribute.hasAlternative());
        }, "aschunk");
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ColorTag.class, "as_color", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), ColorTag.valueOf(object.asString(), attribute.context), "ColorTag", attribute.hasAlternative());
        }, "ascolor");
        PropertyParser.registerTag(BukkitElementProperties.class, CuboidTag.class, "as_cuboid", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), CuboidTag.valueOf(object.asString(), attribute.context), "CuboidTag", attribute.hasAlternative());
        }, "ascuboid");
        PropertyParser.registerTag(BukkitElementProperties.class, EllipsoidTag.class, "as_ellipsoid", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), EllipsoidTag.valueOf(object.asString(), attribute.context), "EllipsoidTag", attribute.hasAlternative());
        }, new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, EnchantmentTag.class, "as_enchantment", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), EnchantmentTag.valueOf(object.asString(), attribute.context), "EnchantmentTag", attribute.hasAlternative());
        }, new String[0]);
        PropertyParser.registerTag(BukkitElementProperties.class, EntityTag.class, "as_entity", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), EntityTag.valueOf(object.asString(), attribute.context), "EntityTag", attribute.hasAlternative());
        }, "asentity");
        PropertyParser.registerTag(BukkitElementProperties.class, InventoryTag.class, "as_inventory", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), InventoryTag.valueOf(object.asString(), attribute.context), "InventoryTag", attribute.hasAlternative());
        }, "asinventory");
        PropertyParser.registerTag(BukkitElementProperties.class, ItemTag.class, "as_item", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), ItemTag.valueOf(object.asString(), attribute.context), "ItemTag", attribute.hasAlternative());
        }, "asitem");
        PropertyParser.registerTag(BukkitElementProperties.class, LocationTag.class, "as_location", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), LocationTag.valueOf(object.asString(), attribute.context), "LocationTag", attribute.hasAlternative());
        }, "aslocation");
        PropertyParser.registerStaticTag(BukkitElementProperties.class, MaterialTag.class, "as_material", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), MaterialTag.valueOf(object.asString(), attribute.context), "MaterialTag", attribute.hasAlternative());
        }, "asmaterial");
        PropertyParser.registerTag(BukkitElementProperties.class, NPCTag.class, "as_npc", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), NPCTag.valueOf(object.asString(), attribute.context), "NPCTag", attribute.hasAlternative());
        }, "asnpc");
        PropertyParser.registerTag(BukkitElementProperties.class, PlayerTag.class, "as_player", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), PlayerTag.valueOf(object.asString(), attribute.context), "PlayerTag", attribute.hasAlternative());
        }, "asplayer");
        PropertyParser.registerStaticTag(BukkitElementProperties.class, PluginTag.class, "as_plugin", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), PluginTag.valueOf(object.asString(), attribute.context), "PluginTag", attribute.hasAlternative());
        }, "asplugin");
        PropertyParser.registerTag(BukkitElementProperties.class, PolygonTag.class, "as_polygon", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), PolygonTag.valueOf(object.asString(), attribute.context), "PolygonTag", attribute.hasAlternative());
        }, new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, TradeTag.class, "as_trade", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), TradeTag.valueOf(object.asString(), attribute.context), "TradeTag", attribute.hasAlternative());
        }, new String[0]);
        PropertyParser.registerTag(BukkitElementProperties.class, WorldTag.class, "as_world", (attribute, object) -> {
            Deprecations.asXTags.warn(attribute.context);
            return ElementTag.handleNull(object.asString(), WorldTag.valueOf(object.asString(), attribute.context), "WorldTag", attribute.hasAlternative());
        }, "asworld");
        PropertyParser.registerTag(BukkitElementProperties.class, ElementTag.class, ScriptTag.class, "format", (attribute, object, format) -> {
            if (!(format.getContainer() instanceof FormatScriptContainer)) {
                attribute.echoError("Script '" + format + "' is not a format script.");
                return null;
            }
            return new ElementTag(((FormatScriptContainer)format.getContainer()).getFormattedText(object.asString(), attribute.getScriptEntry() != null ? ((BukkitScriptEntryData)attribute.getScriptEntry().entryData).getNPC() : null, attribute.getScriptEntry() != null ? ((BukkitScriptEntryData)attribute.getScriptEntry().entryData).getPlayer() : null));
        }, new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, ElementTag.class, "split_lines_by_width", (attribute, object, widthText) -> new ElementTag(TextWidthHelper.splitLines(object.asString(), widthText.asInt())), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "text_width", (attribute, object) -> new ElementTag(TextWidthHelper.getWidth(object.asString())), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ListTag.class, "lines_to_colored_list", (attribute, object) -> {
            ListTag output = new ListTag();
            String colors = "";
            for (String line : CoreUtilities.split(object.asString(), '\n')) {
                output.add(colors + line);
                colors = org.bukkit.ChatColor.getLastColors((String)(colors + line));
            }
            return output;
        }, new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "last_color", (attribute, object) -> new ElementTag(org.bukkit.ChatColor.getLastColors((String)object.asString())), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "strip_color", (attribute, object) -> new ElementTag(FormattedTextHelper.parse(object.asString(), ChatColor.WHITE)[0].toPlainText()), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "parse_color", (attribute, object) -> {
            char prefix = '&';
            if (attribute.hasParam()) {
                prefix = attribute.getParam().charAt(0);
            }
            String parsed = ChatColor.translateAlternateColorCodes((char)prefix, (String)object.asString());
            parsed = BukkitElementProperties.replaceEssentialsHexColors(prefix, parsed);
            return new ElementTag(parsed);
        }, new String[0]);
        PropertyParser.registerTag(BukkitElementProperties.class, ElementTag.class, "to_itemscript_hash", (attribute, object) -> new ElementTag(ItemScriptHelper.createItemScriptID(object.asString())), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "to_secret_colors", (attribute, object) -> {
            String text = object.asString();
            byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
            String hex = CoreUtilities.hexEncode(bytes);
            StringBuilder colors = new StringBuilder(text.length() * 2);
            for (int i = 0; i < hex.length(); ++i) {
                colors.append('\u00a7').append(hex.charAt(i));
            }
            return new ElementTag(colors.toString());
        }, new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "from_secret_colors", (attribute, object) -> {
            String text = object.asString().replace(String.valueOf('\u00a7'), "");
            byte[] bytes = CoreUtilities.hexDecode(text);
            return new ElementTag(new String(bytes, StandardCharsets.UTF_8));
        }, new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "to_raw_json", (attribute, object) -> new ElementTag(ComponentSerializer.toString((BaseComponent[])FormattedTextHelper.parse(object.asString(), ChatColor.WHITE))), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "from_raw_json", (attribute, object) -> new ElementTag(FormattedTextHelper.stringify(ComponentSerializer.parse((String)object.asString()), ChatColor.WHITE)), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, ItemTag.class, "hover_item", (attribute, object, item) -> new ElementTag("\u00a7[hover=SHOW_ITEM;" + FormattedTextHelper.escape(item.identify()) + "]" + object.asString() + '\u00a7' + "[/hover]"), new String[0]);
        PropertyParser.registerTag(BukkitElementProperties.class, ElementTag.class, ElementTag.class, "on_hover", (attribute, object, hoverText) -> {
            String type = "SHOW_TEXT";
            if (attribute.startsWith("type", 2)) {
                type = attribute.getContext(2);
                attribute.fulfill(1);
            }
            return new ElementTag("\u00a7[hover=" + type + ";" + FormattedTextHelper.escape(hoverText.toString()) + "]" + object.asString() + '\u00a7' + "[/hover]");
        }, new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, ElementTag.class, "click_url", (attribute, object, url) -> new ElementTag("\u00a7[click=OPEN_URL;" + FormattedTextHelper.escape(url.toString()) + "]" + object.asString() + '\u00a7' + "[/click]"), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, ElementTag.class, "click_chat", (attribute, object, chat) -> new ElementTag("\u00a7[click=RUN_COMMAND;/denizenclickable chat " + FormattedTextHelper.escape(chat.toString()) + "]" + object.asString() + '\u00a7' + "[/click]"), new String[0]);
        PropertyParser.registerTag(BukkitElementProperties.class, ElementTag.class, ElementTag.class, "on_click", (attribute, object, command) -> {
            String type = "RUN_COMMAND";
            if (attribute.startsWith("type", 2)) {
                type = attribute.getContext(2);
                attribute.fulfill(1);
            }
            return new ElementTag("\u00a7[click=" + type + ";" + FormattedTextHelper.escape(command.asString()) + "]" + object.asString() + '\u00a7' + "[/click]");
        }, new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, ElementTag.class, "with_insertion", (attribute, object, insertion) -> new ElementTag("\u00a7[insertion=" + FormattedTextHelper.escape(insertion.asString()) + "]" + object.asString() + '\u00a7' + "[/insertion]"), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "no_reset", (attribute, object) -> {
            if (object.asString().length() == 2 && object.asString().charAt(0) == '\u00a7') {
                return new ElementTag("\u00a7[color=" + object.asString().charAt(1) + "]");
            }
            return null;
        }, new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "end_format", (attribute, object) -> {
            if (object.asString().length() == 2 && object.asString().charAt(0) == '\u00a7') {
                return new ElementTag("\u00a7[reset=" + object.asString().charAt(1) + "]");
            }
            if (object.asString().startsWith("\u00a7[font=") && object.asString().endsWith("]")) {
                return new ElementTag("\u00a7[reset=font]");
            }
            return null;
        }, new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "italicize", (attribute, object) -> new ElementTag(ChatColor.ITALIC + object.asString() + '\u00a7' + "[reset=o]"), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "bold", (attribute, object) -> new ElementTag(ChatColor.BOLD + object.asString() + '\u00a7' + "[reset=l]"), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "underline", (attribute, object) -> new ElementTag(ChatColor.UNDERLINE + object.asString() + '\u00a7' + "[reset=n]"), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "strikethrough", (attribute, object) -> new ElementTag(ChatColor.STRIKETHROUGH + object.asString() + '\u00a7' + "[reset=m]"), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "obfuscate", (attribute, object) -> new ElementTag(ChatColor.MAGIC + object.asString() + '\u00a7' + "[reset=k]"), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, ElementTag.class, "custom_color", (attribute, object, name) -> new ElementTag("\u00a7[color=f]" + CustomColorTagBase.getColor(name.asLowerString(), attribute.context) + object.asString() + '\u00a7' + "[reset=color]"), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, ElementTag.class, "color", (attribute, object, colorElement) -> {
            ChatColor color;
            String colorName = colorElement.asString();
            String colorOut = null;
            if (colorName.length() == 1) {
                color = ChatColor.getByChar((char)colorName.charAt(0));
                if (color != null) {
                    colorOut = color.toString();
                }
            } else {
                if (colorName.length() == 7 && colorName.startsWith("#")) {
                    return new ElementTag("\u00a7[color=" + colorName + "]" + object.asString() + '\u00a7' + "[reset=color]");
                }
                if (colorName.length() == 14 && colorName.startsWith("\u00a7x")) {
                    return new ElementTag("\u00a7[color=#" + CoreUtilities.replace(colorName.substring(2), String.valueOf('\u00a7'), "") + "]" + object.asString() + '\u00a7' + "[reset=color]");
                }
                if (colorName.startsWith("co@")) {
                    ColorTag color2 = ColorTag.valueOf(colorName, attribute.context);
                    StringBuilder hex = new StringBuilder(Integer.toHexString(color2.getColor().asRGB()));
                    while (hex.length() < 6) {
                        hex.insert(0, "0");
                    }
                    return new ElementTag("\u00a7[color=#" + hex + "]" + object.asString() + '\u00a7' + "[reset=color]");
                }
            }
            if (colorOut == null) {
                try {
                    color = ChatColor.of((String)colorName.toUpperCase());
                    String colorStr = color.toString().replace(String.valueOf('\u00a7'), "").replace("x", "#");
                    colorOut = "\u00a7[color=" + colorStr + "]";
                }
                catch (IllegalArgumentException ex) {
                    attribute.echoError("Color '" + colorName + "' doesn't exist (for ElementTag.color[...]).");
                    return null;
                }
            }
            return new ElementTag(colorOut + object.asString() + '\u00a7' + "[reset=color]");
        }, new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, ElementTag.class, "font", (attribute, object, fontName) -> new ElementTag("\u00a7[font=" + fontName + "]" + object.asString() + '\u00a7' + "[reset=font]"), new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "rainbow", (attribute, object) -> {
            String str = object.asString();
            String pattern = "4c6e2ab319d5";
            if (attribute.hasParam()) {
                pattern = attribute.getParam();
            }
            StringBuilder output = new StringBuilder(str.length() * 3);
            for (int i = 0; i < str.length(); ++i) {
                output.append('\u00a7').append(pattern.charAt(i % pattern.length())).append(str.charAt(i));
            }
            return new ElementTag(output.toString());
        }, new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, "hex_rainbow", (attribute, object) -> {
            String str = object.asString();
            int[] HSB = new int[]{0, 255, 255};
            if (str.startsWith("\u00a7x") && str.length() > 14) {
                char[] colors = new char[6];
                for (int i = 0; i < 6; ++i) {
                    colors[i] = str.charAt(3 + i * 2);
                }
                int rgb = Integer.parseInt(new String(colors), 16);
                HSB = new ColorTag(Color.fromRGB((int)rgb)).toHSB();
                str = str.substring(14);
            }
            float hue = (float)HSB[0] / 255.0f;
            int length = ChatColor.stripColor((String)str).length();
            if (length == 0) {
                return new ElementTag("");
            }
            if (attribute.hasParam()) {
                length = attribute.getIntParam();
            }
            float increment = 1.0f / (float)length;
            String addedFormat = "";
            StringBuilder output = new StringBuilder(str.length() * 8);
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (c == '\u00a7' && i + 1 < str.length()) {
                    char c2 = str.charAt(i + 1);
                    addedFormat = FORMAT_CODES_MATCHER.isMatch(c2) ? addedFormat + String.valueOf('\u00a7') + c2 : "";
                    ++i;
                    continue;
                }
                String hex = Integer.toHexString(ColorTag.fromHSB(HSB).getColor().asRGB());
                output.append(FormattedTextHelper.stringifyRGBSpigot(hex)).append(addedFormat).append(c);
                HSB[0] = Math.round((hue += increment) * 255.0f);
            }
            return new ElementTag(output.toString());
        }, new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, MapTag.class, "color_gradient", (attribute, object, inputMap) -> {
            ColorTag fromColor = inputMap.getRequiredObjectAs("from", ColorTag.class, attribute);
            ColorTag toColor = inputMap.getRequiredObjectAs("to", ColorTag.class, attribute);
            ElementTag style = inputMap.getElement("style", "RGB");
            if (fromColor == null || toColor == null) {
                return null;
            }
            if (!style.matchesEnum(GradientStyle.class)) {
                attribute.echoError("Invalid gradient style '" + style + "'");
                return null;
            }
            String res = BukkitElementProperties.doGradient(object.asString(), fromColor, toColor, style.asEnum(GradientStyle.class));
            if (res == null) {
                return null;
            }
            return new ElementTag(res);
        }, new String[0]);
        PropertyParser.registerStaticTag(BukkitElementProperties.class, ElementTag.class, MapTag.class, "hsb_color_gradient", (attribute, object, inputMap) -> {
            BukkitImplDeprecations.hsbColorGradientTag.warn(attribute.context);
            ColorTag fromColor = inputMap.getRequiredObjectAs("from", ColorTag.class, attribute);
            ColorTag toColor = inputMap.getRequiredObjectAs("to", ColorTag.class, attribute);
            if (fromColor == null || toColor == null) {
                return null;
            }
            String res = BukkitElementProperties.doGradient(object.asString(), fromColor, toColor, GradientStyle.HSB);
            if (res == null) {
                return null;
            }
            return new ElementTag(res);
        }, new String[0]);
    }

    public static String doGradient(String str, ColorTag fromColor, ColorTag toColor, GradientStyle style) {
        float toB;
        float toG;
        float toR;
        float b;
        float g;
        float r;
        int length = FormattedTextHelper.parse(str, ChatColor.WHITE)[0].toPlainText().length();
        if (length == 0) {
            return "";
        }
        if (fromColor == null || toColor == null) {
            return null;
        }
        float x = 0.0f;
        float xMove = 0.0f;
        int[] hsbHelper = null;
        if (style == GradientStyle.RGB) {
            r = ColorTag.fromSRGB(fromColor.getColor().getRed());
            g = ColorTag.fromSRGB(fromColor.getColor().getGreen());
            b = ColorTag.fromSRGB(fromColor.getColor().getBlue());
            x = (float)Math.pow(r + g + b, 0.43);
            toR = ColorTag.fromSRGB(toColor.getColor().getRed());
            toG = ColorTag.fromSRGB(toColor.getColor().getGreen());
            toB = ColorTag.fromSRGB(toColor.getColor().getBlue());
            float toBrightness = (float)Math.pow(toR + toG + toB, 0.43);
            xMove = (toBrightness - x) / (float)length;
        } else {
            hsbHelper = fromColor.toHSB();
            int[] toHSB = toColor.toHSB();
            r = hsbHelper[0];
            g = hsbHelper[1];
            b = hsbHelper[2];
            toR = toHSB[0];
            toG = toHSB[1];
            toB = toHSB[2];
        }
        float rMove = (toR - r) / (float)length;
        float gMove = (toG - g) / (float)length;
        float bMove = (toB - b) / (float)length;
        String addedFormat = "";
        StringBuilder output = new StringBuilder(str.length() * 15);
        for (int i = 0; i < str.length(); ++i) {
            String hex;
            char c = str.charAt(i);
            if (c == '\u00a7' && i + 1 < str.length()) {
                char c2 = str.charAt(i + 1);
                if (FORMAT_CODES_MATCHER.isMatch(c2)) {
                    addedFormat = addedFormat + String.valueOf('\u00a7') + c2;
                } else if (c2 == '[') {
                    int endBracket = str.indexOf(93, i);
                    if (endBracket != -1) {
                        addedFormat = addedFormat + str.substring(i, endBracket + 1);
                        i = endBracket - 1;
                    }
                } else {
                    addedFormat = "";
                }
                ++i;
                continue;
            }
            if (style == GradientStyle.RGB) {
                float newRed = r;
                float newGreen = g;
                float newBlue = b;
                float sum = newRed + newGreen + newBlue;
                if (sum > 0.0f) {
                    float multiplier = (float)Math.pow(x, 2.3255813121795654) / sum;
                    newRed *= multiplier;
                    newGreen *= multiplier;
                    newBlue *= multiplier;
                }
                newRed = ColorTag.toSRGB(newRed);
                newGreen = ColorTag.toSRGB(newGreen);
                newBlue = ColorTag.toSRGB(newBlue);
                hex = Integer.toHexString((int)newRed << 16 | (int)newGreen << 8 | (int)newBlue);
                x += xMove;
            } else {
                hsbHelper[0] = (int)r;
                hsbHelper[1] = (int)g;
                hsbHelper[2] = (int)b;
                ColorTag currentColor = ColorTag.fromHSB(hsbHelper);
                hex = Integer.toHexString(currentColor.getColor().asRGB());
            }
            output.append(FormattedTextHelper.stringifyRGBSpigot(hex)).append(addedFormat).append(str.charAt(i));
            r += rMove;
            g += gMove;
            b += bMove;
        }
        return output.toString();
    }

    public String asString() {
        return this.element.asString();
    }

    @Override
    public String getPropertyString() {
        return null;
    }

    @Override
    public String getPropertyId() {
        return "BukkitElementProperties";
    }

    @Override
    public void adjust(Mechanism mechanism) {
    }

    public static enum GradientStyle {
        RGB,
        HSB;

    }
}

