/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.npc;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import net.citizensnpcs.api.event.NPCOpenDoorEvent;
import net.citizensnpcs.api.event.NPCOpenGateEvent;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class NPCOpensScriptEvent
extends BukkitScriptEvent
implements Listener {
    public NPCTag npc;
    public LocationTag location;

    public NPCOpensScriptEvent() {
        this.registerCouldMatcher("npc opens <block>");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!new MaterialTag(this.location.getBlock()).tryAdvancedMatcher(path.eventArgLowerAt(2))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(null, this.npc);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "location": {
                return this.location;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void NPCOpenDoor(NPCOpenDoorEvent event) {
        this.npc = new NPCTag(event.getNPC());
        this.location = new LocationTag(event.getDoor().getLocation());
        this.fire((Event)event);
    }

    @EventHandler
    public void NPCOpenGate(NPCOpenGateEvent event) {
        this.npc = new NPCTag(event.getNPC());
        this.location = new LocationTag(event.getGate().getLocation());
        this.fire((Event)event);
    }
}

