/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags;

import com.denizenscript.denizencore.exceptions.TagProcessingException;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.ObjectType;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.JavaReflectedObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.commands.Comparable;
import com.denizenscript.denizencore.scripts.containers.core.ProcedureScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionRefuse;
import com.denizenscript.denizencore.utilities.ScriptUtilities;
import com.denizenscript.denizencore.utilities.codegen.TagNamer;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ObjectTagProcessor<T extends ObjectTag> {
    public HashMap<String, TagData<? extends ObjectTag, ? extends ObjectTag>> registeredObjectTags = new HashMap();
    public List<CustomMatcher<T>> custommatchers = new ArrayList<CustomMatcher<T>>();
    public Class<T> type;

    public void generateCoreTags() {
        this.registerStaticTag(ElementTag.class, "prefix", (Attribute attribute, T object) -> new ElementTag(object.getPrefix()), new String[0]);
        this.registerStaticTag(ElementTag.class, "object_type", (Attribute attribute, T object) -> new ElementTag(object.getDenizenObjectType().shortName), "type");
        this.registerTag(ObjectTag.class, "proc", (Attribute attribute, T object) -> {
            ScriptQueue queue;
            ScriptTag script;
            if (!attribute.hasParam()) {
                return null;
            }
            String path = null;
            if (attribute.getParam().indexOf(46) > 0) {
                String[] split = attribute.getParam().split("\\.", 2);
                path = split[1];
                script = ScriptTag.valueOf(split[0], attribute.context);
            } else {
                script = attribute.paramAsType(ScriptTag.class);
            }
            if (script == null) {
                attribute.echoError("Missing script for procedure script tag '" + attribute.getParam() + "'!");
                return null;
            }
            if (!(script.getContainer() instanceof ProcedureScriptContainer)) {
                attribute.echoError("Chosen script is not a procedure script!");
                return null;
            }
            ListTag definitions = new ListTag();
            definitions.addObject(object);
            if (attribute.startsWith("context", 2) && attribute.hasContext(2)) {
                definitions.objectForms.addAll(attribute.contextAsType((int)2, ListTag.class).objectForms);
                attribute.fulfill(1);
            }
            if ((queue = ScriptUtilities.createAndStartQueue(script.getContainer(), path, attribute.context.getScriptEntryData(), null, q -> {
                q.procedural = true;
            }, null, null, definitions, script.getContainer())) == null) {
                attribute.echoError("Procedure queue start failed.");
                return null;
            }
            if (queue.determinations != null && queue.determinations.size() > 0) {
                return queue.determinations.getObject(0);
            }
            return null;
        }, new String[0]);
        this.registerStaticTag(ObjectTag.class, "if_null", (Attribute attribute, T object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return object;
        }, new String[0]);
        this.registerStaticTag(ElementTag.class, "exists", (Attribute attribute, T object) -> new ElementTag(true), new String[0]);
        this.registerTag(ElementTag.class, "is_truthy", (Attribute attribute, T object) -> new ElementTag(object.isTruthy()), new String[0]);
        this.registerTag(ObjectTag.class, "null_if", (Attribute attribute, T object) -> {
            Attribute subAttribute;
            if (!attribute.hasParam()) {
                return null;
            }
            String tag = attribute.getParam();
            boolean defaultValue = tag.endsWith("||true");
            if (defaultValue) {
                tag = tag.substring(0, tag.length() - "||true".length());
            }
            try {
                subAttribute = new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            Attribute tempAttrib = new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context);
            tempAttrib.setHadAlternative(true);
            ObjectTag objs = CoreUtilities.autoAttribTyped(object, tempAttrib);
            if (objs == null ? defaultValue : CoreUtilities.equalsIgnoreCase(objs.toString(), "true")) {
                return null;
            }
            return object;
        }, new String[0]);
        this.registerTag(ObjectTag.class, "null_if_tag", (Attribute attribute, T object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            Attribute.OverridingDefinitionProvider provider = new Attribute.OverridingDefinitionProvider(attribute.context.definitionProvider);
            provider.altDefs.putObject("null_if_value", object);
            if (CoreUtilities.equalsIgnoreCase(attribute.parseDynamicParam(provider).toString(), "true")) {
                return null;
            }
            return object;
        }, new String[0]);
        this.registerTag(ElementTag.class, "is", (Attribute attribute, T object) -> {
            if (attribute.hasParam() && (attribute.startsWith("to", 2) || attribute.startsWith("than", 2)) && attribute.hasContext(2)) {
                String operator;
                boolean negative = false;
                if (attribute.getParam().startsWith("!")) {
                    operator = attribute.getParam().substring(1);
                    negative = true;
                } else {
                    operator = attribute.getParam();
                }
                attribute = attribute.fulfill(1);
                Comparable.Operator comparableOperator = Comparable.getOperatorFor(operator);
                if (comparableOperator == null) {
                    attribute.echoError("Unknown operator '" + operator + "'.");
                    return null;
                }
                return new ElementTag(Comparable.compare(object, attribute.getParamObject(), comparableOperator, negative, attribute.context));
            }
            return null;
        }, new String[0]);
        this.registerStaticTag(ListTag.class, "repeat_as_list", (Attribute attribute, T object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ObjectTag.repeat_as_list[...] must have a value.");
                return null;
            }
            int repeatTimes = attribute.getIntParam();
            ListTag result = new ListTag();
            for (int i = 0; i < repeatTimes; ++i) {
                result.addObject(object.duplicate());
            }
            return result;
        }, new String[0]);
        this.registerTag(ElementTag.class, "advanced_matches", (Attribute attribute, T object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return new ElementTag(object.tryAdvancedMatcher(attribute.getParam()));
        }, "advanced_matches_text");
        this.registerTag(JavaReflectedObjectTag.class, "reflected_internal_object", (Attribute attribute, T object) -> {
            Object obj = object.getJavaObject();
            if (!CoreConfiguration.allowReflectionFieldReads) {
                return null;
            }
            if (obj == null) {
                return null;
            }
            if (obj.getClass().isAnnotationPresent(ReflectionRefuse.class)) {
                attribute.echoError("Cannot reflect object " + object + " as its type '" + obj.getClass().getName() + "' is marked as refused for reflection.");
                return null;
            }
            return new JavaReflectedObjectTag(obj);
        }, new String[0]);
        this.registerTag(ObjectTag.class, ElementTag.class, "as", (Attribute attribute, T object, P asType) -> {
            ObjectType<? extends ObjectTag> type = ObjectFetcher.objectsByName.get(asType.asLowerString());
            if (type == null) {
                attribute.echoError("Invalid object type '" + asType + "'. Cannot convert.");
                return null;
            }
            ObjectTag result = object.asType(type, attribute.context);
            if (result == null) {
                attribute.echoError("Cannot convert object '" + object + "' to type '" + type.longName + "'.");
            }
            return result;
        }, new String[0]);
    }

    public void registerFutureTagDeprecation(String name, String ... deprecatedVariants) {
        TagData<? extends ObjectTag, ? extends ObjectTag> properTag = this.registeredObjectTags.get(name);
        for (String variant : deprecatedVariants) {
            TagRunnable.ObjectInterface<ObjectTag, ObjectTag> newRunnable = (attribute, object) -> {
                if (CoreConfiguration.futureWarningsEnabled) {
                    Debug.echoError(attribute.context, "Using deprecated form of tag '" + name + "': '" + variant + "'.");
                }
                return properTag.runner.run(attribute, object);
            };
            this.registeredObjectTags.put(variant, new TagData<ObjectTag, ObjectTag>(this, variant, newRunnable, properTag.returnType, false));
        }
    }

    public <R extends ObjectTag, P extends ObjectTag> void registerStaticTag(Class<R> returnType, Class<P> paramType, String name, TagRunnable.ObjectWithParamInterface<T, R, P> runnable, String ... deprecatedVariants) {
        this.registerTagInternal(returnType, paramType, name, runnable, true, deprecatedVariants);
    }

    public <R extends ObjectTag, P extends ObjectTag> void registerTag(Class<R> returnType, Class<P> paramType, String name, TagRunnable.ObjectWithParamInterface<T, R, P> runnable, String ... deprecatedVariants) {
        this.registerTagInternal(returnType, paramType, name, runnable, false, deprecatedVariants);
    }

    public <R extends ObjectTag, P extends ObjectTag> void registerTagInternal(Class<R> returnType, Class<P> paramType, String name, TagRunnable.ObjectWithParamInterface<T, R, P> runnable, boolean isStatic, String[] deprecatedVariants) {
        this.registerTagInternal(returnType, name, (attribute, obj) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            ObjectTag param = attribute.getParamObject();
            Object result = param.asType(paramType, attribute.context);
            if (result == null) {
                attribute.echoError("Tag '<Y>" + name + "<W>' requires input of type '<Y>" + DebugInternals.getClassNameOpti(paramType) + "<W>' but received input '<LR>" + param + "<W>'.");
                return null;
            }
            return runnable.run(attribute, obj, result);
        }, isStatic, deprecatedVariants);
    }

    public <R extends ObjectTag> void registerStaticTag(Class<R> returnType, String name, TagRunnable.ObjectInterface<T, R> runnable, String ... deprecatedVariants) {
        this.registerTagInternal(returnType, name, runnable, true, deprecatedVariants);
    }

    public <R extends ObjectTag> void registerTag(Class<R> returnType, String name, TagRunnable.ObjectInterface<T, R> runnable, String ... deprecatedVariants) {
        this.registerTagInternal(returnType, name, runnable, false, deprecatedVariants);
    }

    public <R extends ObjectTag> void registerTagInternal(Class<R> returnType, String name, TagRunnable.ObjectInterface<T, R> runnable, boolean isStatic, String[] deprecatedVariants) {
        TagRunnable.ObjectInterface namedRunnable = TagNamer.nameTagInterface(this.type, name, runnable);
        for (String variant : deprecatedVariants) {
            TagRunnable.ObjectInterface<ObjectTag, ObjectTag> newRunnable = TagNamer.nameTagInterface(this.type, variant, (attribute, object) -> {
                Debug.echoError(attribute.context, "Using deprecated form of tag '" + name + "': '" + variant + "'.");
                return namedRunnable.run(attribute, object);
            });
            this.registeredObjectTags.put(variant, new TagData<ObjectTag, ObjectTag>(this, variant, newRunnable, returnType, false));
        }
        this.registeredObjectTags.put(name, new TagData<T, R>(this, name, namedRunnable, returnType, isStatic));
    }

    public final ObjectTag getObjectAttribute(T object, Attribute attribute) {
        if (attribute == null) {
            if (CoreConfiguration.debugVerbose) {
                Debug.log("TagProcessor - Attribute null!");
            }
            return null;
        }
        attribute.lastValid = object;
        if (attribute.isComplete()) {
            if (CoreConfiguration.debugVerbose) {
                Debug.log("TagProcessor - Attribute complete! Self return!");
            }
            return object;
        }
        Attribute.AttributeComponent nextComponent = attribute.attributes[attribute.fulfilled];
        TagData<? extends ObjectTag, ? extends ObjectTag> data = nextComponent.data;
        if (data == null) {
            data = this.registeredObjectTags.get(nextComponent.key);
        }
        if (data != null) {
            Object returned;
            if (CoreConfiguration.debugVerbose) {
                Debug.log("TagProcessor - Sub-tag found for " + nextComponent.key);
            }
            if ((returned = data.runner.run(attribute, object)) == null) {
                if (CoreConfiguration.debugVerbose) {
                    Debug.log("TagProcessor - result was null");
                }
                attribute.trackLastTagFailure();
                return null;
            }
            if (data.processor != null) {
                return data.processor.getObjectAttribute(returned, attribute.fulfill(1));
            }
            return returned.getObjectAttribute(attribute.fulfill(1));
        }
        ObjectTag returned = CoreUtilities.autoPropertyTagObject(object, attribute);
        if (returned == null) {
            returned = object.specialTagProcessing(attribute);
        }
        if (returned != null) {
            return returned;
        }
        return object.getNextObjectTypeDown().getObjectAttribute(attribute);
    }

    public static class TagData<T extends ObjectTag, R extends ObjectTag> {
        public String name;
        public TagRunnable.ObjectInterface<T, R> runner;
        public Class<R> returnType;
        public ObjectTagProcessor<R> processor;
        public ObjectTagProcessor<T> source;
        public boolean isStatic;

        public TagData(ObjectTagProcessor<T> source, String name, TagRunnable.ObjectInterface<T, R> runner, Class<R> returnType, boolean isStatic) {
            this.source = source;
            this.name = name;
            this.runner = runner;
            this.returnType = returnType;
            this.isStatic = isStatic;
            ObjectType<R> type = ObjectFetcher.getType(returnType);
            this.processor = type == null ? null : type.tagProcessor;
        }
    }

    @FunctionalInterface
    public static interface CustomMatcher<T extends ObjectTag> {
        public Boolean tryMatch(T var1, String var2);
    }
}

