/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_18.impl.network.packets;

import com.denizenscript.denizen.nms.interfaces.packets.PacketOutChat;
import com.denizenscript.denizen.nms.v1_18.Handler;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutChat;

public class PacketOutChatImpl
implements PacketOutChat {
    private String message;
    private String rawJson;
    private ChatMessageType position;
    private static final Field MESSAGE = ReflectionHelper.getFields(PacketPlayOutChat.class).getFirstOfType(IChatBaseComponent.class);
    private static final Field POSITION = ReflectionHelper.getFields(PacketPlayOutChat.class).getFirstOfType(ChatMessageType.class);

    public PacketOutChatImpl(PacketPlayOutChat internal) {
        try {
            IChatBaseComponent baseComponent = (IChatBaseComponent)MESSAGE.get(internal);
            if (baseComponent != null) {
                this.message = FormattedTextHelper.stringify(Handler.componentToSpigot(baseComponent), ChatColor.WHITE);
                this.rawJson = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)baseComponent);
            } else if (internal.components != null) {
                this.message = FormattedTextHelper.stringify(internal.components, ChatColor.WHITE);
                this.rawJson = ComponentSerializer.toString((BaseComponent[])internal.components);
            }
            this.position = (ChatMessageType)POSITION.get(internal);
        }
        catch (Exception e2) {
            Debug.echoError(e2);
        }
    }

    @Override
    public boolean isSystem() {
        return this.position == ChatMessageType.b;
    }

    @Override
    public boolean isActionbar() {
        return this.position == ChatMessageType.c;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getRawJson() {
        return this.rawJson;
    }
}

