/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.helpers;

import com.denizenscript.denizen.nms.interfaces.FishingHelper;
import com.denizenscript.denizen.nms.v1_17.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTableRegistry;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftFishHook;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;

public class FishingHelperImpl
implements FishingHelper {
    public static Field FISHING_HOOK_NIBBLE_SETTER = ReflectionHelper.getFields(EntityFishingHook.class).get(ReflectionMappingsInfo.FishingHook_nibble, Integer.TYPE);
    public static Field FISHING_HOOK_LURE_TIME_SETTER = ReflectionHelper.getFields(EntityFishingHook.class).get(ReflectionMappingsInfo.FishingHook_timeUntilLured, Integer.TYPE);
    public static Field FISHING_HOOK_HOOK_TIME_SETTER = ReflectionHelper.getFields(EntityFishingHook.class).get(ReflectionMappingsInfo.FishingHook_timeUntilHooked, Integer.TYPE);

    public ItemStack getResult(FishHook fishHook, FishingHelper.CatchType catchType) {
        bqq result = null;
        EntityFishingHook nmsHook = ((CraftFishHook)fishHook).getHandle();
        if (catchType == FishingHelper.CatchType.DEFAULT) {
            float f = ((CraftWorld)fishHook.getWorld()).getHandle().w.nextFloat();
            int i = EnchantmentManager.g((EntityLiving)nmsHook.getOwner());
            int j = EnchantmentManager.a((buk)buo.B, (EntityLiving)nmsHook.getOwner());
            float f1 = 0.1f - (float)i * 0.025f - (float)j * 0.01f;
            float f2 = 0.05f + (float)i * 0.01f - (float)j * 0.01f;
            f1 = MathHelper.a((float)f1, (float)0.0f, (float)1.0f);
            f2 = MathHelper.a((float)f2, (float)0.0f, (float)1.0f);
            result = f < f1 ? this.catchRandomJunk(nmsHook) : ((f -= f1) < f2 ? this.catchRandomTreasure(nmsHook) : this.catchRandomFish(nmsHook));
        } else if (catchType == FishingHelper.CatchType.JUNK) {
            result = this.catchRandomJunk(nmsHook);
        } else if (catchType == FishingHelper.CatchType.TREASURE) {
            result = this.catchRandomTreasure(nmsHook);
        } else if (catchType == FishingHelper.CatchType.FISH) {
            result = this.catchRandomFish(nmsHook);
        }
        if (result != null) {
            return CraftItemStack.asBukkitCopy((bqq)result);
        }
        return null;
    }

    public bqq getRandomReward(EntityFishingHook hook, MinecraftKey key) {
        WorldServer worldServer = (WorldServer)hook.t;
        LootTableInfo.Builder playerFishEvent2 = new LootTableInfo.Builder(worldServer);
        LootTableRegistry registry = ((WorldServer)hook.t).getMinecraftServer().getLootTableRegistry();
        LootTableInfo info = playerFishEvent2.setOptional(LootContextParameters.f, (Object)new Vec3D(hook.locX(), hook.locY(), hook.locZ())).setOptional(LootContextParameters.i, (Object)new bqq((IMaterial)bqs.or)).build(LootContextParameterSets.e);
        List itemStacks = registry.getLootTable(key).populateLoot(info);
        return (bqq)itemStacks.get(worldServer.w.nextInt(itemStacks.size()));
    }

    public FishHook spawnHook(Location location, Player player) {
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        EntityFishingHook hook = new EntityFishingHook((EntityHuman)((CraftPlayer)player).getHandle(), (World)nmsWorld, 0, 0);
        nmsWorld.addEntity((atg)hook, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FishHook)hook.getBukkitEntity();
    }

    private bqq catchRandomJunk(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, dit.ah);
    }

    private bqq catchRandomTreasure(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, dit.ai);
    }

    private bqq catchRandomFish(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, dit.aj);
    }

    public FishHook getHookFrom(Player player) {
        EntityFishingHook hook = ((CraftPlayer)player).getHandle().cn;
        if (hook == null) {
            return null;
        }
        return (FishHook)hook.getBukkitEntity();
    }

    public void setNibble(FishHook hook, int ticks) {
        EntityFishingHook nmsEntity = ((CraftFishHook)hook).getHandle();
        try {
            FISHING_HOOK_NIBBLE_SETTER.setInt(nmsEntity, ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHookTime(FishHook hook, int ticks) {
        EntityFishingHook nmsEntity = ((CraftFishHook)hook).getHandle();
        try {
            FISHING_HOOK_HOOK_TIME_SETTER.setInt(nmsEntity, ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public int getLureTime(FishHook hook) {
        EntityFishingHook nmsEntity = ((CraftFishHook)hook).getHandle();
        try {
            return FISHING_HOOK_LURE_TIME_SETTER.getInt(nmsEntity);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return -1;
        }
    }

    public void setLureTime(FishHook hook, int ticks) {
        EntityFishingHook nmsEntity = ((CraftFishHook)hook).getHandle();
        try {
            FISHING_HOOK_LURE_TIME_SETTER.setInt(nmsEntity, ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }
}

