/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.queue;

import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class WaitCommand
extends AbstractCommand {
    public WaitCommand() {
        this.setName("wait");
        this.setSyntax("wait (<duration>) (queue:<name>) (system/{delta})");
        this.setRequiredArguments(0, 3);
        this.isProcedural = false;
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgLinear @ArgName(value="delay") DurationTag delay, @ArgName(value="mode") @ArgDefaultText(value="delta") Mode mode, @ArgPrefixed @ArgName(value="queue") @ArgDefaultNull QueueTag queue) {
        if (queue == null) {
            queue = new QueueTag(scriptEntry.getResidingQueue());
        }
        TimedQueue.DelayTracker tracker = mode == Mode.SYSTEM ? new SystemTimeDelayTracker(delay.getMillis()) : new TimedQueue.DeltaTimeDelayTracker(delay.getMillis());
        if (queue.queue instanceof TimedQueue) {
            ((TimedQueue)queue.queue).delay = tracker;
        } else {
            scriptEntry.setInstant(false);
            if (scriptEntry.dbCallShouldDebug()) {
                Debug.echoDebug((Debuggable)scriptEntry, "Forcing queue " + queue.queue.id + " into a timed queue...");
            }
            queue.queue.forceToTimed(tracker);
        }
    }

    public static enum Mode {
        SYSTEM,
        DELTA;

    }

    public static class SystemTimeDelayTracker
    implements TimedQueue.DelayTracker {
        public long systemTimeEnd;

        public SystemTimeDelayTracker(long millis) {
            this.systemTimeEnd = CoreUtilities.monotonicMillis() + millis;
        }

        @Override
        public boolean isDelayed() {
            return this.systemTimeEnd > CoreUtilities.monotonicMillis();
        }
    }
}

