/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import io.papermc.paper.event.world.WorldGameRuleChangeEvent;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class WorldGameRuleChangeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public WorldGameRuleChangeEvent event;
    public WorldTag world;
    public CommandSender source;

    public WorldGameRuleChangeScriptEvent() {
        this.registerCouldMatcher("gamerule changes (in <world>)");
        this.registerSwitches("gamerule");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (path.eventArgLowerAt(2).equals("in") && !this.world.tryAdvancedMatcher(path.eventArgLowerAt(3))) {
            return false;
        }
        if (!WorldGameRuleChangeScriptEvent.runGenericSwitchCheck(path, "gamerule", this.event.getGameRule().getName())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "gamerule": {
                return new ElementTag(this.event.getGameRule().getName());
            }
            case "value": {
                return new ElementTag(this.event.getValue());
            }
            case "source_type": {
                return this.getSourceType();
            }
            case "command_block_location": {
                return this.getCommandBlock();
            }
            case "command_minecart": {
                return this.getCommandMinecart();
            }
            case "world": {
                return this.world;
            }
        }
        return super.getContext(name);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        ElementTag value;
        String lower;
        if (determinationObj instanceof ElementTag && (lower = CoreUtilities.toLowerCase(determinationObj.toString())).startsWith("value:") && ((value = new ElementTag(lower.substring("value:".length()))).isInt() || value.isBoolean())) {
            this.event.setValue(value.toString());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        PlayerTag player = null;
        if (this.source instanceof Player) {
            player = new PlayerTag((Player)this.source);
        }
        return new BukkitScriptEntryData(player, null);
    }

    @EventHandler
    public void onGameRuleChanged(WorldGameRuleChangeEvent event) {
        this.source = event.getCommandSender();
        this.world = new WorldTag(event.getWorld());
        this.event = event;
        this.fire((Event)event);
    }

    public LocationTag getCommandBlock() {
        if (this.source instanceof BlockCommandSender) {
            return new LocationTag(((BlockCommandSender)this.source).getBlock().getLocation());
        }
        return null;
    }

    public EntityTag getCommandMinecart() {
        if (this.source instanceof CommandMinecart) {
            return new EntityTag((Entity)((CommandMinecart)this.source));
        }
        return null;
    }

    public ElementTag getSourceType() {
        if (this.source instanceof Player) {
            return new ElementTag("player");
        }
        if (this.source instanceof BlockCommandSender) {
            return new ElementTag("command_block");
        }
        if (this.source instanceof CommandMinecart) {
            return new ElementTag("command_minecart");
        }
        return new ElementTag("server");
    }
}

