/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.player;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExhaustionEvent;

public class PlayerIncreasesExhaustionLevelScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityExhaustionEvent event;
    public ElementTag reason;

    public PlayerIncreasesExhaustionLevelScriptEvent() {
        this.registerCouldMatcher("player exhaustion level increases");
        this.registerSwitches("reason");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!PlayerIncreasesExhaustionLevelScriptEvent.runGenericSwitchCheck(path, "reason", this.reason.asString())) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getEntity().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "exhaustion": {
                return new ElementTag(this.event.getExhaustion());
            }
            case "reason": {
                return this.reason;
            }
        }
        return super.getContext(name);
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        ElementTag value;
        if (determinationObj instanceof ElementTag && (value = determinationObj.asElement()).isFloat()) {
            this.event.setExhaustion(value.asFloat());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getEntity());
    }

    @EventHandler
    public void onPlayerIncreasesExhaustionLevel(EntityExhaustionEvent event) {
        if (EntityTag.isNPC((Entity)event.getEntity())) {
            return;
        }
        this.reason = new ElementTag(event.getExhaustionReason().name(), true);
        this.event = event;
        this.fire((Event)event);
    }
}

