/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.entity.Entity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Zombie;

public class EntityConversionTime
implements Property {
    public static final String[] handledMechs = new String[]{"conversion_duration", "drowned_conversion_duration"};
    EntityTag entity;

    public static boolean describes(ObjectTag object) {
        if (!(object instanceof EntityTag)) {
            return false;
        }
        Entity entity = ((EntityTag)object).getBukkitEntity();
        return entity instanceof Zombie && !(entity instanceof PigZombie) || entity instanceof Skeleton;
    }

    public static EntityConversionTime getFrom(ObjectTag entity) {
        if (!EntityConversionTime.describes(entity)) {
            return null;
        }
        return new EntityConversionTime((EntityTag)entity);
    }

    private EntityConversionTime(EntityTag ent) {
        this.entity = ent;
    }

    @Override
    public String getPropertyString() {
        if (this.isConverting()) {
            return this.getConversionTime().identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "conversion_duration";
    }

    public static void registerTags() {
        PropertyParser.registerTag(EntityConversionTime.class, DurationTag.class, "conversion_duration", (attribute, object) -> {
            if (!object.isConverting()) {
                attribute.echoError("This entity is not converting!");
                return null;
            }
            return object.getConversionTime();
        }, "drowned_conversion_duration");
        PropertyParser.registerTag(EntityConversionTime.class, ElementTag.class, "is_converting", (attribute, object) -> new ElementTag(object.isConverting()), new String[0]);
    }

    public boolean isZombie() {
        return this.entity.getBukkitEntity() instanceof Zombie;
    }

    public boolean isSkeleton() {
        return this.entity.getBukkitEntity() instanceof Skeleton;
    }

    public Zombie getZombie() {
        return (Zombie)this.entity.getBukkitEntity();
    }

    public Skeleton getSkeleton() {
        return (Skeleton)this.entity.getBukkitEntity();
    }

    public boolean isConverting() {
        if (this.isZombie()) {
            return this.getZombie().isConverting();
        }
        if (this.isSkeleton()) {
            return this.getSkeleton().isConverting();
        }
        return false;
    }

    public DurationTag getConversionTime() {
        if (this.isZombie()) {
            return new DurationTag((long)this.getZombie().getConversionTime());
        }
        if (this.isSkeleton()) {
            return new DurationTag((long)this.getSkeleton().getConversionTime());
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if ((mechanism.matches("conversion_duration") || mechanism.matches("drowned_conversion_duration")) && mechanism.requireObject(DurationTag.class)) {
            if (this.isZombie()) {
                this.getZombie().setConversionTime(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
            } else if (this.isSkeleton()) {
                this.getSkeleton().setConversionTime(mechanism.valueAsType(DurationTag.class).getTicksAsInt());
            }
        }
    }
}

