/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.file;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.core.BinaryTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.io.File;
import java.io.FileInputStream;

public class FileReadCommand
extends AbstractCommand
implements Holdable {
    public FileReadCommand() {
        this.setName("fileread");
        this.setSyntax("fileread [path:<path>]");
        this.setRequiredArguments(1, 1);
        this.isProcedural = false;
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgPrefixed @ArgName(value="path") String path) {
        if (!CoreConfiguration.allowFileRead) {
            Debug.echoError(scriptEntry, "FileRead disabled in Denizen/config.yml (refer to command documentation).");
            scriptEntry.setFinished(true);
            return;
        }
        File file = new File(DenizenCore.implementation.getDataFolder(), path);
        if (!DenizenCore.implementation.canReadFile(file)) {
            Debug.echoError("Cannot read from that file path due to security settings in Denizen/config.yml.");
            scriptEntry.setFinished(true);
            return;
        }
        try {
            if (!CoreConfiguration.filePathLimit.equals("none")) {
                File root = new File(DenizenCore.implementation.getDataFolder(), CoreConfiguration.filePathLimit);
                if (!file.getCanonicalPath().startsWith(root.getCanonicalPath())) {
                    Debug.echoError("File path '" + path + "' is not within the config's restricted data file path.");
                    scriptEntry.setFinished(true);
                    return;
                }
            }
            if (!file.exists()) {
                Debug.echoError(scriptEntry, "File read failed, file does not exist!");
                scriptEntry.setFinished(true);
                return;
            }
        }
        catch (Exception ex) {
            Debug.echoError(ex);
            scriptEntry.setFinished(true);
            return;
        }
        Runnable runme = () -> {
            try {
                FileInputStream stream = new FileInputStream(file);
                byte[] data = stream.readAllBytes();
                stream.close();
                scriptEntry.addObject("data", new BinaryTag(data));
                scriptEntry.setFinished(true);
            }
            catch (Exception e) {
                Debug.echoError(scriptEntry, e);
                scriptEntry.setFinished(true);
            }
        };
        if (scriptEntry.shouldWaitFor()) {
            DenizenCore.runAsync(runme);
        } else {
            runme.run();
        }
    }
}

