/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.entity.Mob;

public class EntityAware
implements Property {
    public static final String[] handledMechs = new String[]{"is_aware"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).isMobType();
    }

    public static EntityAware getFrom(ObjectTag entity) {
        if (!EntityAware.describes(entity)) {
            return null;
        }
        return new EntityAware((EntityTag)entity);
    }

    private EntityAware(EntityTag entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getMob().isAware());
    }

    @Override
    public String getPropertyId() {
        return "is_aware";
    }

    public Mob getMob() {
        return (Mob)this.entity.getBukkitEntity();
    }

    public static void register() {
        PropertyParser.registerTag(EntityAware.class, ElementTag.class, "is_aware", (attribute, entity) -> new ElementTag(entity.getMob().isAware()), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("is_aware") && mechanism.requireBoolean()) {
            this.getMob().setAware(mechanism.getValue().asBoolean());
        }
    }
}

