/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityEnterBlockEvent;

public class EntityEntersBlockScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTag entity;
    public MaterialTag material;
    public LocationTag location;
    public EntityEnterBlockEvent event;

    public EntityEntersBlockScriptEvent() {
        this.registerCouldMatcher("<entity> goes into <block>");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        String target = path.eventArgLowerAt(0);
        if (!this.entity.tryAdvancedMatcher(target)) {
            return false;
        }
        if (!path.tryArgObject(3, this.material)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.entity.getDenizenObject();
            }
            case "location": {
                return this.location;
            }
            case "material": {
                return this.material;
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityEntersBlock(EntityEnterBlockEvent event) {
        this.entity = new EntityTag(event.getEntity());
        this.location = new LocationTag(event.getBlock().getLocation());
        this.material = new MaterialTag(event.getBlock());
        this.event = event;
        this.fire((Event)event);
    }
}

