/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Vex;
import org.bukkit.entity.WitherSkull;

public class EntityCharged
implements Property {
    EntityTag entity;

    public static boolean describes(ObjectTag object) {
        if (!(object instanceof EntityTag)) {
            return false;
        }
        Entity entity = ((EntityTag)object).getBukkitEntity();
        return entity instanceof WitherSkull || entity instanceof Vex || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && entity instanceof Guardian;
    }

    public static EntityCharged getFrom(ObjectTag entity) {
        if (!EntityCharged.describes(entity)) {
            return null;
        }
        return new EntityCharged((EntityTag)entity);
    }

    private EntityCharged(EntityTag entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        if (this.isGuardian()) {
            return this.getGuardian().hasLaser() ? "true" : null;
        }
        return String.valueOf(this.isCharged());
    }

    @Override
    public String getPropertyId() {
        return "charged";
    }

    public static void register() {
        PropertyParser.registerTag(EntityCharged.class, ElementTag.class, "charged", (attribute, object) -> new ElementTag(object.isCharged()), new String[0]);
        PropertyParser.registerMechanism(EntityCharged.class, ElementTag.class, "charged", (object, mechanism, input) -> {
            if (!mechanism.requireBoolean()) {
                return;
            }
            if (object.isWitherSkull()) {
                object.getWitherSkull().setCharged(input.asBoolean());
            } else if (object.isVex()) {
                object.getVex().setCharging(input.asBoolean());
            } else if (object.isGuardian()) {
                object.getGuardian().setLaser(input.asBoolean());
            }
        }, new String[0]);
    }

    public boolean isWitherSkull() {
        return this.entity.getBukkitEntity() instanceof WitherSkull;
    }

    public boolean isVex() {
        return this.entity.getBukkitEntity() instanceof Vex;
    }

    public boolean isGuardian() {
        return NMSHandler.getVersion().isAtLeast(NMSVersion.v1_17) && this.entity.getBukkitEntity() instanceof Guardian;
    }

    public WitherSkull getWitherSkull() {
        return (WitherSkull)this.entity.getBukkitEntity();
    }

    public Vex getVex() {
        return (Vex)this.entity.getBukkitEntity();
    }

    public Guardian getGuardian() {
        return (Guardian)this.entity.getBukkitEntity();
    }

    public boolean isCharged() {
        if (this.isWitherSkull()) {
            return this.getWitherSkull().isCharged();
        }
        if (this.isVex()) {
            return this.getVex().isCharging();
        }
        if (this.isGuardian()) {
            return this.getGuardian().hasLaser();
        }
        return false;
    }
}

