/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.item;

import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.command.TabCompleteHelper;
import com.denizenscript.denizen.utilities.depends.Depends;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class GiveCommand
extends AbstractCommand {
    public GiveCommand() {
        this.setName("give");
        this.setSyntax("give [xp/<item>|...] (quantity:<#>) (unlimit_stack_size) (to:<inventory>) (slot:<slot>) (allowed_slots:<slot-matcher>) (ignore_leftovers)");
        this.setRequiredArguments(1, 7);
        this.isProcedural = false;
        this.addRemappedPrefixes("to", "t");
        this.autoCompile();
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        TabCompleteHelper.tabCompleteItems(tab);
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="quantity") @ArgPrefixed @ArgDefaultText(value="-1") double quantity, @ArgName(value="type") @ArgPrefixed @ArgDefaultText(value="__item") Type type, @ArgName(value="unlimit_stack_size") boolean unlimit_stack_size, @ArgName(value="ignore_leftovers") boolean ignore_leftovers, @ArgName(value="allowed_slots") @ArgPrefixed @ArgDefaultNull String allowed_slots, @ArgName(value="to") @ArgPrefixed @ArgDefaultNull InventoryTag inventory, @ArgName(value="slot") @ArgPrefixed @ArgDefaultText(value="1") String slot, @ArgName(value="items") @ArgLinear ListTag itemsList) {
        if (type != Type.__ITEM && !Utilities.entryHasPlayer(scriptEntry)) {
            throw new InvalidArgumentsRuntimeException("Must link a player to give money or XP!");
        }
        if (inventory == null) {
            if (!Utilities.entryHasPlayer(scriptEntry)) {
                throw new InvalidArgumentsRuntimeException("Must specify an inventory to give to!");
            }
            inventory = Utilities.getEntryPlayer(scriptEntry).getInventory();
        }
        if (type == Type.MONEY) {
            BukkitImplDeprecations.giveTakeMoney.warn(scriptEntry);
        }
        List<ItemTag> items = itemsList.filter(ItemTag.class, scriptEntry);
        ListTag leftoverSave = new ListTag();
        switch (type) {
            case MONEY: {
                if (Depends.economy != null) {
                    Depends.economy.depositPlayer(Utilities.getEntryPlayer(scriptEntry).getOfflinePlayer(), quantity < 0.0 ? 1.0 : quantity);
                    break;
                }
                Debug.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
                break;
            }
            case XP: 
            case EXP: 
            case EXPERIENCE: {
                Utilities.getEntryPlayer(scriptEntry).getPlayerEntity().giveExp((int)(quantity < 0.0 ? 1.0 : quantity));
                break;
            }
            case __ITEM: {
                boolean limited = !unlimit_stack_size;
                for (ItemTag item : items) {
                    int slotId;
                    ItemStack is = new ItemStack(item.getItemStack());
                    if (is.getType() == Material.AIR) {
                        Debug.echoError("Cannot give air!");
                        continue;
                    }
                    if (quantity >= 0.0) {
                        is.setAmount((int)quantity);
                    }
                    if ((slotId = SlotHelper.nameToIndexFor(slot, inventory.getInventory().getHolder())) == -1) {
                        Debug.echoError(scriptEntry, "The input '" + slot + "' is not a valid slot!");
                        return;
                    }
                    List<ItemStack> leftovers = inventory.addWithLeftovers(slotId, allowed_slots, limited, is);
                    for (ItemStack extraItem : leftovers) {
                        leftoverSave.addObject(new ItemTag(extraItem));
                    }
                    if (leftovers.isEmpty() || ignore_leftovers) continue;
                    Debug.echoDebug((Debuggable)scriptEntry, "The inventory didn't have enough space, the rest of the items have been placed on the floor.");
                    for (ItemStack leftoverItem : leftovers) {
                        if (inventory.getLocation() == null) {
                            Debug.echoError("Cannot drop extras from failed give command - no inventory location.");
                            return;
                        }
                        inventory.getLocation().getWorld().dropItem((Location)inventory.getLocation(), leftoverItem);
                    }
                }
                break;
            }
        }
        scriptEntry.addObject("leftover_items", leftoverSave);
    }

    public static enum Type {
        __ITEM,
        MONEY,
        EXP,
        XP,
        EXPERIENCE;

    }
}

