/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore;

import com.denizenscript.denizencore.DenizenImplementation;
import com.denizenscript.denizencore.events.OldEventManager;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.events.core.DeltaTimeScriptEvent;
import com.denizenscript.denizencore.events.core.PreScriptReloadScriptEvent;
import com.denizenscript.denizencore.events.core.ReloadScriptsScriptEvent;
import com.denizenscript.denizencore.events.core.ScriptsLoadedScriptEvent;
import com.denizenscript.denizencore.events.core.ShutdownScriptEvent;
import com.denizenscript.denizencore.events.core.SystemTimeScriptEvent;
import com.denizenscript.denizencore.events.core.TickScriptEvent;
import com.denizenscript.denizencore.flags.SavableMapFlagTracker;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.core.SecretTag;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.scripts.ScriptRegistry;
import com.denizenscript.denizencore.scripts.commands.CommandRegistry;
import com.denizenscript.denizencore.scripts.commands.queue.RunLaterCommand;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import com.denizenscript.denizencore.utilities.debugging.DebugSubmitter;
import com.denizenscript.denizencore.utilities.debugging.LogInterceptor;
import com.denizenscript.denizencore.utilities.scheduling.AsyncSchedulable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import com.denizenscript.denizencore.utilities.scheduling.Schedulable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;

public class DenizenCore {
    public static final String VERSION;
    public static CommandRegistry commandRegistry;
    public static final long startTime;
    public static SavableMapFlagTracker serverFlagMap;
    public static long lastReloadTime;
    public static int reloads;
    public static LogInterceptor logInterceptor;
    public static Thread MAIN_THREAD;
    public static long currentTimeMillis;
    public static long currentTimeMonotonicMillis;
    public static long serverTimeMillis;
    public static final ArrayList<Schedulable> scheduled;
    public static final ArrayList<TimedQueue> timedQueues;
    public static DenizenImplementation implementation;
    static int tMS;

    public static void init(DenizenImplementation implementation) {
        currentTimeMillis = System.currentTimeMillis();
        currentTimeMonotonicMillis = CoreUtilities.monotonicMillis();
        DenizenCore.implementation = implementation;
        MAIN_THREAD = Thread.currentThread();
        Debug.log("Initializing Denizen Core v" + VERSION + ", impl for " + implementation.getImplementationName() + " v" + implementation.getImplementationVersion());
        ScriptRegistry._registerCoreTypes();
        ScriptEvent.registerCoreEvents();
        ObjectFetcher.registerCoreObjects();
        TagManager.registerCoreTags();
        commandRegistry.registerCoreCommands();
        DebugSubmitter.init();
        ReflectionHelper.hasInitialized = true;
    }

    public static void reloadSaves() {
        serverFlagMap = SavableMapFlagTracker.loadFlagFile(new File(implementation.getDataFolder(), "server_flags").getPath(), true);
        SecretTag.load();
    }

    public static void saveAll() {
        NoteManager.save();
        serverFlagMap.saveToFile(new File(implementation.getDataFolder(), "server_flags").getPath());
    }

    public static void shutdown() {
        ShutdownScriptEvent.instance.fire();
        DenizenCore.saveAll();
        logInterceptor.standardOutput();
        commandRegistry.disableCoreMembers();
    }

    public static void preloadScripts() {
        try {
            ++reloads;
            PreScriptReloadScriptEvent.instance.fire();
            ScriptEvent.worldContainers.clear();
            implementation.preScriptReload();
            ScriptHelper.resetError();
            ScriptHelper.reloadScripts();
        }
        catch (Exception ex) {
            Debug.echoError("Error loading scripts:");
            Debug.echoError(ex);
        }
    }

    public static void postLoadScripts() {
        try {
            TagManager.preCalced.clear();
            Attribute.attribsLookup.clear();
            ReplaceableTagEvent.refs.clear();
            ScriptRegistry.postLoadScripts();
            for (ScriptContainer container : ScriptRegistry.scriptContainers.values()) {
                container.postCheck();
            }
            OldEventManager.scanWorldEvents();
            ScriptEvent.reload();
            implementation.onScriptReload();
            lastReloadTime = CoreUtilities.monotonicMillis();
            ScriptsLoadedScriptEvent.instance.hadError = ScriptHelper.hadError();
            ScriptsLoadedScriptEvent.instance.fire();
        }
        catch (Exception ex) {
            Debug.echoError("Error loading scripts:");
            Debug.echoError(ex);
        }
    }

    public static void reloadScripts() {
        DenizenCore.preloadScripts();
        DenizenCore.postLoadScripts();
        ReloadScriptsScriptEvent.instance.hadError = ScriptHelper.hadError();
        ReloadScriptsScriptEvent.instance.fire();
        Debug.log("Scripts reloaded.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(Schedulable sched) {
        ArrayList<Schedulable> arrayList = scheduled;
        synchronized (arrayList) {
            scheduled.add(sched);
        }
    }

    public static boolean isMainThread() {
        Thread curThread = Thread.currentThread();
        return curThread.equals(MAIN_THREAD) || curThread.equals(TagManager.tagThread);
    }

    public static void runOnMainThread(Runnable run) {
        if (DenizenCore.isMainThread()) {
            run.run();
        } else {
            DenizenCore.schedule(new OneTimeSchedulable(run, 0.0f));
        }
    }

    public static void runAsync(Runnable run) {
        AsyncSchedulable.executor.execute(run);
    }

    static void oncePerSecond() {
        SystemTimeScriptEvent.instance.checkTime();
        DeltaTimeScriptEvent.instance.checkTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick(int ms_elapsed) {
        DebugInternals.onTick();
        serverTimeMillis += (long)ms_elapsed;
        currentTimeMillis = System.currentTimeMillis();
        currentTimeMonotonicMillis = CoreUtilities.monotonicMillis();
        ++TickScriptEvent.instance.ticks;
        if (TickScriptEvent.instance.enabled) {
            TickScriptEvent.instance.fire();
        }
        RunLaterCommand.tickFutureRuns();
        tMS += ms_elapsed;
        while (tMS > 1000) {
            tMS -= 1000;
            DenizenCore.oncePerSecond();
        }
        ArrayList<Schedulable> arrayList = scheduled;
        synchronized (arrayList) {
            for (int i = 0; i < scheduled.size(); ++i) {
                Schedulable current = scheduled.get(i);
                try {
                    if (current.tick((float)ms_elapsed / 1000.0f)) continue;
                    scheduled.remove(i--);
                    continue;
                }
                catch (Throwable ex) {
                    Debug.echoError("DenizenCore - Scheduler item failed");
                    Debug.echoError(ex);
                    if (!(current instanceof OneTimeSchedulable)) continue;
                    scheduled.remove(i--);
                }
            }
        }
        for (int i = 0; i < timedQueues.size(); ++i) {
            TimedQueue queue = timedQueues.get(i);
            queue.tryRevolveOnce();
            if (!queue.isStopped) continue;
            timedQueues.remove(i--);
        }
    }

    static {
        commandRegistry = new CommandRegistry();
        startTime = CoreUtilities.monotonicMillis();
        reloads = 0;
        logInterceptor = new LogInterceptor();
        currentTimeMillis = System.currentTimeMillis();
        currentTimeMonotonicMillis = CoreUtilities.monotonicMillis();
        serverTimeMillis = 1L;
        scheduled = new ArrayList();
        timedQueues = new ArrayList();
        Object version = "UNKNOWN";
        try {
            InputStream is = DenizenCore.class.getClassLoader().getResourceAsStream("denizencore.properties");
            if (is == null) {
                throw new FileNotFoundException("denizencore.properties not found in jar file");
            }
            Properties properties = new Properties();
            properties.load(is);
            version = properties.getProperty("version") + " (Build " + properties.getProperty("build") + ")";
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VERSION = version;
        tMS = 0;
    }
}

