/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.server;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;

public class BossBarCommand
extends AbstractCommand {
    public static final Map<String, BossBar> bossBarMap = new HashMap<String, BossBar>();

    public BossBarCommand() {
        this.setName("bossbar");
        this.setSyntax("bossbar ({auto}/create/update/remove) [<id>] (players:<player>|...) (title:<title>) (progress:<#.#>) (color:<color>) (style:<style>) (options:<option>|...) (uuid:<uuid>)");
        this.setRequiredArguments(1, 9);
        this.isProcedural = false;
        this.autoCompile();
        this.addRemappedPrefixes("title", "t");
        this.addRemappedPrefixes("progress", "health", "p", "h");
        this.addRemappedPrefixes("style", "s");
        this.addRemappedPrefixes("options", "option", "opt", "o", "flags", "flag", "f");
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addWithPrefix("id:", bossBarMap.keySet());
        tab.addWithPrefix("style:", (Enum<?>[])BarStyle.values());
        tab.addWithPrefix("color:", (Enum<?>[])BarColor.values());
        tab.addWithPrefix("options:", (Enum<?>[])BarFlag.values());
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="action") @ArgDefaultText(value="auto") Action action, @ArgName(value="id") @ArgLinear ElementTag id, @ArgName(value="players") @ArgPrefixed @ArgDefaultNull @ArgSubType(value=PlayerTag.class) List<PlayerTag> players, @ArgName(value="title") @ArgPrefixed @ArgDefaultNull String title, @ArgName(value="progress") @ArgPrefixed @ArgDefaultNull ElementTag progress, @ArgName(value="color") @ArgPrefixed @ArgDefaultText(value="white") BarColor color, @ArgName(value="style") @ArgPrefixed @ArgDefaultText(value="solid") BarStyle style, @ArgName(value="options") @ArgPrefixed @ArgDefaultNull @ArgSubType(value=BarFlag.class) List<BarFlag> options, @ArgName(value="uuid") @ArgPrefixed @ArgDefaultNull String uuid) {
        UUID actualUuid;
        String idString = id.asLowerString();
        if (action == Action.AUTO) {
            Action action2 = action = bossBarMap.containsKey(idString) ? Action.UPDATE : Action.CREATE;
        }
        if (players == null && action == Action.CREATE) {
            if (!Utilities.entryHasPlayer(scriptEntry)) {
                throw new InvalidArgumentsRuntimeException("Missing player input!");
            }
            players = Collections.singletonList(Utilities.getEntryPlayer(scriptEntry));
        }
        BossBar bossBar = null;
        switch (action) {
            case CREATE: {
                double barProgress;
                if (bossBarMap.containsKey(idString)) {
                    Debug.echoError("BossBar '" + idString + "' already exists!");
                    return;
                }
                List<PlayerTag> barPlayers = players;
                double d = barProgress = progress != null ? progress.asDouble() : 1.0;
                if (title == null) {
                    title = "";
                }
                bossBar = Bukkit.createBossBar((String)title, (BarColor)color, (BarStyle)style, (BarFlag[])(options == null ? new BarFlag[]{} : options.toArray(new BarFlag[0])));
                NMSHandler.playerHelper.setBossBarTitle(bossBar, title);
                bossBar.setProgress(barProgress);
                if (uuid != null) {
                    NMSHandler.instance.setBossbarUUID(bossBar, UUID.fromString(uuid));
                }
                for (PlayerTag player : barPlayers) {
                    if (!player.isOnline()) {
                        Debug.echoError("Player must be online to show a BossBar to them!");
                        continue;
                    }
                    bossBar.addPlayer(player.getPlayerEntity());
                }
                bossBar.setVisible(true);
                bossBarMap.put(idString, bossBar);
                break;
            }
            case UPDATE: {
                if (!bossBarMap.containsKey(idString)) {
                    Debug.echoError("BossBar '" + idString + "' does not exist!");
                    return;
                }
                bossBar = bossBarMap.get(idString);
                if (title != null) {
                    NMSHandler.playerHelper.setBossBarTitle(bossBar, title);
                }
                if (progress != null) {
                    bossBar.setProgress(progress.asDouble());
                }
                if (color != null) {
                    bossBar.setColor(color);
                }
                if (style != null) {
                    bossBar.setStyle(style);
                }
                if (options != null) {
                    HashSet<BarFlag> oldFlags = new HashSet<BarFlag>(Arrays.asList(BarFlag.values()));
                    HashSet<BarFlag> newFlags = new HashSet<BarFlag>(options.size());
                    for (BarFlag flag : options) {
                        newFlags.add(flag);
                        oldFlags.remove(flag);
                    }
                    Iterator<Object> iterator = oldFlags.iterator();
                    while (iterator.hasNext()) {
                        BarFlag flag;
                        flag = (BarFlag)iterator.next();
                        bossBar.removeFlag(flag);
                    }
                    for (BarFlag flag : newFlags) {
                        bossBar.addFlag(flag);
                    }
                }
                if (players == null) break;
                for (PlayerTag player : players) {
                    bossBar.addPlayer(player.getPlayerEntity());
                }
                break;
            }
            case REMOVE: {
                bossBar = bossBarMap.remove(idString);
                if (bossBar == null) {
                    Debug.echoError("BossBar '" + idString + "' does not exist!");
                    return;
                }
                if (players != null) {
                    for (PlayerTag player : players) {
                        bossBar.removePlayer(player.getPlayerEntity());
                    }
                    break;
                }
                bossBar.setVisible(false);
            }
        }
        if (bossBar != null && (actualUuid = NMSHandler.instance.getBossbarUUID(bossBar)) != null) {
            scriptEntry.addObject("bar_uuid", new ElementTag(actualUuid.toString()));
        }
    }

    public static enum Action {
        AUTO,
        CREATE,
        UPDATE,
        REMOVE;

    }
}

