/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.properties.material.MaterialProperty;
import com.denizenscript.denizencore.exceptions.Unreachable;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Sapling;
import org.bukkit.block.data.type.TurtleEgg;

public class MaterialAge
extends MaterialProperty {
    public static boolean describes(MaterialTag material) {
        BlockData data = material.getModernData();
        return data instanceof Ageable || data instanceof TurtleEgg || data instanceof Sapling;
    }

    public MaterialAge(MaterialTag material) {
        super(material);
    }

    @Override
    public ElementTag getPropertyValue() {
        return new ElementTag(this.getCurrent());
    }

    @Override
    public String getPropertyId() {
        return "age";
    }

    public static void register() {
        PropertyParser.registerStaticTag(MaterialAge.class, ElementTag.class, "maximum_age", (attribute, prop) -> new ElementTag(prop.getMax()), "maximum_plant_growth");
        PropertyParser.registerStaticTag(MaterialAge.class, ElementTag.class, "age", (attribute, prop) -> new ElementTag(prop.getCurrent()), "plant_growth");
        PropertyParser.registerMechanism(MaterialAge.class, ElementTag.class, "age", (prop, mechanism, param) -> {
            if (!mechanism.requireInteger()) {
                return;
            }
            int age = param.asInt();
            if (age < 0 || age > prop.getMax()) {
                mechanism.echoError("Age value '" + age + "' is not valid. Must be between 0 and " + prop.getMax() + " for material '" + ((MaterialTag)prop.object).name() + "'.");
                return;
            }
            BlockData data = prop.getBlockData();
            if (data instanceof TurtleEgg) {
                TurtleEgg turtle = (TurtleEgg)data;
                turtle.setHatch(age);
            } else if (data instanceof Sapling) {
                Sapling sapling = (Sapling)data;
                sapling.setStage(age);
            } else if (data instanceof Ageable) {
                Ageable ageable = (Ageable)data;
                ageable.setAge(age);
            }
        }, "plant_growth");
    }

    public int getCurrent() {
        BlockData data = this.getBlockData();
        if (data instanceof TurtleEgg) {
            TurtleEgg turtle = (TurtleEgg)data;
            return turtle.getHatch();
        }
        if (data instanceof Sapling) {
            Sapling sapling = (Sapling)data;
            return sapling.getStage();
        }
        if (data instanceof Ageable) {
            Ageable age = (Ageable)data;
            return age.getAge();
        }
        throw new Unreachable();
    }

    public int getMax() {
        BlockData data = this.getBlockData();
        if (data instanceof TurtleEgg) {
            TurtleEgg turtle = (TurtleEgg)data;
            return turtle.getMaximumHatch();
        }
        if (data instanceof Sapling) {
            Sapling sapling = (Sapling)data;
            return sapling.getMaximumStage();
        }
        if (data instanceof Ageable) {
            Ageable age = (Ageable)data;
            return age.getMaximumAge();
        }
        throw new Unreachable();
    }
}

