/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Material;

public class EntityItemInHand
implements Property {
    public static final String[] handledTags = new String[]{"item_in_hand"};
    public static final String[] handledMechs = new String[]{"item_in_hand"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        if (!(entity instanceof EntityTag)) {
            return false;
        }
        return ((EntityTag)entity).isLivingEntity();
    }

    public static EntityItemInHand getFrom(ObjectTag entity) {
        if (!EntityItemInHand.describes(entity)) {
            return null;
        }
        return new EntityItemInHand((EntityTag)entity);
    }

    public EntityItemInHand(EntityTag entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        ItemTag item = new ItemTag(this.entity.getLivingEntity().getEquipment().getItemInMainHand());
        if (item.getBukkitMaterial() != Material.AIR) {
            return item.identify();
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "item_in_hand";
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("item_in_hand")) {
            if (!this.entity.isSpawnedOrValidForTag()) {
                return null;
            }
            return new ItemTag(this.entity.getLivingEntity().getEquipment().getItemInMainHand()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("item_in_hand")) {
            this.entity.getLivingEntity().getEquipment().setItemInMainHand(mechanism.valueAsType(ItemTag.class).getItemStack());
        }
    }
}

