/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.utilities.CoreUtilities;

public interface VectorObject
extends ObjectTag {
    public double getX();

    public double getY();

    public double getZ();

    public void setX(double var1);

    public void setY(double var1);

    public void setZ(double var1);

    default public double lengthSquared() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return x * x + y * y + z * z;
    }

    default public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public static <T extends VectorObject> void register(Class<T> type, ObjectTagProcessor<T> processor) {
        processor.registerTag(ElementTag.class, "x", (attribute, object) -> new ElementTag(object.getX()), new String[0]);
        processor.registerTag(ElementTag.class, "y", (attribute, object) -> new ElementTag(object.getY()), new String[0]);
        processor.registerTag(ElementTag.class, "z", (attribute, object) -> new ElementTag(object.getZ()), new String[0]);
        processor.registerTag(ElementTag.class, "xyz", (attribute, object) -> new ElementTag(CoreUtilities.doubleToString(object.getX()) + "," + CoreUtilities.doubleToString(object.getY()) + "," + CoreUtilities.doubleToString(object.getZ())), new String[0]);
        processor.registerTag(type, "with_x", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            VectorObject output = (VectorObject)object.duplicate();
            output.setX(attribute.getDoubleParam());
            return output;
        }, new String[0]);
        processor.registerTag(type, "with_y", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            VectorObject output = (VectorObject)object.duplicate();
            output.setY(attribute.getDoubleParam());
            return output;
        }, new String[0]);
        processor.registerTag(type, "with_z", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            VectorObject output = (VectorObject)object.duplicate();
            output.setZ(attribute.getDoubleParam());
            return output;
        }, new String[0]);
        processor.registerTag(type, type, "add", (attribute, object, input) -> {
            VectorObject other = (VectorObject)object.duplicate();
            other.setX(object.getX() + input.getX());
            other.setY(object.getY() + input.getY());
            other.setZ(object.getZ() + input.getZ());
            return other;
        }, new String[0]);
        processor.registerTag(type, type, "sub", (attribute, object, input) -> {
            VectorObject other = (VectorObject)object.duplicate();
            other.setX(object.getX() - input.getX());
            other.setY(object.getY() - input.getY());
            other.setZ(object.getZ() - input.getZ());
            return other;
        }, new String[0]);
        processor.registerTag(type, ElementTag.class, "mul", (attribute, object, length) -> {
            VectorObject other = (VectorObject)object.duplicate();
            double len = length.asDouble();
            other.setX(object.getX() * len);
            other.setY(object.getY() * len);
            other.setZ(object.getZ() * len);
            return other;
        }, new String[0]);
        processor.registerTag(type, ElementTag.class, "div", (attribute, object, length) -> {
            VectorObject other = (VectorObject)object.duplicate();
            double len = 1.0 / length.asDouble();
            other.setX(object.getX() * len);
            other.setY(object.getY() * len);
            other.setZ(object.getZ() * len);
            return other;
        }, new String[0]);
        processor.registerTag(type, "normalize", (attribute, object) -> {
            double len = object.length();
            if (len == 0.0) {
                len = 1.0;
            }
            len = 1.0 / len;
            VectorObject other = (VectorObject)object.duplicate();
            other.setX(object.getX() * len);
            other.setY(object.getY() * len);
            other.setZ(object.getZ() * len);
            return other;
        }, new String[0]);
        processor.registerTag(ElementTag.class, "vector_length_squared", (attribute, object) -> new ElementTag(object.lengthSquared()), new String[0]);
        processor.registerTag(ElementTag.class, "vector_length", (attribute, object) -> new ElementTag(object.length()), new String[0]);
    }
}

