/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.scheduling.RepeatingSchedulable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class BlockCrackCommand
extends AbstractCommand {
    private static final Map<Location, Map<UUID, IntHolder>> progressTracker = new HashMap<Location, Map<UUID, IntHolder>>();
    private static int lastBase;

    public BlockCrackCommand() {
        this.setName("blockcrack");
        this.setSyntax("blockcrack [<location>] [progress:<#>] (stack) (players:<player>|...) (duration:<duration>)");
        this.setRequiredArguments(2, 5);
        this.isProcedural = false;
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="location") @ArgLinear LocationTag location, @ArgName(value="progress") @ArgPrefixed int progress, @ArgName(value="stack") boolean stack, @ArgName(value="players") @ArgDefaultNull @ArgPrefixed @ArgSubType(value=PlayerTag.class) List<PlayerTag> players, @ArgName(value="duration") @ArgPrefixed @ArgDefaultNull DurationTag duration) {
        Location loc;
        if (players == null) {
            players = List.of(Utilities.getEntryPlayer(scriptEntry));
        }
        if (!progressTracker.containsKey(loc = location.getBlock().getLocation())) {
            progressTracker.put(loc, new HashMap());
        }
        Map<UUID, IntHolder> uuidInt = progressTracker.get(loc);
        for (PlayerTag player : players) {
            int n;
            if (!player.isOnline()) {
                Debug.echoError("Players must be online!");
                continue;
            }
            Player playerEnt = player.getPlayerEntity();
            UUID uuid = playerEnt.getUniqueId();
            if (!uuidInt.containsKey(uuid)) {
                IntHolder newIntHolder = new IntHolder();
                newIntHolder.theInt = lastBase += 10;
                newIntHolder.base = lastBase;
                uuidInt.put(uuid, newIntHolder);
            }
            IntHolder intHolder = uuidInt.get(uuid);
            if (!stack && intHolder.theInt > intHolder.base) {
                for (int i = intHolder.base; i <= intHolder.theInt; ++i) {
                    BlockCrackCommand.showBlockCrack(playerEnt, i, loc, -1, duration);
                }
                intHolder.theInt = intHolder.base;
            } else if (stack && intHolder.theInt - intHolder.base > 10) continue;
            if (stack) {
                int n2 = intHolder.theInt;
                n = n2;
                intHolder.theInt = n2 + 1;
            } else {
                n = intHolder.theInt;
            }
            int id = n;
            BlockCrackCommand.showBlockCrack(playerEnt, id, loc, progress - 1, duration);
        }
    }

    private static void showBlockCrack(Player player, int id, Location location, int progress, DurationTag duration) {
        if (duration == null || progress == -1) {
            NMSHandler.packetHelper.showBlockCrack(player, id, location, progress);
            return;
        }
        RepeatingSchedulable schedulable = new RepeatingSchedulable(null, 1.0f);
        long endTime = DenizenCore.serverTimeMillis + duration.getMillis();
        NMSHandler.packetHelper.showBlockCrack(player, id, location, progress);
        schedulable.run = () -> {
            if (endTime <= DenizenCore.serverTimeMillis) {
                NMSHandler.packetHelper.showBlockCrack(player, id, location, -1);
                schedulable.cancel();
                return;
            }
            NMSHandler.packetHelper.showBlockCrack(player, id, location, progress);
        };
        DenizenCore.schedule(schedulable);
    }

    private static class IntHolder {
        public int theInt;
        public int base;

        private IntHolder() {
        }
    }
}

