/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_20.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.VanillaTagHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_20_R2.CraftChunk;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftSkull;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.tag.CraftBlockTag;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity = ReflectionHelper.getFields(CraftBlockEntityState.class).get("tileEntity");
    public static final Field craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get("snapshot");
    public static final Field craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get("profile");
    public static final MethodHandle CRAFTBLOCKSTATE_CONSTRUCTOR = ReflectionHelper.getConstructor(CraftBlockState.class, org.bukkit.block.Block.class);
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(BlockBase.BlockData.class, EnumPistonReaction.class);
    public static final MethodHandle BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(BlockBase.BlockData.class, Float.TYPE);
    public static final MethodHandle HOLDERSET_NAMED_BIND = ReflectionHelper.getMethodHandle(HolderSet.Named.class, ReflectionMappingsInfo.HolderSetNamed_bind_method, List.class);
    public static final MethodHandle HOLDER_REFERENCE_BINDTAGS = ReflectionHelper.getMethodHandle(Holder.c.class, ReflectionMappingsInfo.HolderReference_bindTags_method, Collection.class);

    @Override
    public void makeBlockStateRaw(BlockState state) {
        try {
            craftBlockEntityState_snapshot.set(state, craftBlockEntityState_tileEntity.get(state));
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void applyPhysics(Location location) {
        ((CraftWorld)location.getWorld()).getHandle().a(CraftLocation.toBlockPosition((Location)location), CraftMagicNumbers.getBlock((Material)location.getBlock().getType()));
    }

    public static <T extends TileEntity> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((TileEntity)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e2) {
            Debug.echoError(e2);
            return null;
        }
    }

    @Override
    public PlayerProfile getPlayerProfile(Skull skull) {
        GameProfile profile = ((TileEntitySkull)BlockHelperImpl.getTE((CraftSkull)skull)).g;
        if (profile == null) {
            return null;
        }
        String name = profile.getName();
        UUID id = profile.getId();
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(name, id, property != null ? property.value() : null);
    }

    @Override
    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        try {
            craftSkull_profile.set(skull, gameProfile);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        skull.update();
    }

    @Override
    public CompoundTag getNbtData(org.bukkit.block.Block block) {
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()), true);
        if (te != null) {
            NBTTagCompound compound = te.m();
            return CompoundTagImpl.fromNMSTag(compound);
        }
        return null;
    }

    @Override
    public void setNbtData(org.bukkit.block.Block block, CompoundTag ctag) {
        CompoundTagBuilder builder = ctag.createBuilder();
        builder.putInt("x", block.getX());
        builder.putInt("y", block.getY());
        builder.putInt("z", block.getZ());
        ctag = builder.build();
        BlockPosition blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(blockPos, true);
        te.a(((CompoundTagImpl)ctag).toNMSTag());
    }

    @Override
    public boolean setBlockResistance(Material material, float resistance) {
        Block block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(BlockBase.class, ReflectionMappingsInfo.BlockBehaviour_explosionResistance, block, Float.valueOf(resistance));
        return true;
    }

    @Override
    public float getBlockResistance(Material material) {
        Block block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(BlockBase.class, ReflectionMappingsInfo.BlockBehaviour_explosionResistance, block)).floatValue();
    }

    @Override
    public BlockState generateBlockState(org.bukkit.block.Block block, Material mat) {
        try {
            CraftBlockState state = CRAFTBLOCKSTATE_CONSTRUCTOR.invoke(block);
            state.setData(this.getMaterialBlockState(mat));
            return state;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public IBlockData getMaterialBlockState(Material bukkitMaterial) {
        Block nmsBlock = CraftMagicNumbers.getBlock((Material)bukkitMaterial);
        return nmsBlock != null ? nmsBlock.n() : null;
    }

    @Override
    public void setPushReaction(Material mat, BlockHelper.PistonPushReaction reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getMaterialBlockState(mat), EnumPistonReaction.values()[reaction.ordinal()]);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public float getBlockStrength(Material mat) {
        return this.getMaterialBlockState((Material)mat).n;
    }

    @Override
    public void setBlockStrength(Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlockState(mat), strength);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void doRandomTick(Location location) {
        Fluid fluid;
        BlockPosition pos = CraftLocation.toBlockPosition((Location)location);
        IChunkAccess nmsChunk = ((CraftChunk)location.getChunk()).getHandle(ChunkStatus.n);
        IBlockData nmsBlock = nmsChunk.a_(pos);
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.v()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.z);
        }
        if ((fluid = nmsBlock.u()).f()) {
            fluid.a((World)nmsWorld, pos, nmsWorld.z);
        }
    }

    @Override
    public Instrument getInstrumentFor(Material mat) {
        return Instrument.values()[this.getMaterialBlockState(mat).A().ordinal()];
    }

    @Override
    public int getExpDrop(org.bukkit.block.Block block, ItemStack item) {
        Block blockType = CraftMagicNumbers.getBlock((Material)block.getType());
        if (blockType == null) {
            return 0;
        }
        return blockType.getExpDrop(((CraftBlock)block).getNMS(), ((CraftBlock)block).getCraftWorld().getHandle(), ((CraftBlock)block).getPosition(), item == null ? null : CraftItemStack.asNMSCopy((ItemStack)item), true);
    }

    @Override
    public void setSpawnerSpawnedType(CreatureSpawner spawner, EntityTag entity) {
        spawner.setSpawnedType(entity.getBukkitEntityType());
        if (entity.getWaitingMechanisms() == null || entity.getWaitingMechanisms().size() == 0) {
            return;
        }
        try {
            net.minecraft.world.entity.Entity nmsEntity = ((CraftWorld)spawner.getWorld()).createEntity(spawner.getLocation(), entity.getBukkitEntityType().getEntityClass());
            EntityTag entityTag = new EntityTag((Entity)nmsEntity.getBukkitEntity());
            entityTag.isFake = true;
            entityTag.isFakeValid = true;
            for (Mechanism mechanism : entity.getWaitingMechanisms()) {
                entityTag.safeAdjustDuplicate(mechanism);
            }
            nmsEntity.dI();
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            TileEntityMobSpawner nmsSnapshot = (TileEntityMobSpawner)craftBlockEntityState_snapshot.get(bukkitSpawner);
            MobSpawnerAbstract nmsSpawner = nmsSnapshot.d();
            MobSpawnerData toSpawn = nmsSpawner.f;
            NBTTagCompound tag = toSpawn.a();
            nmsEntity.f(tag);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public void setSpawnerCustomRules(CreatureSpawner spawner, int skyMin, int skyMax, int blockMin, int blockMax) {
        try {
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            TileEntityMobSpawner nmsSnapshot = (TileEntityMobSpawner)craftBlockEntityState_snapshot.get(bukkitSpawner);
            MobSpawnerAbstract nmsSpawner = nmsSnapshot.d();
            MobSpawnerData toSpawn = nmsSpawner.f;
            MobSpawnerData.a rules = skyMin == -1 ? null : new MobSpawnerData.a(new InclusiveRange((Comparable)Integer.valueOf(skyMin), (Comparable)Integer.valueOf(skyMax)), new InclusiveRange((Comparable)Integer.valueOf(blockMin), (Comparable)Integer.valueOf(blockMax)));
            nmsSpawner.f = new MobSpawnerData(toSpawn.c(), Optional.ofNullable(rules));
            nmsSpawner.e = SimpleWeightedRandomList.b();
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public Color getMapColor(org.bukkit.block.Block block) {
        CraftBlock craftBlock = (CraftBlock)block;
        return Color.fromRGB((int)craftBlock.getNMS().d((IBlockAccess)craftBlock.getHandle(), (BlockPosition)craftBlock.getPosition()).ak);
    }

    @Override
    public void setVanillaTags(Material material, Set<String> tags) {
        Holder.c nmsHolder = CraftMagicNumbers.getBlock((Material)material).q();
        nmsHolder.c().forEach(arg_0 -> BlockHelperImpl.lambda$setVanillaTags$0((Holder)nmsHolder, arg_0));
        ArrayList<TagKey> newNmsTags = new ArrayList<TagKey>();
        for (String tag : tags) {
            TagKey newNmsTag = TagKey.a((ResourceKey)BuiltInRegistries.f.c(), (MinecraftKey)new MinecraftKey(tag));
            HolderSet.Named nmsHolderSet = BuiltInRegistries.f.a(newNmsTag);
            List nmsHolders = nmsHolderSet.a().collect(Collectors.toCollection(ArrayList::new));
            nmsHolders.add(nmsHolder);
            try {
                HOLDERSET_NAMED_BIND.invoke(nmsHolderSet, nmsHolders);
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
            newNmsTags.add(newNmsTag);
            VanillaTagHelper.addOrUpdateMaterialTag((Tag<Material>)new CraftBlockTag((IRegistry)BuiltInRegistries.f, newNmsTag));
        }
        try {
            HOLDER_REFERENCE_BINDTAGS.invoke((Holder)nmsHolder, newNmsTags);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        ClientboundUpdateTagsPacket tagsPacket = new ClientboundUpdateTagsPacket(TagNetworkSerialization.a((LayeredRegistryAccess)((CraftServer)Bukkit.getServer()).getServer().aV()));
        for (Player player : Bukkit.getOnlinePlayers()) {
            PacketHelperImpl.send(player, tagsPacket);
        }
    }

    private static /* synthetic */ void lambda$setVanillaTags$0(Holder nmsHolder, TagKey nmsTag) {
        HolderSet.Named nmsHolderSet = BuiltInRegistries.f.b(nmsTag).orElse(null);
        if (nmsHolderSet == null) {
            return;
        }
        List nmsHolders = nmsHolderSet.a().collect(Collectors.toCollection(ArrayList::new));
        nmsHolders.remove(nmsHolder);
        try {
            HOLDERSET_NAMED_BIND.invoke(nmsHolderSet, nmsHolders);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        VanillaTagHelper.updateMaterialTag((Tag<Material>)new CraftBlockTag((IRegistry)BuiltInRegistries.f, nmsTag));
    }
}

