/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.MusicInstrumentMeta;

public class ItemInstrument
extends ItemProperty<ElementTag> {
    public static boolean describes(ItemTag item) {
        return item.getItemMeta() instanceof MusicInstrumentMeta;
    }

    @Override
    public ElementTag getPropertyValue() {
        MusicInstrument instrument = ((MusicInstrumentMeta)this.getItemMeta()).getInstrument();
        if (instrument != null) {
            return new ElementTag(Utilities.namespacedKeyToString(instrument.getKey()));
        }
        return null;
    }

    @Override
    public void setPropertyValue(ElementTag value, Mechanism mechanism) {
        MusicInstrument instrument;
        MusicInstrument musicInstrument = instrument = value != null ? MusicInstrument.getByKey((NamespacedKey)Utilities.parseNamespacedKey(value.asString())) : null;
        if (value != null && instrument == null) {
            mechanism.echoError("Invalid instrument: " + value);
            return;
        }
        this.editMeta(MusicInstrumentMeta.class, meta -> meta.setInstrument(instrument));
    }

    @Override
    public String getPropertyId() {
        return "instrument";
    }

    public static void register() {
        ItemInstrument.autoRegisterNullable("instrument", ItemInstrument.class, ElementTag.class, false, new String[0]);
    }
}

