/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl.network.handlers;

import com.denizenscript.denizen.events.player.PlayerReceivesPacketScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.AbstractListenerPlayInImpl;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.DenizenPacketListenerImpl;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.ActionBarEventPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.AttachPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.BlockLightPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.DenizenPacketHandlerPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.DisguisePacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.EntityMetadataPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.FakeBlocksPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.FakeEquipmentPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.FakePlayerPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.HiddenEntitiesPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.HideParticlesPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.PlayerHearsSoundEventPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.TablistUpdateEventPacketHandlers;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptCodeGen;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.network.protocol.status.PacketStatusOutListener;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.SampleLogger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class DenizenNetworkManagerImpl
extends NetworkManager {
    public static final Map<Class<? extends Packet<PacketListenerPlayOut>>, List<PacketHandler<?>>> packetHandlers = new HashMap();
    public final NetworkManager oldManager;
    public final DenizenPacketListenerImpl packetListener;
    public final EntityPlayer player;
    public int packetsSent;
    public int packetsReceived;
    private static final Field protocolDirectionField;
    private static final Field ServerGamePacketListener_ConnectionField;
    private static final MethodHandle ServerGamePacketListener_ConnectionSetter;

    public static PacketDataSerializer copyPacket(Packet<?> original) {
        try {
            PacketDataSerializer copier = new PacketDataSerializer(Unpooled.buffer());
            original.a(copier);
            return copier;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public static <T extends Packet<PacketListenerPlayOut>> void registerPacketHandler(Class<T> packetClass, PacketHandler<T> handler) {
        packetHandlers.computeIfAbsent(packetClass, k -> new ArrayList()).add(handler);
    }

    public static <T extends Packet<PacketListenerPlayOut>> void registerPacketHandler(Class<T> packetClass, BiConsumer<DenizenNetworkManagerImpl, T> handler) {
        DenizenNetworkManagerImpl.registerPacketHandler(packetClass, (DenizenNetworkManagerImpl networkManager, T packet) -> {
            handler.accept(networkManager, packet);
            return packet;
        });
    }

    public DenizenNetworkManagerImpl(EntityPlayer entityPlayer, NetworkManager oldManager) {
        super(DenizenNetworkManagerImpl.getProtocolDirection(oldManager));
        this.oldManager = oldManager;
        this.n = oldManager.n;
        this.player = entityPlayer;
        this.packetListener = (DenizenPacketListenerImpl)((Object)NetworkInterceptCodeGen.generateAppropriateInterceptor((Object)this, entityPlayer, DenizenPacketListenerImpl.class, AbstractListenerPlayInImpl.class, PlayerConnection.class));
        if (!(oldManager.m() instanceof ServerConfigurationPacketListener)) {
            this.a((PacketListener)this.packetListener);
        }
    }

    public void a(PacketListener listener) {
        this.oldManager.a((PacketListener)(listener instanceof ServerConfigurationPacketListener || this.packetListener == null ? listener : this.packetListener));
    }

    public static NetworkManager getConnection(EntityPlayer player) {
        try {
            return (NetworkManager)ServerGamePacketListener_ConnectionField.get(player.c);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            throw new RuntimeException("Failed to get connection from player due to reflection error", ex);
        }
    }

    public static NetworkManager getConnection(Player player) {
        return DenizenNetworkManagerImpl.getConnection(((CraftPlayer)player).getHandle());
    }

    public static DenizenNetworkManagerImpl getNetworkManager(EntityPlayer player) {
        return (DenizenNetworkManagerImpl)DenizenNetworkManagerImpl.getConnection(player);
    }

    public static DenizenNetworkManagerImpl getNetworkManager(Player player) {
        return DenizenNetworkManagerImpl.getNetworkManager(((CraftPlayer)player).getHandle());
    }

    public static void setNetworkManager(Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        PlayerConnection playerConnection = entityPlayer.c;
        DenizenNetworkManagerImpl.setNetworkManager(playerConnection, new DenizenNetworkManagerImpl(entityPlayer, DenizenNetworkManagerImpl.getConnection(entityPlayer)));
    }

    public static void enableNetworkManager() {
        for (World w : Bukkit.getWorlds()) {
            for (PlayerChunkMap.EntityTracker tracker : ((CraftWorld)w).getHandle().l().a.K.values()) {
                ArrayList connections = new ArrayList(tracker.f);
                tracker.f.clear();
                for (ServerPlayerConnection connection : connections) {
                    tracker.f.add(connection.p().c);
                }
            }
        }
    }

    public int hashCode() {
        return this.oldManager.hashCode();
    }

    public boolean equals(Object c2) {
        return this.oldManager.equals(c2);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelRegistered(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelUnregistered(ctx);
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        this.oldManager.channelActive(channelhandlercontext);
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) {
        this.oldManager.channelInactive(channelhandlercontext);
    }

    public boolean isSharable() {
        return this.oldManager.isSharable();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.handlerRemoved(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) {
        this.oldManager.exceptionCaught(channelhandlercontext, throwable);
    }

    public void a() {
        this.oldManager.a();
    }

    public void b() {
        this.oldManager.b();
    }

    protected void a(ChannelHandlerContext channelhandlercontext, Packet packet) {
        if (this.oldManager.n.isOpen()) {
            try {
                packet.a((PacketListener)this.packetListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void b(PacketListener packetlistener) {
        this.oldManager.b(packetlistener);
    }

    public void a(String s, int i, PacketStatusOutListener packetstatusoutlistener) {
        this.oldManager.a(s, i, packetstatusoutlistener);
    }

    public void a(String s, int i, PacketLoginOutListener packetloginoutlistener) {
        this.oldManager.a(s, i, packetloginoutlistener);
    }

    public void a(ClientIntent clientintent) {
        this.oldManager.a(clientintent);
    }

    public void a(Packet<?> packet) {
        this.a(packet, null);
    }

    public static void doPacketOutput(String text) {
        if (!NMSHandler.debugPackets) {
            return;
        }
        if (NMSHandler.debugPacketFilter == null || NMSHandler.debugPacketFilter.trim().isEmpty() || CoreUtilities.toLowerCase(text).contains(NMSHandler.debugPacketFilter)) {
            Debug.log(text);
        }
    }

    public void debugOutputPacket(Packet<?> packet) {
        if (packet instanceof PacketPlayOutEntityMetadata) {
            StringBuilder output = new StringBuilder(128);
            output.append("Packet: ClientboundSetEntityDataPacket sent to ").append(this.player.cy()).append(" for entity ID: ").append(((PacketPlayOutEntityMetadata)packet).a()).append(": ");
            List list = ((PacketPlayOutEntityMetadata)packet).d();
            if (list == null) {
                output.append("None");
            } else {
                for (DataWatcher.b data : list) {
                    output.append('[').append(data.a()).append(": ").append(data.c()).append("], ");
                }
            }
            DenizenNetworkManagerImpl.doPacketOutput(output.toString());
        } else if (packet instanceof PacketPlayOutEntityVelocity) {
            PacketPlayOutEntityVelocity velPacket = (PacketPlayOutEntityVelocity)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundSetEntityMotionPacket sent to " + this.player.cy() + " for entity ID: " + velPacket.a() + ": " + velPacket.d() + "," + velPacket.e() + "," + velPacket.f());
        } else if (packet instanceof PacketPlayOutSpawnEntity) {
            PacketPlayOutSpawnEntity addEntityPacket = (PacketPlayOutSpawnEntity)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundAddEntityPacket sent to " + this.player.cy() + " for entity ID: " + addEntityPacket.a() + ": uuid: " + addEntityPacket.d() + ", type: " + addEntityPacket.e() + ", at: " + addEntityPacket.f() + "," + addEntityPacket.g() + "," + addEntityPacket.h() + ", data: " + addEntityPacket.o());
        } else if (packet instanceof PacketPlayOutMap) {
            PacketPlayOutMap mapPacket = (PacketPlayOutMap)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundMapItemDataPacket sent to " + this.player.cy() + " for map ID: " + mapPacket.a() + ", scale: " + mapPacket.d() + ", locked: " + mapPacket.e());
        } else if (packet instanceof PacketPlayOutEntityDestroy) {
            PacketPlayOutEntityDestroy removePacket = (PacketPlayOutEntityDestroy)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundRemoveEntitiesPacket sent to " + this.player.cy() + " for entities: " + removePacket.a().stream().map(Object::toString).collect(Collectors.joining(", ")));
        } else if (packet instanceof ClientboundPlayerInfoUpdatePacket) {
            ClientboundPlayerInfoUpdatePacket playerInfoPacket = (ClientboundPlayerInfoUpdatePacket)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundPlayerInfoPacket sent to " + this.player.cy() + " of types " + playerInfoPacket.a() + " for player profiles: " + playerInfoPacket.d().stream().map(p -> "mode=" + p.e() + "/latency=" + p.d() + "/display=" + p.f() + "/name=" + p.b().getName() + "/id=" + p.b().getId() + "/" + p.b().getProperties().asMap().entrySet().stream().map(e2 -> (String)e2.getKey() + "=" + ((Collection)e2.getValue()).stream().map(v -> v.value() + ";" + v.signature()).collect(Collectors.joining(";;;"))).collect(Collectors.joining("/"))).collect(Collectors.joining(", ")));
        } else {
            DenizenNetworkManagerImpl.doPacketOutput("Packet: " + packet.getClass().getCanonicalName() + " sent to " + this.player.cy());
        }
    }

    public void a(Packet<?> packet, PacketSendListener genericfuturelistener) {
        this.a(packet, genericfuturelistener, true);
    }

    public void a(Packet<?> packet, @Nullable PacketSendListener genericfuturelistener, boolean flush) {
        if (!Bukkit.isPrimaryThread()) {
            if (Settings.cache_warnOnAsyncPackets && !(packet instanceof ClientboundSystemChatPacket) && !(packet instanceof ClientboundPlayerChatPacket) && !(packet instanceof PacketPlayOutTabComplete)) {
                Debug.echoError("Warning: packet sent off main thread! This is completely unsupported behavior! Denizen network interceptor ignoring packet to avoid crash. Packet class: " + packet.getClass().getCanonicalName() + " sent to " + this.player.cy() + " identify the sender of the packet from the stack trace:");
                try {
                    throw new RuntimeException("Trace");
                }
                catch (Exception ex) {
                    Debug.echoError(ex);
                }
            }
            this.oldManager.a(packet, genericfuturelistener, flush);
            return;
        }
        if (NMSHandler.debugPackets) {
            this.debugOutputPacket((Packet<?>)packet);
        }
        ++this.packetsSent;
        if (packet instanceof ClientboundBundlePacket) {
            ClientboundBundlePacket bundlePacket = packet;
            ArrayList<Packet<PacketListenerPlayOut>> processedPackets = new ArrayList<Packet<PacketListenerPlayOut>>();
            boolean anyChange = false;
            for (Packet subPacket : bundlePacket.a()) {
                Packet<PacketListenerPlayOut> processed = this.processPacketHandlersFor((Packet<PacketListenerPlayOut>)subPacket);
                boolean bl = anyChange = anyChange || processed != subPacket;
                if (processed == null) continue;
                processedPackets.add(processed);
            }
            if (processedPackets.isEmpty()) {
                return;
            }
            if (anyChange) {
                packet = new ClientboundBundlePacket(processedPackets);
            }
        } else {
            Packet<PacketListenerPlayOut> processed = this.processPacketHandlersFor((Packet<PacketListenerPlayOut>)packet);
            if (processed == null) {
                return;
            }
            packet = processed;
        }
        this.oldManager.a(packet, genericfuturelistener, flush);
    }

    public void a(Consumer<NetworkManager> consumer) {
        this.oldManager.a(consumer);
    }

    public void c() {
        this.oldManager.c();
    }

    public Packet<PacketListenerPlayOut> processPacketHandlersFor(Packet<PacketListenerPlayOut> packet) {
        if (packet == null) {
            return null;
        }
        List<PacketHandler<?>> packetHandlers = DenizenNetworkManagerImpl.packetHandlers.get(packet.getClass());
        if (packetHandlers != null) {
            Iterator<PacketHandler<?>> iterator = packetHandlers.iterator();
            while (iterator.hasNext()) {
                Packet<PacketListenerPlayOut> processed;
                PacketHandler<?> _packetHandler;
                PacketHandler<?> packetHandler = _packetHandler = iterator.next();
                try {
                    processed = packetHandler.handlePacket(this, packet);
                }
                catch (Exception ex) {
                    Debug.echoError("Packet handler for " + packet.getClass().getCanonicalName() + " threw an exception:");
                    Debug.echoError(ex);
                    continue;
                }
                if (processed == null) {
                    if (NMSHandler.debugPackets) {
                        DenizenNetworkManagerImpl.doPacketOutput("DENIED PACKET - " + packet.getClass().getCanonicalName() + " DENIED FROM SEND TO " + this.player.cy());
                    }
                    return null;
                }
                packet = processed;
            }
        }
        if (PlayerReceivesPacketScriptEvent.enabled & PlayerReceivesPacketScriptEvent.fireFor((Player)this.player.getBukkitEntity(), packet)) {
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("DENIED PACKET - " + packet.getClass().getCanonicalName() + " DENIED FROM SEND TO " + this.player.cy() + " due to event");
            }
            return null;
        }
        return packet;
    }

    public void d() {
        this.oldManager.d();
    }

    public SocketAddress f() {
        return this.oldManager.f();
    }

    public String a(boolean flag) {
        return this.oldManager.a(flag);
    }

    public void a(IChatBaseComponent ichatbasecomponent) {
        if (!this.player.getBukkitEntity().isOnline()) {
            return;
        }
        this.oldManager.a(ichatbasecomponent);
    }

    public boolean g() {
        return this.oldManager != null && this.oldManager.g();
    }

    public EnumProtocolDirection h() {
        return this.oldManager.h();
    }

    public EnumProtocolDirection i() {
        return this.oldManager.i();
    }

    public void a(ChannelPipeline channelpipeline) {
        this.oldManager.a(channelpipeline);
    }

    public void a(Cipher cipher, Cipher cipher1) {
        this.oldManager.a(cipher, cipher1);
    }

    public boolean j() {
        return this.oldManager.j();
    }

    public boolean k() {
        return this.oldManager.k();
    }

    public boolean l() {
        return this.oldManager.l();
    }

    public PacketListener m() {
        return this.oldManager.m();
    }

    public IChatBaseComponent n() {
        return this.oldManager.n();
    }

    public void o() {
        this.oldManager.o();
    }

    public void a(int i, boolean b2) {
        this.oldManager.a(i, b2);
    }

    public void p() {
        this.oldManager.p();
    }

    public float q() {
        return this.oldManager.q();
    }

    public float r() {
        return this.oldManager.r();
    }

    public void a(SampleLogger samplelogger) {
        this.oldManager.a(samplelogger);
    }

    private static EnumProtocolDirection getProtocolDirection(NetworkManager networkManager) {
        EnumProtocolDirection direction = null;
        try {
            direction = (EnumProtocolDirection)protocolDirectionField.get(networkManager);
        }
        catch (Exception e2) {
            Debug.echoError(e2);
        }
        return direction;
    }

    private static void setNetworkManager(PlayerConnection playerConnection, NetworkManager networkManager) {
        try {
            ServerGamePacketListener_ConnectionSetter.invoke(playerConnection, networkManager);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return this.oldManager.acceptInboundMessage(msg);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.oldManager.channelRead(ctx, msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelReadComplete(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.oldManager.userEventTriggered(ctx, evt);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelWritabilityChanged(ctx);
    }

    static {
        ActionBarEventPacketHandlers.registerHandlers();
        AttachPacketHandlers.registerHandlers();
        BlockLightPacketHandlers.registerHandlers();
        DenizenPacketHandlerPacketHandlers.registerHandlers();
        DisguisePacketHandlers.registerHandlers();
        EntityMetadataPacketHandlers.registerHandlers();
        FakeBlocksPacketHandlers.registerHandlers();
        FakeEquipmentPacketHandlers.registerHandlers();
        FakePlayerPacketHandlers.registerHandlers();
        HiddenEntitiesPacketHandlers.registerHandlers();
        HideParticlesPacketHandlers.registerHandlers();
        PlayerHearsSoundEventPacketHandlers.registerHandlers();
        ProfileEditorImpl.registerHandlers();
        TablistUpdateEventPacketHandlers.registerHandlers();
        protocolDirectionField = ReflectionHelper.getFields(NetworkManager.class).get(ReflectionMappingsInfo.Connection_receiving, EnumProtocolDirection.class);
        ServerGamePacketListener_ConnectionField = ReflectionHelper.getFields(ServerCommonPacketListenerImpl.class).get(ReflectionMappingsInfo.ServerCommonPacketListenerImpl_connection);
        ServerGamePacketListener_ConnectionSetter = ReflectionHelper.getFinalSetter(ServerCommonPacketListenerImpl.class, ReflectionMappingsInfo.ServerCommonPacketListenerImpl_connection);
    }

    @FunctionalInterface
    public static interface PacketHandler<T extends Packet<PacketListenerPlayOut>> {
        public Packet<PacketListenerPlayOut> handlePacket(DenizenNetworkManagerImpl var1, T var2) throws Exception;
    }
}

