/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.HashMap;
import java.util.Map;

public class EntityDataNameMapper {
    public static final Map<Class<? extends blv>, Map<String, Integer>> entityDataNames = new HashMap<Class<? extends blv>, Map<String, Integer>>();

    public static void registerDataName(Class<? extends blv> entityClass, int id, String name) {
        entityDataNames.computeIfAbsent(entityClass, k -> new HashMap()).put(name, id);
    }

    public static int getIdForName(Class<? extends blv> entityClass, String name) {
        Class<? extends blv> currentClass = entityClass;
        int id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        while (id == -1 && (currentClass = currentClass.getSuperclass()) != Object.class) {
            id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        }
        return id;
    }

    private static int getIdFromClass(Class<?> entityClass, String name) {
        int id;
        Map<String, Integer> nameToId = entityDataNames.get(entityClass);
        int n = id = nameToId != null ? nameToId.getOrDefault(name, -1) : -1;
        if (id == -1 && ArgumentHelper.matchesInteger((String)name)) {
            id = new ElementTag(name).asInt();
        }
        return id;
    }

    static {
        EntityDataNameMapper.registerDataName(blv.class, 0, "entity_flags");
        EntityDataNameMapper.registerDataName(blv.class, 1, "air_ticks");
        EntityDataNameMapper.registerDataName(blv.class, 2, "custom_name");
        EntityDataNameMapper.registerDataName(blv.class, 3, "custom_name_visible");
        EntityDataNameMapper.registerDataName(blv.class, 4, "silent");
        EntityDataNameMapper.registerDataName(blv.class, 5, "no_gravity");
        EntityDataNameMapper.registerDataName(blv.class, 6, "pose");
        EntityDataNameMapper.registerDataName(blv.class, 7, "frozen_ticks");
        EntityDataNameMapper.registerDataName(bmg.class, 8, "width");
        EntityDataNameMapper.registerDataName(bmg.class, 9, "height");
        EntityDataNameMapper.registerDataName(bmg.class, 10, "responsive");
        EntityDataNameMapper.registerDataName(blu.class, 8, "transform_interpolation_start");
        EntityDataNameMapper.registerDataName(blu.class, 9, "transform_interpolation_duration");
        EntityDataNameMapper.registerDataName(blu.class, 10, "movement_interpolation_duration");
        EntityDataNameMapper.registerDataName(blu.class, 11, "translation");
        EntityDataNameMapper.registerDataName(blu.class, 12, "scale");
        EntityDataNameMapper.registerDataName(blu.class, 13, "left_rotation");
        EntityDataNameMapper.registerDataName(blu.class, 14, "right_rotation");
        EntityDataNameMapper.registerDataName(blu.class, 15, "billboard");
        EntityDataNameMapper.registerDataName(blu.class, 16, "brightness");
        EntityDataNameMapper.registerDataName(blu.class, 17, "view_range");
        EntityDataNameMapper.registerDataName(blu.class, 18, "shadow_radius");
        EntityDataNameMapper.registerDataName(blu.class, 19, "shadow_strength");
        EntityDataNameMapper.registerDataName(blu.class, 20, "width");
        EntityDataNameMapper.registerDataName(blu.class, 21, "height");
        EntityDataNameMapper.registerDataName(blu.class, 22, "glow_color");
        EntityDataNameMapper.registerDataName(blu.b.class, 23, "material");
        EntityDataNameMapper.registerDataName(blu.g.class, 23, "item");
        EntityDataNameMapper.registerDataName(blu.g.class, 24, "model_transform");
        EntityDataNameMapper.registerDataName(blu.l.class, 23, "text");
        EntityDataNameMapper.registerDataName(blu.l.class, 24, "line_width");
        EntityDataNameMapper.registerDataName(blu.l.class, 25, "background_color");
        EntityDataNameMapper.registerDataName(blu.l.class, 26, "text_opacity");
        EntityDataNameMapper.registerDataName(blu.l.class, 27, "text_display_flags");
        EntityDataNameMapper.registerDataName(cgh.class, 8, "item");
        EntityDataNameMapper.registerDataName(cft.class, 8, "item");
        EntityDataNameMapper.registerDataName(cfv.class, 8, "spawn_position");
        EntityDataNameMapper.registerDataName(bls.class, 8, "radius");
        EntityDataNameMapper.registerDataName(bls.class, 9, "color");
        EntityDataNameMapper.registerDataName(bls.class, 10, "waiting");
        EntityDataNameMapper.registerDataName(bls.class, 11, "particle");
        EntityDataNameMapper.registerDataName(cfw.class, 8, "hooked_entity_id");
        EntityDataNameMapper.registerDataName(cfw.class, 9, "catchable");
        EntityDataNameMapper.registerDataName(cfo.class, 8, "abstract_arrow_flags");
        EntityDataNameMapper.registerDataName(cfo.class, 9, "piercing_level");
        EntityDataNameMapper.registerDataName(cfq.class, 10, "color");
        EntityDataNameMapper.registerDataName(cgm.class, 10, "loyalty_level");
        EntityDataNameMapper.registerDataName(cgm.class, 11, "enchantment_glint");
        EntityDataNameMapper.registerDataName(chc.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(chc.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(chc.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(chc.class, 11, "type");
        EntityDataNameMapper.registerDataName(chc.class, 12, "left_paddle_moving");
        EntityDataNameMapper.registerDataName(chc.class, 13, "right_paddle_moving");
        EntityDataNameMapper.registerDataName(chc.class, 14, "bubble_shaking_ticks");
        EntityDataNameMapper.registerDataName(can.class, 8, "beam_target");
        EntityDataNameMapper.registerDataName(can.class, 9, "showing_bottom");
        EntityDataNameMapper.registerDataName(cgd.class, 8, "item");
        EntityDataNameMapper.registerDataName(cfu.class, 8, "item");
        EntityDataNameMapper.registerDataName(cgo.class, 8, "invulnerable");
        EntityDataNameMapper.registerDataName(cfv.class, 8, "item");
        EntityDataNameMapper.registerDataName(cfv.class, 9, "shooter_id");
        EntityDataNameMapper.registerDataName(cfv.class, 10, "shot_at_angle");
        EntityDataNameMapper.registerDataName(cbn.class, 8, "item");
        EntityDataNameMapper.registerDataName(cbn.class, 9, "rotation");
        EntityDataNameMapper.registerDataName(cbp.class, 8, "painting_variant");
        EntityDataNameMapper.registerDataName(bml.class, 8, "living_entity_flags");
        EntityDataNameMapper.registerDataName(bml.class, 9, "health");
        EntityDataNameMapper.registerDataName(bml.class, 10, "potion_effect_color");
        EntityDataNameMapper.registerDataName(bml.class, 11, "is_potion_effect_ambient");
        EntityDataNameMapper.registerDataName(bml.class, 12, "arrows_in_body");
        EntityDataNameMapper.registerDataName(bml.class, 13, "bee_stingers_in_body");
        EntityDataNameMapper.registerDataName(bml.class, 14, "bed_location");
        EntityDataNameMapper.registerDataName(cfi.class, 15, "additional_hearts");
        EntityDataNameMapper.registerDataName(cfi.class, 16, "score");
        EntityDataNameMapper.registerDataName(cfi.class, 17, "skin_parts");
        EntityDataNameMapper.registerDataName(cfi.class, 18, "main_hand");
        EntityDataNameMapper.registerDataName(cfi.class, 19, "left_shoulder_entity");
        EntityDataNameMapper.registerDataName(cfi.class, 20, "right_shoulder_entity");
        EntityDataNameMapper.registerDataName(cbk.class, 15, "armor_stand_flags");
        EntityDataNameMapper.registerDataName(cbk.class, 16, "head_rotation");
        EntityDataNameMapper.registerDataName(cbk.class, 17, "body_rotation");
        EntityDataNameMapper.registerDataName(cbk.class, 18, "left_arm_rotation");
        EntityDataNameMapper.registerDataName(cbk.class, 19, "right_arm_rotation");
        EntityDataNameMapper.registerDataName(cbk.class, 20, "left_leg_rotation");
        EntityDataNameMapper.registerDataName(cbk.class, 21, "right_leg_rotation");
        EntityDataNameMapper.registerDataName(bmn.class, 15, "mob_flags");
        EntityDataNameMapper.registerDataName(bxt.class, 16, "bat_flags");
        EntityDataNameMapper.registerDataName(byg.class, 16, "treasure_location");
        EntityDataNameMapper.registerDataName(byg.class, 17, "has_fish");
        EntityDataNameMapper.registerDataName(byg.class, 18, "moisture_level");
        EntityDataNameMapper.registerDataName(bxv.class, 16, "from_bucket");
        EntityDataNameMapper.registerDataName(byr.class, 17, "puff_state");
        EntityDataNameMapper.registerDataName(byy.class, 17, "variant");
        EntityDataNameMapper.registerDataName(blq.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cak.class, 17, "sniffer_state");
        EntityDataNameMapper.registerDataName(cak.class, 18, "finish_dig_time");
        EntityDataNameMapper.registerDataName(bzx.class, 17, "horse_flags");
        EntityDataNameMapper.registerDataName(bzz.class, 18, "variant");
        EntityDataNameMapper.registerDataName(bzk.class, 18, "is_dashing");
        EntityDataNameMapper.registerDataName(bzk.class, 19, "last_pose_change");
        EntityDataNameMapper.registerDataName(bzw.class, 18, "has_chest");
        EntityDataNameMapper.registerDataName(caa.class, 19, "strength");
        EntityDataNameMapper.registerDataName(caa.class, 20, "carpet_color");
        EntityDataNameMapper.registerDataName(caa.class, 21, "variant");
        EntityDataNameMapper.registerDataName(bzf.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bzf.class, 18, "playing_dead");
        EntityDataNameMapper.registerDataName(bzf.class, 19, "from_bucket");
        EntityDataNameMapper.registerDataName(bxz.class, 17, "bee_flags");
        EntityDataNameMapper.registerDataName(bxz.class, 18, "anger_time");
        EntityDataNameMapper.registerDataName(byi.class, 17, "type");
        EntityDataNameMapper.registerDataName(byi.class, 18, "fox_flags");
        EntityDataNameMapper.registerDataName(byi.class, 19, "first_trusted_uuid");
        EntityDataNameMapper.registerDataName(byi.class, 20, "second_trusted_uuid");
        EntityDataNameMapper.registerDataName(bzn.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bzn.class, 18, "target_id");
        EntityDataNameMapper.registerDataName(bym.class, 17, "is_trusting");
        EntityDataNameMapper.registerDataName(byn.class, 17, "ask_for_bamboo_timer");
        EntityDataNameMapper.registerDataName(byn.class, 18, "sneeze_timer");
        EntityDataNameMapper.registerDataName(byn.class, 19, "eat_timer");
        EntityDataNameMapper.registerDataName(byn.class, 20, "main_gene");
        EntityDataNameMapper.registerDataName(byn.class, 21, "hidden_gene");
        EntityDataNameMapper.registerDataName(byn.class, 22, "panda_flags");
        EntityDataNameMapper.registerDataName(byp.class, 17, "has_saddle");
        EntityDataNameMapper.registerDataName(byp.class, 18, "boost_ticks");
        EntityDataNameMapper.registerDataName(bys.class, 17, "type");
        EntityDataNameMapper.registerDataName(byz.class, 17, "home_location");
        EntityDataNameMapper.registerDataName(byz.class, 18, "has_egg");
        EntityDataNameMapper.registerDataName(byz.class, 19, "laying_egg");
        EntityDataNameMapper.registerDataName(byz.class, 20, "travel_location");
        EntityDataNameMapper.registerDataName(byz.class, 21, "going_home");
        EntityDataNameMapper.registerDataName(byz.class, 20, "traveling");
        EntityDataNameMapper.registerDataName(byq.class, 17, "standing_up");
        EntityDataNameMapper.registerDataName(cds.class, 17, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(byl.class, 17, "variant");
        EntityDataNameMapper.registerDataName(byu.class, 17, "sheep_wool_flags");
        EntityDataNameMapper.registerDataName(cdc.class, 17, "boost_ticks");
        EntityDataNameMapper.registerDataName(cdc.class, 18, "shaking");
        EntityDataNameMapper.registerDataName(cdc.class, 19, "has_saddle");
        EntityDataNameMapper.registerDataName(bng.class, 17, "tamable_animal_flags");
        EntityDataNameMapper.registerDataName(bng.class, 18, "owner");
        EntityDataNameMapper.registerDataName(byb.class, 19, "variant");
        EntityDataNameMapper.registerDataName(byb.class, 20, "lying");
        EntityDataNameMapper.registerDataName(byb.class, 20, "relaxed");
        EntityDataNameMapper.registerDataName(byb.class, 21, "collar_color");
        EntityDataNameMapper.registerDataName(bzb.class, 19, "begging");
        EntityDataNameMapper.registerDataName(bzb.class, 20, "collar_color");
        EntityDataNameMapper.registerDataName(bzb.class, 21, "anger_time");
        EntityDataNameMapper.registerDataName(byo.class, 19, "variant");
        EntityDataNameMapper.registerDataName(ceq.class, 17, "head_shake_ticks");
        EntityDataNameMapper.registerDataName(cev.class, 18, "villager_data");
        EntityDataNameMapper.registerDataName(byk.class, 16, "iron_golem_flags");
        EntityDataNameMapper.registerDataName(byw.class, 16, "snow_golem_pumpkin_flags");
        EntityDataNameMapper.registerDataName(ccv.class, 16, "attach_face");
        EntityDataNameMapper.registerDataName(ccv.class, 17, "attachment_location");
        EntityDataNameMapper.registerDataName(ccv.class, 18, "peek");
        EntityDataNameMapper.registerDataName(ccv.class, 19, "color");
        EntityDataNameMapper.registerDataName(cdx.class, 16, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(cdy.class, 17, "is_baby");
        EntityDataNameMapper.registerDataName(cdy.class, 18, "charging_crossbow");
        EntityDataNameMapper.registerDataName(cdy.class, 19, "dancing");
        EntityDataNameMapper.registerDataName(cbz.class, 16, "blaze_flags");
        EntityDataNameMapper.registerDataName(ccb.class, 16, "state");
        EntityDataNameMapper.registerDataName(ccb.class, 17, "charged");
        EntityDataNameMapper.registerDataName(ccb.class, 18, "ignited");
        EntityDataNameMapper.registerDataName(bzt.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(bzt.class, 18, "has_left_horn");
        EntityDataNameMapper.registerDataName(bzt.class, 19, "has_right_horn");
        EntityDataNameMapper.registerDataName(ccl.class, 16, "spikes_retracted");
        EntityDataNameMapper.registerDataName(ccl.class, 17, "target_id");
        EntityDataNameMapper.registerDataName(cgr.class, 16, "celebrating");
        EntityDataNameMapper.registerDataName(ccs.class, 17, "charging_crossbow");
        EntityDataNameMapper.registerDataName(ccz.class, 17, "spell");
        EntityDataNameMapper.registerDataName(cdf.class, 17, "drinking_potion");
        EntityDataNameMapper.registerDataName(cdd.class, 16, "vex_flags");
        EntityDataNameMapper.registerDataName(cda.class, 16, "spider_flags");
        EntityDataNameMapper.registerDataName(cem.class, 16, "anger_level");
        EntityDataNameMapper.registerDataName(cbi.class, 16, "center_head_target");
        EntityDataNameMapper.registerDataName(cbi.class, 17, "left_head_target");
        EntityDataNameMapper.registerDataName(cbi.class, 18, "right_head_target");
        EntityDataNameMapper.registerDataName(cbi.class, 19, "invulnerable_time");
        EntityDataNameMapper.registerDataName(cdh.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cdi.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cdi.class, 17, "type");
        EntityDataNameMapper.registerDataName(cdi.class, 18, "converting_in_water");
        EntityDataNameMapper.registerDataName(cdj.class, 19, "is_converting");
        EntityDataNameMapper.registerDataName(cdj.class, 20, "villager_data");
        EntityDataNameMapper.registerDataName(ccf.class, 16, "carried_block");
        EntityDataNameMapper.registerDataName(ccf.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(ccf.class, 18, "staring");
        EntityDataNameMapper.registerDataName(cao.class, 16, "phase");
        EntityDataNameMapper.registerDataName(ccj.class, 16, "attacking");
        EntityDataNameMapper.registerDataName(ccr.class, 16, "size");
        EntityDataNameMapper.registerDataName(ccy.class, 16, "size");
        EntityDataNameMapper.registerDataName(cha.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(cha.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(cha.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(cha.class, 11, "display_block_id");
        EntityDataNameMapper.registerDataName(cha.class, 12, "display_block_y");
        EntityDataNameMapper.registerDataName(cha.class, 13, "show_display_block");
        EntityDataNameMapper.registerDataName(chj.class, 14, "has_fuel");
        EntityDataNameMapper.registerDataName(chi.class, 14, "command");
        EntityDataNameMapper.registerDataName(chi.class, 15, "last_output");
        EntityDataNameMapper.registerDataName(cbv.class, 8, "fuse_ticks");
    }
}

