/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.util.jnbt.FloatTag;
import com.denizenscript.denizen.nms.util.jnbt.JNBTListTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemArmorPose
extends ItemProperty<MapTag> {
    public static boolean describes(ItemTag item) {
        return item.getBukkitMaterial() == Material.ARMOR_STAND;
    }

    @Override
    public MapTag getPropertyValue() {
        CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(this.getItemStack());
        if (compoundTag == null) {
            return null;
        }
        Tag entPart = (Tag)compoundTag.getValue().get("EntityTag");
        if (!(entPart instanceof CompoundTag)) {
            return null;
        }
        Tag posePart = (Tag)((CompoundTag)entPart).getValue().get("Pose");
        if (!(posePart instanceof CompoundTag)) {
            return null;
        }
        CompoundTag pose = (CompoundTag)posePart;
        MapTag result = new MapTag();
        ItemArmorPose.procPart(pose, "Head", "head", result);
        ItemArmorPose.procPart(pose, "Body", "body", result);
        ItemArmorPose.procPart(pose, "LeftArm", "left_arm", result);
        ItemArmorPose.procPart(pose, "RightArm", "right_arm", result);
        ItemArmorPose.procPart(pose, "LeftLeg", "left_leg", result);
        ItemArmorPose.procPart(pose, "RightLeg", "right_leg", result);
        return result;
    }

    @Override
    public void setPropertyValue(MapTag param, Mechanism mechanism) {
        Tag entPart;
        CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(this.getItemStack());
        if (mechanism.hasValue()) {
            if (compoundTag == null) {
                compoundTag = new CompoundTagBuilder().build();
            }
            if (!((entPart = (Tag)compoundTag.getValue().get("EntityTag")) instanceof CompoundTag)) {
                entPart = new CompoundTagBuilder().build();
            }
            CompoundTagBuilder poseBuilder = new CompoundTagBuilder();
            ItemArmorPose.procMechKey(mechanism, poseBuilder, "Head", "head", param);
            ItemArmorPose.procMechKey(mechanism, poseBuilder, "Body", "body", param);
            ItemArmorPose.procMechKey(mechanism, poseBuilder, "LeftArm", "left_arm", param);
            ItemArmorPose.procMechKey(mechanism, poseBuilder, "RightArm", "right_arm", param);
            ItemArmorPose.procMechKey(mechanism, poseBuilder, "LeftLeg", "left_leg", param);
            ItemArmorPose.procMechKey(mechanism, poseBuilder, "RightLeg", "right_leg", param);
            CompoundTag pose = poseBuilder.build();
            entPart = pose.getValue().isEmpty() ? ((CompoundTag)entPart).createBuilder().remove("Pose").build() : ((CompoundTag)entPart).createBuilder().put("Pose", pose).build();
        } else {
            if (compoundTag == null) {
                return;
            }
            entPart = (Tag)compoundTag.getValue().get("EntityTag");
            if (!(entPart instanceof CompoundTag)) {
                return;
            }
            Tag posePart = (Tag)((CompoundTag)entPart).getValue().get("Pose");
            if (!(posePart instanceof CompoundTag)) {
                return;
            }
            entPart = ((CompoundTag)entPart).createBuilder().remove("Pose").build();
        }
        compoundTag = ((CompoundTag)entPart).getValue().isEmpty() ? compoundTag.createBuilder().remove("EntityTag").build() : compoundTag.createBuilder().put("EntityTag", entPart).build();
        ItemStack result = NMSHandler.itemHelper.setNbtData(this.getItemStack(), compoundTag);
        this.setItemStack(result);
    }

    @Override
    public String getPropertyId() {
        return "armor_pose";
    }

    public static void procPart(CompoundTag pose, String nmsName, String denizenName, MapTag result) {
        List<Tag> list = pose.getList(nmsName);
        if (list == null || list.size() != 3) {
            return;
        }
        Tag x = list.get(0);
        Tag y = list.get(1);
        Tag z = list.get(2);
        if (!(x instanceof FloatTag && y instanceof FloatTag && z instanceof FloatTag)) {
            return;
        }
        String combined = x.getValue() + "," + y.getValue() + "," + z.getValue();
        result.putObject(denizenName, (ObjectTag)new ElementTag(combined));
    }

    public static void register() {
        ItemArmorPose.autoRegister("armor_pose", ItemArmorPose.class, MapTag.class, false, new String[0]);
    }

    public static void procMechKey(Mechanism mech, CompoundTagBuilder pose, String nmsName, String denizenName, MapTag input) {
        ObjectTag value = input.getObject(denizenName);
        if (value == null) {
            return;
        }
        List<String> raw = CoreUtilities.split(value.toString(), ',');
        if (raw.size() != 3) {
            mech.echoError("Invalid pose piece '" + value + "'");
            return;
        }
        ArrayList<FloatTag> rawList = new ArrayList<FloatTag>();
        for (int i = 0; i < 3; ++i) {
            rawList.add(new FloatTag(Float.parseFloat(raw.get(i))));
        }
        JNBTListTag list = new JNBTListTag(FloatTag.class, rawList);
        pose.put(nmsName, list);
    }
}

