/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.bukkit.BukkitColorExtensions;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SuspiciousStewMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class ItemPotion
extends ItemProperty<ObjectTag> {
    public static boolean describes(ItemTag item) {
        return item.getItemMeta() instanceof PotionMeta || item.getItemMeta() instanceof SuspiciousStewMeta;
    }

    public static MapTag effectToMap(PotionEffect effect) {
        MapTag map = new MapTag();
        map.putObject("type", (ObjectTag)new ElementTag(effect.getType().getName()));
        map.putObject("amplifier", (ObjectTag)new ElementTag(effect.getAmplifier()));
        map.putObject("duration", (ObjectTag)new DurationTag((long)effect.getDuration()));
        map.putObject("ambient", (ObjectTag)new ElementTag(effect.isAmbient()));
        map.putObject("particles", (ObjectTag)new ElementTag(effect.hasParticles()));
        map.putObject("icon", (ObjectTag)new ElementTag(effect.hasIcon()));
        return map;
    }

    public ListTag getMapTagData(boolean includeExtras) {
        List<PotionEffect> potionEffects = this.getCustomEffects();
        ListTag result = new ListTag(potionEffects.size() + 1);
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            MapTag base = new MapTag();
            if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20)) {
                base.putObject("base_type", (ObjectTag)new ElementTag(Utilities.namespacedKeyToString(potionMeta.getBasePotionType().getKey()), true));
            } else {
                includeExtras = true;
            }
            if (includeExtras) {
                base.putObject("type", (ObjectTag)new ElementTag((Enum<?>)potionMeta.getBasePotionData().getType()));
                base.putObject("upgraded", (ObjectTag)new ElementTag(potionMeta.getBasePotionData().isUpgraded()));
                base.putObject("extended", (ObjectTag)new ElementTag(potionMeta.getBasePotionData().isExtended()));
                if (potionMeta.hasColor()) {
                    base.putObject("color", (ObjectTag)BukkitColorExtensions.fromColor(potionMeta.getColor()));
                }
            }
            result.addObject(base);
        }
        for (PotionEffect potionEffect : potionEffects) {
            result.addObject(ItemPotion.effectToMap(potionEffect));
        }
        return result;
    }

    public static PotionEffect parseEffect(MapTag effectMap, TagContext context) {
        PotionEffectType type;
        DurationTag duration = new DurationTag(0);
        int amplifier = 0;
        boolean ambient = true;
        boolean particles = true;
        boolean icon = false;
        if (effectMap.containsKey("type")) {
            String typeString = effectMap.getObject("type").toString();
            type = PotionEffectType.getByName((String)typeString);
            if (type == null) {
                if (context.showErrors()) {
                    Debug.echoError("Invalid potion effect type '" + typeString + "': effect type is required.");
                }
                return null;
            }
        } else {
            if (context.showErrors()) {
                Debug.echoError("Invalid potion effect type: effect type is required.");
            }
            return null;
        }
        if (effectMap.containsKey("amplifier")) {
            ElementTag amplifierElement = effectMap.getElement("amplifier");
            if (amplifierElement.isInt()) {
                amplifier = amplifierElement.asInt();
            } else if (context.showErrors()) {
                Debug.echoError("Invalid amplifier '" + amplifierElement + "': must be an integer.");
            }
        }
        if (effectMap.containsKey("duration")) {
            ObjectTag durationObj = effectMap.getObject("duration");
            if (durationObj.canBeType(DurationTag.class)) {
                duration = durationObj.asType(DurationTag.class, context);
            } else if (context.showErrors()) {
                Debug.echoError("Invalid duration '" + durationObj + "': must be a valid DurationTag");
            }
        }
        if (effectMap.containsKey("ambient")) {
            ElementTag ambientElement = effectMap.getElement("ambient");
            if (ambientElement.isBoolean()) {
                ambient = ambientElement.asBoolean();
            } else if (context.showErrors()) {
                Debug.echoError("Invalid ambient state '" + ambientElement + "': must be a boolean.");
            }
        }
        if (effectMap.containsKey("particles")) {
            ElementTag particlesElement = effectMap.getElement("particles");
            if (particlesElement.isBoolean()) {
                particles = particlesElement.asBoolean();
            } else if (context.showErrors()) {
                Debug.echoError("Invalid particles state '" + particlesElement + "': must be a boolean.");
            }
        }
        if (effectMap.containsKey("icon")) {
            ElementTag iconElement = effectMap.getElement("icon");
            if (iconElement.isBoolean()) {
                icon = iconElement.asBoolean();
            } else if (context.showErrors()) {
                Debug.echoError("Invalid icon state '" + iconElement + "': must be a boolean.");
            }
        }
        return new PotionEffect(type, duration.getTicksAsInt(), amplifier, ambient, particles, icon);
    }

    public List<PotionEffect> getCustomEffects() {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta instanceof SuspiciousStewMeta) {
            SuspiciousStewMeta suspiciousStewMeta = (SuspiciousStewMeta)itemMeta;
            return suspiciousStewMeta.getCustomEffects();
        }
        return this.as(PotionMeta.class).getCustomEffects();
    }

    @Override
    public ListTag getPropertyValue() {
        return this.getMapTagData(false);
    }

    @Override
    public void setPropertyValue(ObjectTag value, Mechanism mechanism) {
        ArrayList<ObjectTag> data = new ArrayList<ObjectTag>(CoreUtilities.objectToList(value, mechanism.context));
        ItemMeta meta = this.getItemMeta();
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            ObjectTag firstObj = (ObjectTag)data.remove(0);
            if (firstObj.canBeType(MapTag.class)) {
                MapTag baseEffect = firstObj.asType(MapTag.class, mechanism.context);
                if (baseEffect.containsKey("base_type")) {
                    ElementTag baseTypeElement = baseEffect.getElement("base_type");
                    PotionType type = (PotionType)Registry.POTION.get(Utilities.parseNamespacedKey(baseTypeElement.asString()));
                    if (type == null && baseTypeElement.matchesEnum(PotionType.class)) {
                        type = baseTypeElement.asEnum(PotionType.class);
                    }
                    if (type == null) {
                        mechanism.echoError("Invalid base potion type '" + baseTypeElement + "': valid base potion_type is required");
                        return;
                    }
                    potionMeta.setBasePotionType(type);
                } else {
                    ItemPotion.applyLegacyMapBasePotionData(baseEffect, potionMeta, mechanism);
                }
            } else {
                ItemPotion.applyLegacyStringBasePotionData(firstObj.toString(), potionMeta, mechanism);
            }
            potionMeta.clearCustomEffects();
        } else {
            ((SuspiciousStewMeta)meta).clearCustomEffects();
        }
        for (ObjectTag effectObj : data) {
            PotionEffect effect = effectObj.canBeType(MapTag.class) ? ItemPotion.parseEffect(effectObj.asType(MapTag.class, mechanism.context), mechanism.context) : ItemPotion.parseLegacyEffectString(effectObj.toString(), mechanism.context);
            if (effect == null) {
                mechanism.echoError("Invalid potion effect '" + effectObj + "'");
                continue;
            }
            if (meta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)meta;
                potionMeta.addCustomEffect(effect, false);
                continue;
            }
            ((SuspiciousStewMeta)meta).addCustomEffect(effect, false);
        }
        this.setItemMeta(meta);
    }

    @Override
    public String getPropertyId() {
        return "potion_effects";
    }

    public static void register() {
        PropertyParser.registerTag(ItemPotion.class, ListTag.class, "effects_data", (attribute, prop) -> prop.getMapTagData(true), new String[0]);
        PropertyParser.registerMechanism(ItemPotion.class, ObjectTag.class, "potion_effects", (prop, mechanism, input) -> prop.setPropertyValue(input, mechanism), new String[0]);
        PropertyParser.registerTag(ItemPotion.class, ElementTag.class, "has_potion_effect", (attribute, object) -> {
            boolean bl;
            ItemMeta patt12975$temp = object.getItemMeta();
            if (patt12975$temp instanceof SuspiciousStewMeta) {
                SuspiciousStewMeta suspiciousStewMeta = (SuspiciousStewMeta)patt12975$temp;
                bl = suspiciousStewMeta.hasCustomEffects();
            } else {
                bl = object.as(PotionMeta.class).hasCustomEffects();
            }
            return new ElementTag(bl);
        }, new String[0]);
        PropertyParser.registerTag(ItemPotion.class, ElementTag.class, "potion_base_type", (attribute, object) -> {
            ItemMeta patt13793$temp = object.getItemMeta();
            if (!(patt13793$temp instanceof PotionMeta)) {
                attribute.echoError("This item does not have a base potion type.");
                return null;
            }
            PotionMeta potionMeta = (PotionMeta)patt13793$temp;
            BukkitImplDeprecations.oldPotionEffects.warn(attribute.context);
            return new ElementTag((Enum<?>)potionMeta.getBasePotionData().getType());
        }, new String[0]);
        PropertyParser.registerTag(ItemPotion.class, ElementTag.class, "potion_base", (attribute, object) -> {
            ItemMeta patt14616$temp = object.getItemMeta();
            if (!(patt14616$temp instanceof PotionMeta)) {
                attribute.echoError("This item does not have a base potion type.");
                return null;
            }
            PotionMeta potionMeta = (PotionMeta)patt14616$temp;
            BukkitImplDeprecations.oldPotionEffects.warn(attribute.context);
            return new ElementTag(potionMeta.getBasePotionData().getType().name() + "," + (potionMeta.getBasePotionData().isUpgraded() ? 2 : 1) + "," + potionMeta.getBasePotionData().isExtended() + "," + (object.getMaterial() == Material.SPLASH_POTION) + (String)(potionMeta.hasColor() ? "," + BukkitColorExtensions.fromColor(potionMeta.getColor()).identify() : ""));
        }, new String[0]);
        PropertyParser.registerTag(ItemPotion.class, ListTag.class, "potion_effects", (attribute, object) -> {
            ListTag result = new ListTag();
            for (PotionEffect pot : object.getCustomEffects()) {
                result.add(ItemPotion.effectToLegacyString(pot, attribute.context));
            }
            return result;
        }, new String[0]);
        PropertyParser.registerTag(ItemPotion.class, ElementTag.class, "potion_effect", (attribute, object) -> {
            int potN;
            BukkitImplDeprecations.oldPotionEffects.warn(attribute.context);
            int n = potN = attribute.hasParam() ? attribute.getIntParam() - 1 : 0;
            if (potN < 0 || potN > object.getCustomEffects().size()) {
                return null;
            }
            if (attribute.startsWith("is_splash", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getMaterial() == Material.SPLASH_POTION);
            }
            if (attribute.startsWith("is_extended", 2)) {
                attribute.fulfill(1);
                ItemMeta patt17038$temp = object.getItemMeta();
                if (!(patt17038$temp instanceof PotionMeta)) {
                    return null;
                }
                PotionMeta potionMeta = (PotionMeta)patt17038$temp;
                return new ElementTag(potionMeta.getBasePotionData().isExtended());
            }
            if (attribute.startsWith("level", 2)) {
                attribute.fulfill(1);
                ItemMeta patt17364$temp = object.getItemMeta();
                if (!(patt17364$temp instanceof PotionMeta)) {
                    return null;
                }
                PotionMeta potionMeta = (PotionMeta)patt17364$temp;
                return new ElementTag(potionMeta.getBasePotionData().isUpgraded() ? 2 : 1);
            }
            if (attribute.startsWith("is_ambient", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getCustomEffects().get(potN).isAmbient());
            }
            if (attribute.startsWith("icon", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getCustomEffects().get(potN).hasIcon());
            }
            if (attribute.startsWith("has_particles", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getCustomEffects().get(potN).hasParticles());
            }
            if (attribute.startsWith("duration", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getCustomEffects().get(potN).getDuration());
            }
            if (attribute.startsWith("amplifier", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getCustomEffects().get(potN).getAmplifier());
            }
            if (attribute.startsWith("type", 2)) {
                attribute.fulfill(1);
                return new ElementTag(object.getCustomEffects().get(potN).getType().getName());
            }
            if (attribute.startsWith("data", 2)) {
                attribute.fulfill(1);
                return new ElementTag(0);
            }
            ItemMeta patt18959$temp = object.getItemMeta();
            if (!(patt18959$temp instanceof PotionMeta)) {
                return null;
            }
            PotionMeta potionMeta = (PotionMeta)patt18959$temp;
            PotionData data = potionMeta.getBasePotionData();
            return new ElementTag(data.getType().name() + "," + (data.isUpgraded() ? 2 : 1) + "," + data.isExtended() + "," + (object.getMaterial() == Material.SPLASH_POTION));
        }, new String[0]);
    }

    private static void applyLegacyMapBasePotionData(MapTag input, PotionMeta potionMeta, Mechanism mechanism) {
        if (!input.containsKey("type")) {
            mechanism.echoError("Must specify a base potion type.");
            return;
        }
        ElementTag typeElement = input.getElement("type");
        if (!typeElement.matchesEnum(PotionType.class)) {
            mechanism.echoError("Invalid base potion type '" + typeElement + "': type is required");
            return;
        }
        PotionType type = PotionType.valueOf((String)typeElement.asString().toUpperCase());
        boolean upgraded = false;
        boolean extended = false;
        if (input.containsKey("upgraded")) {
            ElementTag upgradedElement = input.getElement("upgraded");
            if (upgradedElement.isBoolean()) {
                upgraded = upgradedElement.asBoolean();
            } else {
                mechanism.echoError("Invalid upgraded state '" + upgradedElement + "': must be a boolean");
            }
        }
        if (input.containsKey("extended")) {
            ElementTag extendedElement = input.getElement("extended");
            if (extendedElement.isBoolean()) {
                extended = extendedElement.asBoolean();
            } else {
                mechanism.echoError("Invalid extended state '" + extendedElement + "': must be a boolean");
            }
        }
        ColorTag color = null;
        if (input.containsKey("color")) {
            ObjectTag colorObj = input.getObject("color");
            if (colorObj.canBeType(ColorTag.class)) {
                color = colorObj.asType(ColorTag.class, mechanism.context);
            } else {
                mechanism.echoError("Invalid color '" + colorObj + "': must be a valid ColorTag");
            }
        }
        ItemPotion.applyLegacyBasePotionData(potionMeta, type, upgraded, extended, color, mechanism);
    }

    private static void applyLegacyStringBasePotionData(String input, PotionMeta potionMeta, Mechanism mechanism) {
        PotionType type;
        String[] d1 = input.split(",");
        try {
            type = PotionType.valueOf((String)d1[0].toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            mechanism.echoError("Invalid base potion type '" + d1[0] + "': type is required");
            return;
        }
        boolean upgraded = CoreUtilities.equalsIgnoreCase(d1[1], "true");
        boolean extended = CoreUtilities.equalsIgnoreCase(d1[2], "true");
        ColorTag color = null;
        if (d1.length > 3) {
            ColorTag temp = ColorTag.valueOf(d1[3].replace("&comma", ","), mechanism.context);
            if (temp == null) {
                mechanism.echoError("Invalid color '" + d1[3] + "': must be a valid ColorTag");
            } else {
                color = temp;
            }
        }
        ItemPotion.applyLegacyBasePotionData(potionMeta, type, upgraded, extended, color, mechanism);
    }

    private static void applyLegacyBasePotionData(PotionMeta potionMeta, PotionType type, boolean upgraded, boolean extended, ColorTag color, Mechanism mechanism) {
        if (upgraded && !type.isUpgradeable()) {
            mechanism.echoError("Cannot upgrade potion of type '" + type.name() + "'");
            upgraded = false;
        }
        if (extended && !type.isExtendable()) {
            mechanism.echoError("Cannot extend potion of type '" + type.name() + "'");
            extended = false;
        }
        if (upgraded && extended) {
            mechanism.echoError("Cannot both upgrade and extend a potion");
            extended = false;
        }
        potionMeta.setBasePotionData(new PotionData(type, extended, upgraded));
        if (color != null) {
            potionMeta.setColor(BukkitColorExtensions.getColor(color));
        }
    }

    public static String effectToLegacyString(PotionEffect effect, TagContext context) {
        BukkitImplDeprecations.oldPotionEffects.warn(context);
        return effect.getType().getName() + "," + effect.getAmplifier() + "," + effect.getDuration() + "," + effect.isAmbient() + "," + effect.hasParticles() + "," + effect.hasIcon();
    }

    public static PotionEffect parseLegacyEffectString(String str, TagContext context) {
        ElementTag check;
        PotionEffectType type;
        String[] d2 = str.split(",");
        try {
            type = PotionEffectType.getByName((String)d2[0].toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            if (context.showErrors()) {
                Debug.echoError("Invalid potion effect type '" + d2[0] + "'");
            }
            return null;
        }
        if (d2.length < 3) {
            return null;
        }
        int duration = new ElementTag(d2[2]).asInt();
        int amplifier = new ElementTag(d2[1]).asInt();
        boolean ambient = true;
        boolean particles = true;
        if (d2.length > 3) {
            ambient = new ElementTag(d2[3]).asBoolean();
            particles = new ElementTag(d2[4]).asBoolean();
        }
        boolean icon = false;
        if (d2.length > 5 && (check = new ElementTag(d2[5])).isBoolean()) {
            icon = check.asBoolean();
        }
        return new PotionEffect(type, duration, amplifier, ambient, particles, icon);
    }
}

