/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.destroystokyo.paper.event.entity.ProjectileCollideEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class ProjectileCollideScriptEvent
extends BukkitScriptEvent
implements Listener {
    public ProjectileCollideEvent event;
    public EntityTag projectile;
    public EntityTag collidedWith;

    public ProjectileCollideScriptEvent() {
        this.registerCouldMatcher("<projectile> collides with <entity>");
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!super.couldMatch(path)) {
            return false;
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_19)) {
            BukkitImplDeprecations.projectileCollideEvent.warn(path.container);
        }
        return true;
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getEntity().getLocation())) {
            return false;
        }
        if (!path.tryArgObject(0, this.projectile)) {
            return false;
        }
        if (!path.tryArgObject(3, this.collidedWith)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.collidedWith);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "entity" -> this.collidedWith.getDenizenObject();
            case "projectile" -> this.projectile;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void projectileCollideEvent(ProjectileCollideEvent event) {
        this.event = event;
        this.collidedWith = new EntityTag(event.getCollidedWith());
        this.projectile = new EntityTag((Entity)event.getEntity());
        this.fire((Event)event);
    }
}

