/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.util.Vector;

public class AttachPacketHandlers {
    public static Field POS_X_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_xa, Short.TYPE);
    public static Field POS_Y_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_ya, Short.TYPE);
    public static Field POS_Z_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_za, Short.TYPE);
    public static Field YAW_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_yRot, Byte.TYPE);
    public static Field PITCH_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_xRot, Byte.TYPE);
    public static Field ENTITY_ID_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_id, Integer.TYPE);
    public static Field POS_X_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_x, Double.TYPE);
    public static Field POS_Y_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_y, Double.TYPE);
    public static Field POS_Z_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_z, Double.TYPE);
    public static Field YAW_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_yRot, Byte.TYPE);
    public static Field PITCH_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_xRot, Byte.TYPE);
    public static Field ENTITY_ID_PACKVELENT = ReflectionHelper.getFields(PacketPlayOutEntityVelocity.class).get(ReflectionMappingsInfo.ClientboundSetEntityMotionPacket_id, Integer.TYPE);
    public static Vector VECTOR_ZERO = new Vector(0, 0, 0);

    public static void registerHandlers() {
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntity.class, AttachPacketHandlers::processAttachToForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityHeadRotation.class, AttachPacketHandlers::processAttachToForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityVelocity.class, AttachPacketHandlers::processAttachToForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityTeleport.class, AttachPacketHandlers::processAttachToForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityDestroy.class, AttachPacketHandlers::processAttachToForPacket);
    }

    public static void tryProcessMovePacketForAttach(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntity packet, Entity e) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = (EntityAttachmentHelper.EntityAttachedToMap)EntityAttachmentHelper.toEntityToData.get(e.cw());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                PacketPlayOutEntity.PacketPlayOutRelEntityMove pNew;
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(networkManager.player.cw());
                if (!attMap.attached.isValid() || att == null) continue;
                int newId = att.attached.getBukkitEntity().getEntityId();
                if (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMove) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(newId, packet.a(), packet.d(), packet.e(), packet.j());
                } else if (packet instanceof PacketPlayOutEntity.PacketPlayOutEntityLook) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutEntityLook(newId, packet.f(), packet.g(), packet.j());
                } else if (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(newId, packet.a(), packet.d(), packet.e(), packet.f(), packet.g(), packet.j());
                } else {
                    if (CoreConfiguration.debugVerbose) {
                        Debug.echoError((String)("Impossible move-entity packet class: " + packet.getClass().getCanonicalName()));
                    }
                    return;
                }
                if (att.positionalOffset != null) {
                    byte pitch;
                    byte yaw;
                    Entity attachedEntity;
                    boolean isRotate;
                    boolean bl = isRotate = packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook || packet instanceof PacketPlayOutEntity.PacketPlayOutEntityLook;
                    if (att.noRotate) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        yaw = EntityAttachmentHelper.compressAngle((float)attachedEntity.dC());
                        pitch = EntityAttachmentHelper.compressAngle((float)attachedEntity.dE());
                    } else if (isRotate) {
                        yaw = packet.f();
                        pitch = packet.g();
                    } else {
                        yaw = EntityAttachmentHelper.compressAngle((float)e.dC());
                        pitch = EntityAttachmentHelper.compressAngle((float)e.dE());
                    }
                    if (att.noPitch) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        pitch = EntityAttachmentHelper.compressAngle((float)attachedEntity.dE());
                    }
                    byte newYaw = yaw;
                    if (isRotate) {
                        newYaw = EntityAttachmentHelper.adaptedCompressedAngle((byte)newYaw, (float)att.positionalOffset.getYaw());
                        pitch = EntityAttachmentHelper.adaptedCompressedAngle((byte)pitch, (float)att.positionalOffset.getPitch());
                    }
                    Vector goalPosition = att.fixedForOffset(new Vector(e.dr(), e.dt(), e.dx()), e.dC(), e.dE());
                    Vector oldPos = (Vector)att.visiblePositions.get(networkManager.player.cw());
                    boolean forceTele = false;
                    if (oldPos == null) {
                        oldPos = att.attached.getLocation().toVector();
                        forceTele = true;
                    }
                    Vector moveNeeded = goalPosition.clone().subtract(oldPos);
                    att.visiblePositions.put(networkManager.player.cw(), goalPosition.clone());
                    int offX = (int)(moveNeeded.getX() * 4096.0);
                    int offY = (int)(moveNeeded.getY() * 4096.0);
                    int offZ = (int)(moveNeeded.getZ() * 4096.0);
                    if (isRotate && att.offsetRelative || forceTele || offX < Short.MIN_VALUE || offX > Short.MAX_VALUE || offY < Short.MIN_VALUE || offY > Short.MAX_VALUE || offZ < Short.MIN_VALUE || offZ > Short.MAX_VALUE) {
                        PacketPlayOutEntityTeleport newTeleportPacket = new PacketPlayOutEntityTeleport(e);
                        ENTITY_ID_PACKTELENT.setInt(newTeleportPacket, att.attached.getBukkitEntity().getEntityId());
                        POS_X_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getX());
                        POS_Y_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getY());
                        POS_Z_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getZ());
                        YAW_PACKTELENT.setByte(newTeleportPacket, newYaw);
                        PITCH_PACKTELENT.setByte(newTeleportPacket, pitch);
                        if (NMSHandler.debugPackets) {
                            DenizenNetworkManagerImpl.doPacketOutput("Attach Move-Tele Packet: " + newTeleportPacket.getClass().getCanonicalName() + " for " + att.attached.getUUID() + " sent to " + networkManager.player.cy() + " with original yaw " + yaw + " adapted to " + newYaw);
                        }
                        networkManager.oldManager.a((Packet)newTeleportPacket);
                        continue;
                    }
                    POS_X_PACKENT.setShort(pNew, (short)MathHelper.a((int)offX, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    POS_Y_PACKENT.setShort(pNew, (short)MathHelper.a((int)offY, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    POS_Z_PACKENT.setShort(pNew, (short)MathHelper.a((int)offZ, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    if (isRotate) {
                        YAW_PACKENT.setByte(pNew, yaw);
                        PITCH_PACKENT.setByte(pNew, pitch);
                    }
                    if (NMSHandler.debugPackets) {
                        DenizenNetworkManagerImpl.doPacketOutput("Attach Move Packet: " + pNew.getClass().getCanonicalName() + " for " + att.attached.getUUID() + " sent to " + networkManager.player.cy() + " with original yaw " + yaw + " adapted to " + newYaw);
                    }
                    networkManager.oldManager.a((Packet)pNew);
                    continue;
                }
                if (NMSHandler.debugPackets) {
                    DenizenNetworkManagerImpl.doPacketOutput("Attach Replica-Move Packet: " + pNew.getClass().getCanonicalName() + " for " + att.attached.getUUID() + " sent to " + networkManager.player.cy());
                }
                networkManager.oldManager.a((Packet)pNew);
            }
        }
        if (e.r != null && !e.r.isEmpty()) {
            for (Entity ent : e.r) {
                AttachPacketHandlers.tryProcessMovePacketForAttach(networkManager, packet, ent);
            }
        }
    }

    public static void tryProcessRotateHeadPacketForAttach(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntityHeadRotation packet, Entity e) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = (EntityAttachmentHelper.EntityAttachedToMap)EntityAttachmentHelper.toEntityToData.get(e.cw());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(networkManager.player.cw());
                if (!attMap.attached.isValid() || att == null) continue;
                byte yaw = packet.a();
                Entity attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                if (att.positionalOffset != null) {
                    if (att.noRotate) {
                        yaw = EntityAttachmentHelper.compressAngle((float)attachedEntity.dC());
                    }
                    yaw = EntityAttachmentHelper.adaptedCompressedAngle((byte)yaw, (float)att.positionalOffset.getYaw());
                }
                PacketPlayOutEntityHeadRotation pNew = new PacketPlayOutEntityHeadRotation(attachedEntity, yaw);
                if (NMSHandler.debugPackets) {
                    DenizenNetworkManagerImpl.doPacketOutput("Head Rotation Packet: " + pNew.getClass().getCanonicalName() + " for " + att.attached.getUUID() + " sent to " + networkManager.player.cy());
                }
                networkManager.oldManager.a((Packet)pNew);
            }
        }
        if (e.r != null && !e.r.isEmpty()) {
            for (Entity ent : e.r) {
                AttachPacketHandlers.tryProcessRotateHeadPacketForAttach(networkManager, packet, ent);
            }
        }
    }

    public static void tryProcessVelocityPacketForAttach(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntityVelocity packet, Entity e) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = (EntityAttachmentHelper.EntityAttachedToMap)EntityAttachmentHelper.toEntityToData.get(e.cw());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(networkManager.player.cw());
                if (!attMap.attached.isValid() || att == null) continue;
                PacketPlayOutEntityVelocity pNew = new PacketPlayOutEntityVelocity(DenizenNetworkManagerImpl.copyPacket(packet));
                ENTITY_ID_PACKVELENT.setInt(pNew, att.attached.getBukkitEntity().getEntityId());
                if (NMSHandler.debugPackets) {
                    DenizenNetworkManagerImpl.doPacketOutput("Attach Velocity Packet: " + pNew.getClass().getCanonicalName() + " for " + att.attached.getUUID() + " sent to " + networkManager.player.cy());
                }
                networkManager.oldManager.a((Packet)pNew);
            }
        }
        if (e.r != null && !e.r.isEmpty()) {
            for (Entity ent : e.r) {
                AttachPacketHandlers.tryProcessVelocityPacketForAttach(networkManager, packet, ent);
            }
        }
    }

    public static void tryProcessTeleportPacketForAttach(DenizenNetworkManagerImpl networkManager, PacketPlayOutEntityTeleport packet, Entity e, Vector relative) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = (EntityAttachmentHelper.EntityAttachedToMap)EntityAttachmentHelper.toEntityToData.get(e.cw());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(networkManager.player.cw());
                if (!attMap.attached.isValid() || att == null) continue;
                PacketPlayOutEntityTeleport pNew = new PacketPlayOutEntityTeleport(DenizenNetworkManagerImpl.copyPacket(packet));
                ENTITY_ID_PACKTELENT.setInt(pNew, att.attached.getBukkitEntity().getEntityId());
                Vector resultPos = new Vector(POS_X_PACKTELENT.getDouble(pNew), POS_Y_PACKTELENT.getDouble(pNew), POS_Z_PACKTELENT.getDouble(pNew)).add(relative);
                if (att.positionalOffset != null) {
                    byte pitch;
                    byte yaw;
                    Entity attachedEntity;
                    resultPos = att.fixedForOffset(resultPos, e.dC(), e.dE());
                    if (att.noRotate) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        yaw = EntityAttachmentHelper.compressAngle((float)attachedEntity.dC());
                        pitch = EntityAttachmentHelper.compressAngle((float)attachedEntity.dE());
                    } else {
                        yaw = packet.g();
                        pitch = packet.h();
                    }
                    if (att.noPitch) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        pitch = EntityAttachmentHelper.compressAngle((float)attachedEntity.dE());
                    }
                    byte newYaw = EntityAttachmentHelper.adaptedCompressedAngle((byte)yaw, (float)att.positionalOffset.getYaw());
                    pitch = EntityAttachmentHelper.adaptedCompressedAngle((byte)pitch, (float)att.positionalOffset.getPitch());
                    POS_X_PACKTELENT.setDouble(pNew, resultPos.getX());
                    POS_Y_PACKTELENT.setDouble(pNew, resultPos.getY());
                    POS_Z_PACKTELENT.setDouble(pNew, resultPos.getZ());
                    YAW_PACKTELENT.setByte(pNew, newYaw);
                    PITCH_PACKTELENT.setByte(pNew, pitch);
                    if (NMSHandler.debugPackets) {
                        DenizenNetworkManagerImpl.doPacketOutput("Attach Teleport Packet: " + pNew.getClass().getCanonicalName() + " for " + att.attached.getUUID() + " sent to " + networkManager.player.cy() + " with raw yaw " + yaw + " adapted to " + newYaw);
                    }
                }
                att.visiblePositions.put(networkManager.player.cw(), resultPos.clone());
                networkManager.oldManager.a((Packet)pNew);
            }
        }
        if (e.r != null && !e.r.isEmpty()) {
            for (Entity ent : e.r) {
                AttachPacketHandlers.tryProcessTeleportPacketForAttach(networkManager, packet, ent, new Vector(ent.dr() - e.dr(), ent.dt() - e.dt(), ent.dx() - e.dx()));
            }
        }
    }

    public static Packet<PacketListenerPlayOut> processAttachToForPacket(DenizenNetworkManagerImpl networkManager, Packet<PacketListenerPlayOut> packet) {
        if (EntityAttachmentHelper.toEntityToData.isEmpty()) {
            return packet;
        }
        try {
            if (packet instanceof PacketPlayOutEntity) {
                PacketPlayOutEntity moveEntityPacket = (PacketPlayOutEntity)packet;
                Entity e = moveEntityPacket.a(networkManager.player.dM());
                if (e == null) {
                    return packet;
                }
                if (!e.bO()) {
                    AttachPacketHandlers.tryProcessMovePacketForAttach(networkManager, moveEntityPacket, e);
                }
                return EntityAttachmentHelper.denyOriginalPacketSend((UUID)networkManager.player.cw(), (UUID)e.cw()) ? null : packet;
            }
            if (packet instanceof PacketPlayOutEntityHeadRotation) {
                PacketPlayOutEntityHeadRotation rotateHeadPacket = (PacketPlayOutEntityHeadRotation)packet;
                Entity e = rotateHeadPacket.a(networkManager.player.dM());
                if (e == null) {
                    return packet;
                }
                AttachPacketHandlers.tryProcessRotateHeadPacketForAttach(networkManager, rotateHeadPacket, e);
                return EntityAttachmentHelper.denyOriginalPacketSend((UUID)networkManager.player.cw(), (UUID)e.cw()) ? null : packet;
            }
            if (packet instanceof PacketPlayOutEntityVelocity) {
                PacketPlayOutEntityVelocity setEntityMotionPacket = (PacketPlayOutEntityVelocity)packet;
                int ider = setEntityMotionPacket.a();
                Entity e = networkManager.player.dM().a(ider);
                if (e == null) {
                    return packet;
                }
                AttachPacketHandlers.tryProcessVelocityPacketForAttach(networkManager, setEntityMotionPacket, e);
                return EntityAttachmentHelper.denyOriginalPacketSend((UUID)networkManager.player.cw(), (UUID)e.cw()) ? null : packet;
            }
            if (packet instanceof PacketPlayOutEntityTeleport) {
                PacketPlayOutEntityTeleport teleportEntityPacket = (PacketPlayOutEntityTeleport)packet;
                int ider = teleportEntityPacket.a();
                Entity e = networkManager.player.dM().a(ider);
                if (e == null) {
                    return packet;
                }
                AttachPacketHandlers.tryProcessTeleportPacketForAttach(networkManager, teleportEntityPacket, e, VECTOR_ZERO);
                return EntityAttachmentHelper.denyOriginalPacketSend((UUID)networkManager.player.cw(), (UUID)e.cw()) ? null : packet;
            }
            if (packet instanceof PacketPlayOutEntityDestroy) {
                PacketPlayOutEntityDestroy removeEntitiesPacket = (PacketPlayOutEntityDestroy)packet;
                IntListIterator intListIterator = removeEntitiesPacket.a().iterator();
                while (intListIterator.hasNext()) {
                    EntityAttachmentHelper.EntityAttachedToMap attList;
                    int id = (Integer)intListIterator.next();
                    Entity e = networkManager.player.dM().a(id);
                    if (e == null || (attList = (EntityAttachmentHelper.EntityAttachedToMap)EntityAttachmentHelper.toEntityToData.get(e.cw())) == null) continue;
                    for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                        EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(networkManager.player.cw());
                        if (!attMap.attached.isValid() || att == null) continue;
                        att.visiblePositions.remove(networkManager.player.cw());
                    }
                }
            }
        }
        catch (Exception ex) {
            Debug.echoError((Throwable)ex);
        }
        return packet;
    }
}

