/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects;

import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;

public class Mechanism {
    private boolean fulfilled = false;
    private String raw_mechanism;
    public ObjectTag value;
    public ObjectTag adjusting;
    public TagContext context;
    public boolean isProperty = false;

    public Mechanism(String mechanism, ObjectTag value, TagContext context) {
        this.raw_mechanism = CoreUtilities.toLowerCase(mechanism);
        this.value = value;
        this.context = context;
    }

    public void fulfill() {
        this.fulfilled = true;
    }

    public boolean fulfilled() {
        return this.fulfilled;
    }

    public String getName() {
        return this.raw_mechanism;
    }

    public ElementTag getValue() {
        if (this.value == null) {
            return new ElementTag("");
        }
        return this.value.asElement();
    }

    public <T extends ObjectTag> T valueAsType(Class<T> dClass) {
        return this.getValue().asType(dClass, this.context);
    }

    public boolean hasValue() {
        ElementTag element;
        if (this.value == null) {
            return false;
        }
        ObjectTag objectTag = this.value;
        return !(objectTag instanceof ElementTag) || !(element = (ElementTag)objectTag).asString().isEmpty();
    }

    public boolean matches(String string) {
        if (string.equals(this.raw_mechanism)) {
            this.fulfill();
            return true;
        }
        return false;
    }

    public String forMechanismText() {
        String text = " <LR>For mechanism '<A>" + this.raw_mechanism + "<LR>'" + (String)(this.value == null ? "" : " with value '<A>" + String.valueOf(this.value) + "<LR>'");
        if (this.adjusting == null) {
            return text;
        }
        return text + ", while " + (this.isProperty ? "applying properties to" : "adjusting") + " object '<A>" + this.adjusting.debuggable() + "<LR>'";
    }

    public boolean requireBoolean() {
        return this.requireBoolean("Invalid boolean. Must specify TRUE or FALSE.");
    }

    public boolean requireDouble() {
        return this.requireDouble("Invalid decimal number specified.");
    }

    public boolean requireEnum(Class<? extends Enum> clazz) {
        return this.requireEnum(null, clazz);
    }

    public boolean requireFloat() {
        return this.requireFloat("Invalid decimal number specified.");
    }

    public boolean requireInteger() {
        return this.requireInteger("Invalid integer number specified.");
    }

    public <T extends ObjectTag> boolean requireObject(Class<T> type) {
        return this.requireObject(null, type);
    }

    public boolean requireBoolean(String error) {
        if (this.hasValue() && this.getValue().isBoolean()) {
            return true;
        }
        this.echoError(error);
        return false;
    }

    public boolean requireDouble(String error) {
        if (this.hasValue() && this.getValue().isDouble()) {
            return true;
        }
        this.echoError(error);
        return false;
    }

    public boolean requireEnum(String error, Class<? extends Enum> clazz) {
        if (!this.hasValue()) {
            return false;
        }
        ElementTag value = this.getValue();
        if (value.matchesEnum(clazz)) {
            return true;
        }
        if (error == null) {
            this.echoError("Invalid " + DebugInternals.getClassNameOpti(clazz) + ". Must specify a valid name.");
        } else {
            this.echoError(error);
        }
        return false;
    }

    public boolean requireFloat(String error) {
        if (this.hasValue() && this.getValue().isFloat()) {
            return true;
        }
        this.echoError(error);
        return false;
    }

    public boolean requireInteger(String error) {
        if (this.hasValue() && this.getValue().isInt()) {
            return true;
        }
        this.echoError(error);
        return false;
    }

    public <T extends ObjectTag> boolean requireObject(String error, Class<T> type) {
        if (this.hasValue() && this.value.canBeType(type)) {
            return true;
        }
        if (error == null) {
            this.echoError("Invalid " + DebugInternals.getClassNameOpti(type) + " specified.");
        } else {
            this.echoError(error);
        }
        return false;
    }

    public boolean shouldDebug() {
        return this.context == null || this.context.debug;
    }

    public void echoError(String error) {
        if (this.context == CoreUtilities.noDebugContext) {
            return;
        }
        Debug.echoError(this.context, this.forMechanismText(), error);
    }

    public void reportInvalid() {
        this.echoError("Invalid mechanism specified: " + this.raw_mechanism);
    }

    public void autoReport() {
        if (!this.fulfilled()) {
            this.reportInvalid();
        }
    }

    @FunctionalInterface
    public static interface ObjectInputMechRunnerInterface<T extends ObjectTag, P extends ObjectTag> {
        public void run(T var1, Mechanism var2, P var3);
    }

    @FunctionalInterface
    public static interface GenericMechRunnerInterface<T extends ObjectTag> {
        public void run(T var1, Mechanism var2);
    }
}

