/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.trait.ClickRedirectTrait;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SittingTrait
extends Trait
implements Listener {
    @Persist(value="sitting")
    private boolean sitting = false;
    @Persist(value="chair location")
    private Location chairLocation = null;
    private boolean hasSpawned = false;
    public static String SIT_STAND_NAME = String.valueOf(ChatColor.BLACK) + "Deniz" + String.valueOf(ChatColor.DARK_GRAY) + "NPCSit";
    public NPC sitStandNPC = null;

    public void run() {
        double zoff;
        if (!this.npc.isSpawned() || this.chairLocation == null || !this.hasSpawned) {
            return;
        }
        Location curLoc = this.npc.getEntity().getLocation();
        if (curLoc.getWorld() != this.chairLocation.getWorld()) {
            this.stand();
            Messaging.debug((Object[])new Object[]{"(Denizen/SittingTrait) NPC", this.npc.getId(), "stood up because it change world."});
            return;
        }
        double xoff = this.chairLocation.getX() - curLoc.getX();
        double dist = xoff * xoff + (zoff = this.chairLocation.getZ() - curLoc.getZ()) * zoff;
        if (dist > 4.0) {
            this.stand();
            Messaging.debug((Object[])new Object[]{"(Denizen/SittingTrait) NPC", this.npc.getId(), "stood up because it moved away:", xoff, "on X and", zoff, "on Z"});
            return;
        }
    }

    public void onSpawn() {
        if (!this.sitting) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.instance, () -> {
                if (!this.sitting && this.npc != null) {
                    this.npc.removeTrait(SittingTrait.class);
                }
            }, 1L);
            return;
        }
        this.hasSpawned = true;
        if (this.chairLocation == null) {
            this.sit();
        } else {
            this.chairLocation = this.chairLocation.clone();
            this.chairLocation.setYaw(this.npc.getStoredLocation().getYaw());
            this.chairLocation.setPitch(this.npc.getStoredLocation().getPitch());
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> this.sit(this.chairLocation), 1L);
        }
    }

    public void onDespawn() {
        this.hasSpawned = false;
        if (this.npc == null || this.npc.getEntity() == null) {
            return;
        }
        Entity vehicle = this.npc.getEntity().getVehicle();
        if (vehicle != null) {
            vehicle.eject();
            NPC vehicleNPC = CitizensAPI.getNPCRegistry().getNPC(vehicle);
            if (vehicleNPC != null && ((Boolean)vehicleNPC.data().get("is-denizen-seat", (Object)false)).booleanValue()) {
                vehicleNPC.destroy();
            }
        }
    }

    public void sit() {
        if (!this.npc.isSpawned()) {
            return;
        }
        new NPCTag(this.npc).action("sit", null);
        this.sit(this.npc.getStoredLocation());
    }

    private void standInternal() {
        this.sitting = false;
        this.safetyCleanup(this.chairLocation.clone());
        if (!this.npc.isSpawned()) {
            return;
        }
        this.forceUnsit(this.npc.getEntity());
        if (this.chairLocation == null) {
            return;
        }
        this.npc.teleport(this.chairLocation.clone().add(0.0, 0.3, 0.0), PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public void sitInternal(Location location) {
        this.sitting = true;
        this.safetyCleanup(location.clone());
        if (!this.npc.isSpawned()) {
            return;
        }
        new NPCTag(this.npc).action("sit", null);
        this.npc.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
        this.forceEntitySit(this.npc.getEntity(), location.clone(), 0);
    }

    public void safetyCleanup(Location loc) {
        if (loc.getWorld() == null) {
            return;
        }
        for (Entity entity : loc.getWorld().getNearbyEntities(loc, 3.0, 3.0, 3.0)) {
            ArmorStand stand;
            if (entity.getType() != EntityType.ARMOR_STAND || entity.getCustomName() == null || !entity.getCustomName().equals(SIT_STAND_NAME) || !entity.getPassengers().isEmpty() || !(stand = (ArmorStand)entity).isMarker() || !stand.isSmall() || stand.isVisible() || !stand.getPassengers().isEmpty()) continue;
            NPC npc = CitizensAPI.getNPCRegistry().getNPC((Entity)stand);
            if (npc != null) {
                npc.destroy();
                continue;
            }
            stand.remove();
        }
    }

    public void sit(Location location) {
        this.sitInternal(location.clone());
        this.chairLocation = location.clone();
    }

    public void stand() {
        new NPCTag(this.npc).action("stand", null);
        this.standInternal();
        this.standInternal();
        this.chairLocation = null;
    }

    public boolean isSitting() {
        return this.sitting;
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.chairLocation == null) {
            return;
        }
        if (event.getBlock().getLocation().equals((Object)this.chairLocation)) {
            event.setCancelled(true);
        }
    }

    public SittingTrait() {
        super("sitting");
    }

    public void forceUnsit(Entity entity) {
        entity.removeMetadata("denizen.sitting", (Plugin)Denizen.getInstance());
        if (entity.isInsideVehicle()) {
            entity.leaveVehicle();
        }
        if (this.sitStandNPC != null) {
            this.sitStandNPC.destroy();
            this.sitStandNPC = null;
        }
    }

    public void forceEntitySit(final Entity entity, Location location, int retryCount) {
        NPC holder;
        if (this.sitStandNPC != null) {
            this.sitStandNPC.destroy();
        }
        entity.setMetadata("denizen.sitting", (MetadataValue)new FixedMetadataValue((Plugin)Denizen.getInstance(), (Object)true));
        NPCRegistry registry = CitizensAPI.getNamedNPCRegistry((String)"DenizenSitRegistry");
        if (registry == null) {
            registry = CitizensAPI.createNamedNPCRegistry((String)"DenizenSitRegistry", (NPCDataStore)new MemoryNPCDataStore());
        }
        final NPC npc = CitizensAPI.getNPCRegistry().getNPC(entity);
        this.sitStandNPC = holder = registry.createNPC(EntityType.ARMOR_STAND, SIT_STAND_NAME);
        if (npc != null) {
            holder.addTrait((Trait)new ClickRedirectTrait(npc));
            Messaging.debug((Object[])new Object[]{"(Denizen/SittingTrait) Spawning chair for", npc.getId(), "as id", holder.getId()});
        }
        ArmorStandTrait trait = (ArmorStandTrait)holder.getOrAddTrait(ArmorStandTrait.class);
        trait.setGravity(false);
        trait.setHasArms(false);
        trait.setHasBaseplate(false);
        trait.setSmall(true);
        trait.setMarker(true);
        trait.setVisible(false);
        holder.data().set(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)false);
        holder.data().set(NPC.Metadata.DEFAULT_PROTECTED, (Object)true);
        boolean spawned = holder.spawn(location);
        if (!spawned || !holder.isSpawned()) {
            if (retryCount >= 4) {
                Debug.echoError("NPC " + String.valueOf(npc == null ? "null" : Integer.valueOf(npc.getId())) + " sit failed (" + spawned + "," + holder.isSpawned() + "): cannot spawn chair id " + holder.getId() + " at " + new LocationTag(location).identifySimple() + " ChunkIsLoaded=" + new ChunkTag(location).isLoaded());
                holder.destroy();
                this.sitStandNPC = null;
            } else {
                Messaging.debug((Object[])new Object[]{"(Denizen/SittingTrait) retrying failed sit for", npc.getId()});
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Denizen.getInstance(), () -> {
                    if (npc.isSpawned()) {
                        this.forceEntitySit(entity, location, retryCount + 1);
                    }
                }, 5L);
            }
            return;
        }
        holder.data().set("is-denizen-seat", (Object)true);
        new BukkitRunnable(){

            public void cancel() {
                super.cancel();
                if (entity.isValid() && entity.hasMetadata("denizen.sitting")) {
                    entity.removeMetadata("denizen.sitting", (Plugin)Denizen.getInstance());
                }
                if (holder.getTraits().iterator().hasNext()) {
                    holder.destroy();
                }
                if (SittingTrait.this.sitStandNPC == holder) {
                    SittingTrait.this.sitStandNPC = null;
                }
            }

            public void run() {
                if (holder != SittingTrait.this.sitStandNPC) {
                    this.cancel();
                } else if (!holder.getTraits().iterator().hasNext()) {
                    this.cancel();
                } else if (!(entity.isValid() && entity.hasMetadata("denizen.sitting") && ((MetadataValue)entity.getMetadata("denizen.sitting").get(0)).asBoolean())) {
                    this.cancel();
                } else if (npc != null && !npc.isSpawned()) {
                    this.cancel();
                } else if (!holder.isSpawned()) {
                    this.cancel();
                } else if (!NMS.getPassengers((Entity)holder.getEntity()).contains(entity)) {
                    holder.getEntity().addPassenger(entity);
                }
            }
        }.runTaskTimer((Plugin)Denizen.getInstance(), 0L, 1L);
    }
}

