/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.utilities.maps;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.maps.MapImage;
import com.denizenscript.denizen.utilities.maps.MapObject;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapView;
import org.bukkit.map.MinecraftFont;

public class MapText
extends MapObject {
    protected String textTag;
    protected String colorTag;
    protected String fontTag;
    protected String sizeTag;
    protected String styleTag;
    protected Map<UUID, String> playerTexts = new HashMap<UUID, String>();

    public MapText(String xTag, String yTag, String visibilityTag, boolean debug, String textTag, String colorTag, String fontTag, String sizeTag, String styleTag) {
        super(xTag, yTag, visibilityTag, debug);
        this.textTag = textTag;
        this.colorTag = colorTag;
        this.fontTag = fontTag;
        this.sizeTag = sizeTag;
        this.styleTag = styleTag;
    }

    @Override
    public void update(PlayerTag player, UUID uuid) {
        super.update(player, uuid);
        this.playerTexts.put(uuid, this.tag(this.textTag, player));
    }

    public String getText(PlayerTag player) {
        return this.playerTexts.get(player.getPlayerEntity().getUniqueId());
    }

    public void setText(String textTag) {
        this.textTag = textTag;
    }

    @Override
    public Map<String, Object> getSaveData() {
        Map<String, Object> data = super.getSaveData();
        data.put("type", "TEXT");
        data.put("text", this.textTag);
        data.put("color", this.colorTag);
        data.put("font", this.fontTag);
        data.put("size", this.sizeTag);
        data.put("style", this.styleTag);
        return data;
    }

    @Override
    public void render(MapView mapView, MapCanvas mapCanvas, PlayerTag player, UUID uuid) {
        try {
            if (!this.playerTexts.containsKey(uuid)) {
                this.playerTexts.put(uuid, this.tag(this.textTag, player));
            }
            ColorTag color = ColorTag.valueOf(this.colorTag == null ? "black" : this.tag(this.colorTag, player), this.getTagContext(player));
            if (this.fontTag == null) {
                byte b = MapImage.matchColor(color.getAWTColor());
                String text = "\u00a7" + Byte.toString(b) + ";" + this.getText(player);
                mapCanvas.drawText(this.getX(player), this.getY(player), (MapFont)MinecraftFont.Font, text);
                return;
            }
            int style = 0;
            if (this.styleTag != null) {
                TagContext context = this.getTagContext(player);
                ListTag styles = TagManager.tagObject(this.styleTag, context).asType(ListTag.class, context);
                for (String styleStr : styles) {
                    String styleLower;
                    switch (styleLower = CoreUtilities.toLowerCase(styleStr)) {
                        case "bold": {
                            style |= 1;
                            break;
                        }
                        case "italic": {
                            style |= 2;
                        }
                    }
                }
            }
            int size = this.sizeTag != null ? TagManager.tagObject(this.sizeTag, this.getTagContext(player)).asElement().asInt() : 10;
            BufferedImage image = new BufferedImage(128, 128, 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setFont(new Font(this.tag(this.fontTag, player), style, size));
            graphics.setColor(color.getAWTColor());
            FontMetrics metrics = graphics.getFontMetrics();
            int y = this.getY(player) + metrics.getAscent() - metrics.getDescent() - metrics.getLeading();
            graphics.drawString(this.getText(player), this.getX(player), y);
            graphics.dispose();
            mapCanvas.drawImage(0, 0, (Image)image);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }
}

