/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.core.WebserverWebRequestScriptEvent;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;

public class WebServerCommand
extends AbstractCommand {
    public static HashMap<Integer, WebserverInstance> webservers = new HashMap();

    public WebServerCommand() {
        this.setName("webserver");
        this.setSyntax("webserver [start/stop] (port:<#>) (ignore_errors)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgPrefixed @ArgName(value="port") @ArgDefaultText(value="8080") int portNum, @ArgName(value="mode") Mode mode, @ArgName(value="ignore_errors") boolean ignoreErrors) {
        if (!CoreConfiguration.allowWebserver) {
            Debug.echoError("WebServer command disabled in config.yml!");
            return;
        }
        switch (mode.ordinal()) {
            case 0: {
                WebserverInstance instance = webservers.get(portNum);
                if (instance != null) {
                    Debug.echoError("Server already running at port " + portNum + ", cannot start a new one.");
                    return;
                }
                instance = new WebserverInstance();
                instance.port = portNum;
                instance.ignoreErrors = ignoreErrors;
                try {
                    instance.start();
                    webservers.put(portNum, instance);
                    Debug.echoDebug((Debuggable)scriptEntry, "Webserver at port " + portNum + " started.");
                }
                catch (IOException ex) {
                    Debug.echoError("Could not start webserver due to IOException. Is the port correct?");
                    Debug.echoError(ex);
                }
                break;
            }
            case 1: {
                WebserverInstance instance = webservers.remove(portNum);
                if (instance == null) {
                    Debug.echoDebug((Debuggable)scriptEntry, "No server running at port " + portNum + ", ignoring 'stop' instruction.");
                    return;
                }
                instance.stop();
                Debug.echoDebug((Debuggable)scriptEntry, "Webserver at port " + portNum + " stopped.");
                break;
            }
        }
    }

    public static enum Mode {
        START,
        STOP;

    }

    public static class WebserverInstance {
        public int port;
        public HttpServer server;
        public boolean ignoreErrors;

        public void handleRequest(HttpExchange exchange) {
            DenizenCore.runOnMainThread(() -> WebserverWebRequestScriptEvent.fire(this, exchange));
        }

        public void executor(Runnable command) {
            DenizenCore.runAsync(command);
        }

        public void start() throws IOException {
            this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
            this.server.createContext("/", this::handleRequest);
            this.server.setExecutor(this::executor);
            this.server.start();
        }

        public void stop() {
            this.server.stop(0);
        }
    }
}

