/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_21.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemComponentsPatch;
import com.denizenscript.denizen.objects.properties.item.ItemRawNBT;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.FurnaceRecipe;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeBlasting;
import net.minecraft.world.item.crafting.RecipeCampfire;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSmoking;
import net.minecraft.world.item.crafting.RecipeStonecutting;
import net.minecraft.world.item.crafting.ShapelessRecipes;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R2.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.map.MapView;

public class ItemHelperImpl
extends ItemHelper {
    public static final Field Item_components = ReflectionHelper.getFields(Item.class).get(ReflectionMappingsInfo.Item_components, DataComponentMap.class);
    public static final int DATA_VERSION_1_20_4 = 3700;
    public static final NBTTagCompound EMPTY_TAG = new NBTTagCompound();
    public static final Field AdventureModePredicate_predicates = ReflectionHelper.getFields(AdventureModePredicate.class).get(ReflectionMappingsInfo.AdventureModePredicate_predicates);
    public static Class<?> PaperPotionMix_CLASS = null;
    public static Map<NamespacedKey, ItemHelper.BrewingRecipe> customBrewingRecipes = null;

    public static RecipeHolder<?> getNMSRecipe(NamespacedKey key) {
        ResourceKey nmsKey = ResourceKey.a((ResourceKey)Registries.bk, (MinecraftKey)CraftNamespacedKey.toMinecraft((NamespacedKey)key));
        return ((CraftServer)Bukkit.getServer()).getServer().aI().b(nmsKey).orElse(null);
    }

    @Override
    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, "maxStack").invoke(material, size);
            Item nmsItem = (Item)BuiltInRegistries.g.a(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey()));
            DataComponentMap currentComponents = nmsItem.g();
            Item_components.set(nmsItem, DataComponentMap.a((DataComponentMap)currentComponents, (DataComponentMap)DataComponentMap.a().a(DataComponents.c, (Object)size).a()));
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    @Override
    public Integer burnTime(Material material) {
        return MinecraftServer.getServer().bo().b(new net.minecraft.world.item.ItemStack((IMaterial)CraftMagicNumbers.getItem((Material)material)));
    }

    @Override
    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c2, ItemStack[] item, boolean exact) {
        if (item.length == 1 && item[0].getType() == Material.AIR) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.AIR));
        } else if (exact) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static RecipeItemStack itemArrayToRecipe(ItemStack[] items, boolean exact) {
        if (!exact) {
            return RecipeItemStack.a(Arrays.stream(items).map(item -> CraftMagicNumbers.getItem((Material)item.getType())));
        }
        return RecipeItemStack.ofStacks(Arrays.stream(items).map(CraftItemStack::asNMSCopy).toList());
    }

    public static ResourceKey<IRecipe<?>> createRecipeKey(String name) {
        return ResourceKey.a((ResourceKey)Registries.bk, (MinecraftKey)MinecraftKey.a((String)"denizen", (String)name));
    }

    @Override
    public void registerFurnaceRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, float exp, int time, String type, boolean exact, String category) {
        CookingBookCategory categoryValue;
        ResourceKey<IRecipe<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        RecipeItemStack itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        CookingBookCategory cookingBookCategory = categoryValue = category == null ? CookingBookCategory.c : CookingBookCategory.valueOf((String)CoreUtilities.toUpperCase(category));
        Object recipe = type.equalsIgnoreCase("smoker") ? new RecipeSmoking(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new RecipeBlasting(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new RecipeCampfire(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : new FurnaceRecipe(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time)));
        RecipeHolder holder = new RecipeHolder(key, (IRecipe)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aI().addRecipe(holder);
    }

    @Override
    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, boolean exact) {
        ResourceKey<IRecipe<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        RecipeItemStack itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        RecipeStonecutting recipe = new RecipeStonecutting(group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        RecipeHolder holder = new RecipeHolder(key, (IRecipe)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aI().addRecipe(holder);
    }

    @Override
    public void registerSmithingRecipe(String keyName, ItemStack result, ItemStack[] baseItem, boolean baseExact, ItemStack[] upgradeItem, boolean upgradeExact, ItemStack[] templateItem, boolean templateExact) {
        ResourceKey<IRecipe<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        RecipeItemStack templateItemRecipe = ItemHelperImpl.itemArrayToRecipe(templateItem, templateExact);
        RecipeItemStack baseItemRecipe = ItemHelperImpl.itemArrayToRecipe(baseItem, baseExact);
        RecipeItemStack upgradeItemRecipe = ItemHelperImpl.itemArrayToRecipe(upgradeItem, upgradeExact);
        SmithingTransformRecipe recipe = new SmithingTransformRecipe(Optional.of(templateItemRecipe), Optional.of(baseItemRecipe), Optional.of(upgradeItemRecipe), CraftItemStack.asNMSCopy((ItemStack)result));
        RecipeHolder holder = new RecipeHolder(key, (IRecipe)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aI().addRecipe(holder);
    }

    @Override
    public void registerShapelessRecipe(String keyName, String group, ItemStack result, List<ItemStack[]> ingredients, boolean[] exact, String category) {
        ResourceKey<IRecipe<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        ArrayList<RecipeItemStack> ingredientList = new ArrayList<RecipeItemStack>();
        CraftingBookCategory categoryValue = category == null ? CraftingBookCategory.d : CraftingBookCategory.valueOf((String)CoreUtilities.toUpperCase(category));
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        ShapelessRecipes recipe = new ShapelessRecipes(group, categoryValue, CraftItemStack.asNMSCopy((ItemStack)result), (List)NonNullList.a(null, (Object[])ingredientList.toArray(new RecipeItemStack[0])));
        RecipeHolder holder = new RecipeHolder(key, (IRecipe)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aI().addRecipe(holder);
    }

    @Override
    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).J().a().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    @Override
    public String getRawHoverText(ItemStack itemStack) {
        NBTBase tag = CraftItemStack.asNMSCopy((ItemStack)itemStack).b((HolderLookup.a)CraftRegistry.getMinecraftRegistry());
        if (tag == null) {
            return null;
        }
        return tag.toString();
    }

    @Override
    public PlayerProfile getSkullSkin(ItemStack is) {
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        ResolvableProfile profile = (ResolvableProfile)itemStack.a(DataComponents.ag);
        if (profile != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.e().get((Object)"textures"), null);
            return new PlayerProfile(profile.c().orElse(null), profile.d().orElse(null), property != null ? property.value() : null, property != null ? property.signature() : null);
        }
        return null;
    }

    @Override
    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.b(DataComponents.ag, (Object)new ResolvableProfile(gameProfile));
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public ItemStack addNbtData(ItemStack itemStack, String key, Tag value) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.a(DataComponents.b, (Object)CustomData.a, customData -> {
            CompoundTag updatedTag = CompoundTagImpl.fromNMSTag(customData.d()).createBuilder().put(key, value).build();
            return CustomData.a((NBTTagCompound)((CompoundTagImpl)updatedTag).toNMSTag());
        });
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public CompoundTag getNbtData(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && !nmsItemStack.f()) {
            return CompoundTagImpl.fromNMSTag((NBTTagCompound)nmsItemStack.a((HolderLookup.a)CraftRegistry.getMinecraftRegistry()));
        }
        return new CompoundTagImpl(new HashMap<String, Tag>());
    }

    @Override
    public ItemStack setNbtData(ItemStack itemStack, CompoundTag compoundTag) {
        net.minecraft.world.item.ItemStack nmsItemStack = net.minecraft.world.item.ItemStack.a((HolderLookup.a)CraftRegistry.getMinecraftRegistry(), (NBTTagCompound)((CompoundTagImpl)compoundTag).toNMSTag());
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public CompoundTag getCustomData(ItemStack item) {
        CustomData customData = (CustomData)CraftItemStack.asNMSCopy((ItemStack)item).a(DataComponents.b);
        return customData != null ? CompoundTagImpl.fromNMSTag(customData.d()) : null;
    }

    @Override
    public ItemStack setCustomData(ItemStack item, CompoundTag data) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (data == null) {
            nmsItemStack.c(DataComponents.b);
        } else {
            nmsItemStack.b(DataComponents.b, (Object)CustomData.a((NBTTagCompound)((CompoundTagImpl)data).toNMSTag()));
        }
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public ItemStack setPartialOldNbt(ItemStack item, CompoundTag oldTag) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        NBTTagCompound nmsOldTag = new NBTTagCompound();
        nmsOldTag.a("id", item.getType().getKey().toString());
        nmsOldTag.a("Count", (byte)item.getAmount());
        nmsOldTag.a("tag", (NBTBase)((CompoundTagImpl)oldTag).toNMSTag());
        NBTTagCompound nmsUpdatedTag = (NBTTagCompound)MinecraftServer.getServer().L.update(DataConverterTypes.t, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nmsOldTag), 3700, currentDataVersion).getValue();
        NBTTagCompound nmsCurrentTag = (NBTTagCompound)CraftItemStack.asNMSCopy((ItemStack)item).a((HolderLookup.a)CraftRegistry.getMinecraftRegistry());
        NBTTagCompound nmsMergedTag = nmsCurrentTag.a(nmsUpdatedTag);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.a((HolderLookup.a)CraftRegistry.getMinecraftRegistry(), (NBTBase)nmsMergedTag).orElseThrow()));
    }

    @Override
    public CompoundTag getEntityData(ItemStack item) {
        CustomData entityData = (CustomData)CraftItemStack.asNMSCopy((ItemStack)item).a(DataComponents.W);
        return entityData != null ? CompoundTagImpl.fromNMSTag(entityData.d()) : null;
    }

    @Override
    public ItemStack setEntityData(ItemStack item, CompoundTag entityNbt, EntityType entityType) {
        NBTTagCompound nmsEntityNbt = EMPTY_TAG;
        if (!(entityNbt == null || entityNbt.isEmpty() || entityNbt.containsKey("id") && entityNbt.size() <= 1)) {
            nmsEntityNbt = ((CompoundTagImpl)entityNbt).toNMSTag();
            nmsEntityNbt.a("id", entityType.getKey().toString());
        }
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        CustomData.a((DataComponentType)DataComponents.W, (net.minecraft.world.item.ItemStack)nmsItemStack, (NBTTagCompound)nmsEntityNbt);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public MapTag getRawComponentsPatch(ItemStack item, boolean excludeHandled) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        DataComponentPatch patch = nmsItemStack.e();
        if (excludeHandled) {
            patch = patch.a(componentType -> {
                MinecraftKey componentId = BuiltInRegistries.ao.b(componentType);
                return ItemComponentsPatch.propertyHandledComponents.contains(componentId.toString());
            });
        }
        if (patch.d()) {
            return new MapTag();
        }
        RegistryOps registryOps = CraftRegistry.getMinecraftRegistry().a((DynamicOps)DynamicOpsNBT.a);
        NBTTagCompound nmsPatch = (NBTTagCompound)DataComponentPatch.b.encodeStart((DynamicOps)registryOps, (Object)patch).getOrThrow();
        MapTag rawComponents = (MapTag)ItemRawNBT.jnbtTagToObject(CompoundTagImpl.fromNMSTag(nmsPatch));
        rawComponents.putObject("denizen:__data_version", (ObjectTag)new ElementTag(CraftMagicNumbers.INSTANCE.getDataVersion()));
        return rawComponents;
    }

    @Override
    public ItemStack setRawComponentsPatch(ItemStack item, MapTag rawComponentsMap, int dataVersion, Consumer<String> errorHandler) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        Tag rawComponents = ItemRawNBT.convertObjectToNbt(rawComponentsMap.identify(), CoreUtilities.errorButNoDebugContext, "");
        NBTTagCompound nmsRawComponents = ((CompoundTagImpl)rawComponents).toNMSTag();
        RegistryOps registryOps = CraftRegistry.getMinecraftRegistry().a((DynamicOps)DynamicOpsNBT.a);
        if (dataVersion < currentDataVersion) {
            NBTTagCompound legacyItemData = new NBTTagCompound();
            legacyItemData.a("id", item.getType().getKey().toString());
            legacyItemData.a("count", item.getAmount());
            legacyItemData.a("components", (NBTBase)nmsRawComponents);
            NBTTagCompound nmsUpdatedTag = (NBTTagCompound)MinecraftServer.getServer().L.update(DataConverterTypes.t, new Dynamic((DynamicOps)registryOps, (Object)legacyItemData), dataVersion, currentDataVersion).getValue();
            nmsRawComponents = nmsUpdatedTag.p("components");
        }
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        DataComponentPatch.b.parse((DynamicOps)registryOps, (Object)nmsRawComponents).ifError(error -> errorHandler.accept(error.message())).ifSuccess(arg_0 -> ((net.minecraft.world.item.ItemStack)nmsItemStack).b(arg_0));
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public List<Material> getCanPlaceOn(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (DataComponentType<AdventureModePredicate>)DataComponents.m);
    }

    @Override
    public ItemStack setCanPlaceOn(ItemStack item, List<Material> canPlaceOn) {
        return this.setAdventureModePredicateMaterials(item, (DataComponentType<AdventureModePredicate>)DataComponents.m, canPlaceOn);
    }

    @Override
    public List<Material> getCanBreak(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (DataComponentType<AdventureModePredicate>)DataComponents.n);
    }

    @Override
    public ItemStack setCanBreak(ItemStack item, List<Material> canBreak) {
        return this.setAdventureModePredicateMaterials(item, (DataComponentType<AdventureModePredicate>)DataComponents.n, canBreak);
    }

    private List<Material> getAdventureModePredicateMaterials(ItemStack item, DataComponentType<AdventureModePredicate> nmsComponent) {
        List nmsPredicates;
        AdventureModePredicate nmsAdventurePredicate = (AdventureModePredicate)CraftItemStack.asNMSCopy((ItemStack)item).a(nmsComponent);
        if (nmsAdventurePredicate == null) {
            return null;
        }
        try {
            nmsPredicates = (List)AdventureModePredicate_predicates.get(nmsAdventurePredicate);
        }
        catch (Throwable e2) {
            Debug.echoError(e2);
            return null;
        }
        ArrayList<Material> materials = new ArrayList<Material>();
        for (CriterionConditionBlock nmsPredicate : nmsPredicates) {
            nmsPredicate.b().ifPresent(nmsHolderSet -> {
                for (Holder nmsHolder : nmsHolderSet) {
                    materials.add(CraftMagicNumbers.getMaterial((Block)((Block)nmsHolder.a())));
                }
            });
        }
        return materials;
    }

    private ItemStack setAdventureModePredicateMaterials(ItemStack item, DataComponentType<AdventureModePredicate> nmsComponent, List<Material> materials) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        AdventureModePredicate nmsAdventurePredicate = (AdventureModePredicate)nmsItemStack.a(nmsComponent);
        if (materials == null) {
            if (nmsAdventurePredicate == null) {
                return item;
            }
            nmsItemStack.c(nmsComponent);
            return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
        }
        CriterionConditionBlock nmsPredicate = new CriterionConditionBlock(Optional.of(HolderSet.a(material -> (Holder)BuiltInRegistries.e.c(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElseThrow(), materials)), Optional.empty(), Optional.empty());
        nmsItemStack.b(nmsComponent, (Object)new AdventureModePredicate(List.of(nmsPredicate), nmsAdventurePredicate == null || nmsAdventurePredicate.a()));
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    @Override
    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().k == null) {
            ((CraftInventoryPlayer)inventory).getInventory().a(slot, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }

    @Override
    public IntArrayTag convertUuidToNbt(UUID id) {
        return new IntArrayTag(GameProfileSerializer.a((UUID)id).g());
    }

    @Override
    public UUID convertNbtToUuid(IntArrayTag id) {
        return GameProfileSerializer.a((NBTBase)new NBTTagIntArray(id.getValue()));
    }

    @Override
    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        IChatBaseComponent nmsDisplayName = (IChatBaseComponent)nmsItemStack.a(DataComponents.g);
        return FormattedTextHelper.stringify(Handler.componentToSpigot(nmsDisplayName));
    }

    @Override
    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        ItemLore nmsLore = (ItemLore)nmsItemStack.a(DataComponents.j);
        ArrayList<String> outList = new ArrayList<String>(nmsLore.a().size());
        for (IChatBaseComponent nmsLoreLine : nmsLore.a()) {
            outList.add(FormattedTextHelper.stringify(Handler.componentToSpigot(nmsLoreLine)));
        }
        return outList;
    }

    @Override
    public void setDisplayName(ItemTag item, String name) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (name == null || name.isEmpty()) {
            nmsItemStack.c(DataComponents.g);
        } else {
            nmsItemStack.b(DataComponents.g, (Object)Handler.componentToNMS(FormattedTextHelper.parse(name, ChatColor.WHITE)));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack));
    }

    @Override
    public void setLore(ItemTag item, List<String> lore) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (lore == null || lore.isEmpty()) {
            nmsItemStack.c(DataComponents.j);
        } else {
            ArrayList<IChatBaseComponent> nmsLore = new ArrayList<IChatBaseComponent>(lore.size());
            for (String loreLine : lore) {
                nmsLore.add(Handler.componentToNMS(FormattedTextHelper.parse(loreLine, ChatColor.WHITE)));
            }
            nmsItemStack.b(DataComponents.j, (Object)new ItemLore(nmsLore));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack));
    }

    public static IBlockData getCorrectStateForFluidBlock(World world, IBlockData blockState, BlockPosition blockPos) {
        Fluid fluid = blockState.y();
        return !fluid.c() && !blockState.c((IBlockAccess)world, blockPos, EnumDirection.b) ? fluid.g() : blockState;
    }

    public static void renderFullMap(WorldMap worldmap, int xMin, int zMin, int xMax, int zMax) {
        WorldServer world = ((CraftWorld)worldmap.mapView.getWorld()).getHandle();
        int scale = 1 << worldmap.f;
        int mapX = worldmap.c;
        int mapZ = worldmap.d;
        for (int x = xMin; x < xMax; ++x) {
            double d0 = 0.0;
            for (int z = zMin; z < zMax; ++z) {
                MaterialMapColor materialmapcolor;
                int k2 = (mapX / scale + x - 64) * scale;
                int l2 = (mapZ / scale + z - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                Chunk chunk = world.m(new BlockPosition(k2, 0, l2));
                if (chunk.E()) continue;
                ChunkCoordIntPair chunkcoordintpair = chunk.f();
                int i3 = k2 & 0xF;
                int j3 = l2 & 0xF;
                int k3 = 0;
                double d1 = 0.0;
                if (world.G_().h()) {
                    int l3 = k2 + l2 * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)Blocks.j.m().a((IBlockAccess)world, BlockPosition.c), 10);
                    } else {
                        multiset.add((Object)Blocks.b.m().a((IBlockAccess)world, BlockPosition.c), 100);
                    }
                    d1 = 100.0;
                } else {
                    BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
                    BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition();
                    for (int i4 = 0; i4 < scale; ++i4) {
                        for (int j4 = 0; j4 < scale; ++j4) {
                            IBlockData iblockdata;
                            int k4 = chunk.a(HeightMap.Type.b, i4 + i3, j4 + j3) + 1;
                            if (k4 <= world.L_() + 1) {
                                iblockdata = Blocks.I.m();
                            } else {
                                do {
                                    blockposition_mutableblockposition.d(chunkcoordintpair.d() + i4 + i3, --k4, chunkcoordintpair.e() + j4 + j3);
                                } while ((iblockdata = chunk.a_((BlockPosition)blockposition_mutableblockposition)).a((IBlockAccess)world, (BlockPosition)blockposition_mutableblockposition) == MaterialMapColor.a && k4 > world.L_());
                                if (k4 > world.L_() && !iblockdata.y().c()) {
                                    IBlockData iblockdata1;
                                    int l4 = k4 - 1;
                                    blockposition_mutableblockposition1.g((BaseBlockPosition)blockposition_mutableblockposition);
                                    do {
                                        blockposition_mutableblockposition1.q(l4--);
                                        iblockdata1 = chunk.a_((BlockPosition)blockposition_mutableblockposition1);
                                        ++k3;
                                    } while (l4 > world.L_() && !iblockdata1.y().c());
                                    iblockdata = ItemHelperImpl.getCorrectStateForFluidBlock((World)world, iblockdata, (BlockPosition)blockposition_mutableblockposition);
                                }
                            }
                            worldmap.a((IBlockAccess)world, chunkcoordintpair.d() + i4 + i3, chunkcoordintpair.e() + j4 + j3);
                            d1 += (double)k4 / (double)(scale * scale);
                            multiset.add((Object)iblockdata.a((IBlockAccess)world, (BlockPosition)blockposition_mutableblockposition));
                        }
                    }
                }
                k3 /= scale * scale;
                double d2 = (d1 - d0) * 4.0 / (double)(scale + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int b0 = 1;
                if (d2 > 0.6) {
                    b0 = 2;
                }
                if (d2 < -0.6) {
                    b0 = 0;
                }
                if ((materialmapcolor = (MaterialMapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MaterialMapColor.a)) == MaterialMapColor.m) {
                    d2 = (double)k3 * 0.1 + (double)(x + z & 1) * 0.2;
                    b0 = 1;
                    if (d2 < 0.5) {
                        b0 = 2;
                    }
                    if (d2 > 0.9) {
                        b0 = 0;
                    }
                }
                d0 = d1;
                worldmap.a(x, z, (byte)(materialmapcolor.al * 4 + b0));
            }
        }
    }

    @Override
    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        WorldMap worldmap = ((CraftServer)Bukkit.getServer()).getServer().a(World.i).a(new MapId(mapId));
        if (worldmap == null) {
            return false;
        }
        ItemHelperImpl.renderFullMap(worldmap, xMin, zMin, xMax, zMax);
        return true;
    }

    @Override
    public BlockData getPlacedBlock(Material material) {
        Item nmsItem = BuiltInRegistries.g.b(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElse(null);
        if (nmsItem instanceof ItemBlock) {
            Block block = ((ItemBlock)nmsItem).d();
            return CraftBlockData.fromData((IBlockData)block.m());
        }
        return null;
    }

    @Override
    public boolean isValidMix(ItemStack input, ItemStack ingredient) {
        net.minecraft.world.item.ItemStack nmsInput = CraftItemStack.asNMSCopy((ItemStack)input);
        net.minecraft.world.item.ItemStack nmsIngredient = CraftItemStack.asNMSCopy((ItemStack)ingredient);
        return MinecraftServer.getServer().bn().a(nmsInput, nmsIngredient);
    }

    @Override
    public Map<NamespacedKey, ItemHelper.BrewingRecipe> getCustomBrewingRecipes() {
        if (customBrewingRecipes == null) {
            customBrewingRecipes = Maps.transformValues((Map)((Map)ReflectionHelper.getFieldValue(PotionBrewer.class, "customMixes", MinecraftServer.getServer().bn())), paperMix -> {
                if (PaperPotionMix_CLASS == null) {
                    PaperPotionMix_CLASS = paperMix.getClass();
                }
                RecipeChoice ingredient = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, "ingredient", paperMix));
                RecipeChoice input = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, "input", paperMix));
                ItemStack result = CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, "result", paperMix)));
                return new ItemHelper.BrewingRecipe(input, ingredient, result);
            });
        }
        return customBrewingRecipes;
    }

    private RecipeChoice convertChoice(Predicate<net.minecraft.world.item.ItemStack> nmsPredicate) {
        if (nmsPredicate instanceof RecipeItemStack) {
            RecipeItemStack ingredient = (RecipeItemStack)nmsPredicate;
            return CraftRecipe.toBukkit((RecipeItemStack)ingredient);
        }
        return PaperAPITools.instance.createPredicateRecipeChoice(item -> nmsPredicate.test(CraftItemStack.asNMSCopy((ItemStack)item)));
    }

    @Override
    public byte[] renderMap(MapView mapView, Player player) {
        return ((CraftMapView)mapView).render((CraftPlayer)((CraftPlayer)player)).buffer;
    }

    @Override
    public int getFoodPoints(Material itemType) {
        return ((FoodInfo)CraftMagicNumbers.getItem((Material)itemType).g().a(DataComponents.w)).a();
    }

    @Override
    public DyeColor getShieldColor(ItemStack item) {
        EnumColor nmsColor = (EnumColor)CraftItemStack.asNMSCopy((ItemStack)item).a(DataComponents.aj);
        return nmsColor != null ? DyeColor.getByWoolData((byte)((byte)nmsColor.a())) : null;
    }

    @Override
    public ItemStack setShieldColor(ItemStack item, DyeColor color) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (color != null) {
            nmsItemStack.b(DataComponents.aj, (Object)EnumColor.a((int)color.getWoolData()));
        } else {
            nmsItemStack.c(DataComponents.aj);
        }
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItemStack);
    }
}

