/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.FishingHelper;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftFishHook;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;

public class FishingHelperImpl
implements FishingHelper {
    public static final Field FISHING_HOOK_NIBBLE = ReflectionHelper.getFields(EntityFishingHook.class).get(ReflectionMappingsInfo.FishingHook_nibble, Integer.TYPE);
    public static final Field FISHING_HOOK_LURE_TIME = ReflectionHelper.getFields(EntityFishingHook.class).get(ReflectionMappingsInfo.FishingHook_timeUntilLured, Integer.TYPE);
    public static final Field FISHING_HOOK_HOOK_TIME = ReflectionHelper.getFields(EntityFishingHook.class).get(ReflectionMappingsInfo.FishingHook_timeUntilHooked, Integer.TYPE);

    public ItemStack getResult(FishHook fishHook, FishingHelper.CatchType catchType) {
        EntityFishingHook nmsHook = ((CraftFishHook)fishHook).getHandle();
        net.minecraft.world.item.ItemStack result = switch (catchType) {
            case FishingHelper.CatchType.DEFAULT -> {
                WorldServer nmsWorld = ((CraftWorld)fishHook.getWorld()).getHandle();
                net.minecraft.world.item.ItemStack nmsFishingRod = nmsHook.m().eZ();
                float f = nmsWorld.A.i();
                float i = EnchantmentManager.b((WorldServer)nmsWorld, (net.minecraft.world.item.ItemStack)nmsFishingRod, (Entity)nmsHook.m());
                int j = EnchantmentManager.a((WorldServer)nmsWorld, (net.minecraft.world.item.ItemStack)nmsFishingRod, (Entity)nmsHook.m());
                float f1 = 0.1f - i * 0.025f - (float)j * 0.01f;
                float f2 = 0.05f + i * 0.01f - (float)j * 0.01f;
                f1 = MathHelper.a((float)f1, (float)0.0f, (float)1.0f);
                f2 = MathHelper.a((float)f2, (float)0.0f, (float)1.0f);
                if (f < f1) {
                    yield this.catchRandomJunk(nmsHook);
                }
                if ((f -= f1) < f2) {
                    yield this.catchRandomTreasure(nmsHook);
                }
                yield this.catchRandomFish(nmsHook);
            }
            case FishingHelper.CatchType.JUNK -> this.catchRandomJunk(nmsHook);
            case FishingHelper.CatchType.TREASURE -> this.catchRandomTreasure(nmsHook);
            case FishingHelper.CatchType.FISH -> this.catchRandomFish(nmsHook);
            default -> null;
        };
        return result != null ? CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)result) : null;
    }

    public net.minecraft.world.item.ItemStack getRandomReward(EntityFishingHook nmsHook, ResourceKey<LootTable> key) {
        WorldServer nmsWorld = (WorldServer)nmsHook.dV();
        LootParams nmsLootParams = new LootParams.a(nmsWorld).a(LootContextParameters.f, (Object)new Vec3D(nmsHook.dA(), nmsHook.dC(), nmsHook.dG())).a(LootContextParameters.i, (Object)new net.minecraft.world.item.ItemStack((IMaterial)Items.rS)).a(LootContextParameterSets.f);
        ObjectArrayList nmsItems = nmsWorld.p().bc().b(key).a(nmsLootParams);
        return (net.minecraft.world.item.ItemStack)nmsItems.get(nmsWorld.A.a(nmsItems.size()));
    }

    public FishHook spawnHook(Location location, Player player) {
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        EntityFishingHook hook = new EntityFishingHook((EntityHuman)((CraftPlayer)player).getHandle(), (World)nmsWorld, 0, 0);
        nmsWorld.addFreshEntity((Entity)hook, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FishHook)hook.getBukkitEntity();
    }

    private net.minecraft.world.item.ItemStack catchRandomJunk(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, (ResourceKey<LootTable>)LootTables.an);
    }

    private net.minecraft.world.item.ItemStack catchRandomTreasure(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, (ResourceKey<LootTable>)LootTables.ao);
    }

    private net.minecraft.world.item.ItemStack catchRandomFish(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, (ResourceKey<LootTable>)LootTables.ap);
    }

    public FishHook getHookFrom(Player player) {
        EntityFishingHook nmsHook = ((CraftPlayer)player).getHandle().cw;
        if (nmsHook == null) {
            return null;
        }
        return (FishHook)nmsHook.getBukkitEntity();
    }

    public void setNibble(FishHook hook, int ticks) {
        EntityFishingHook nmsHook = ((CraftFishHook)hook).getHandle();
        try {
            FISHING_HOOK_NIBBLE.setInt(nmsHook, ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHookTime(FishHook hook, int ticks) {
        EntityFishingHook nmsHook = ((CraftFishHook)hook).getHandle();
        try {
            FISHING_HOOK_HOOK_TIME.setInt(nmsHook, ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public int getLureTime(FishHook hook) {
        EntityFishingHook nmsHook = ((CraftFishHook)hook).getHandle();
        try {
            return FISHING_HOOK_LURE_TIME.getInt(nmsHook);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return -1;
        }
    }

    public void setLureTime(FishHook hook, int ticks) {
        EntityFishingHook nmsHook = ((CraftFishHook)hook).getHandle();
        try {
            FISHING_HOOK_LURE_TIME.setInt(nmsHook, ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }
}

