/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.NMSVersion;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.properties.material.MaterialProperty;
import com.denizenscript.denizencore.exceptions.Unreachable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Hatchable;
import org.bukkit.block.data.type.Sapling;
import org.bukkit.block.data.type.TurtleEgg;

public class MaterialAge
extends MaterialProperty<ElementTag> {
    public static boolean describes(MaterialTag material) {
        BlockData data = material.getModernData();
        return data instanceof Ageable || data instanceof TurtleEgg || data instanceof Sapling || NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && data instanceof Hatchable;
    }

    public MaterialAge(MaterialTag material) {
        super(material);
    }

    @Override
    public ElementTag getPropertyValue() {
        return new ElementTag(this.getCurrent());
    }

    @Override
    public void setPropertyValue(ElementTag val, Mechanism mechanism) {
        if (!mechanism.requireInteger()) {
            return;
        }
        int age = val.asInt();
        if (age < 0 || age > this.getMax()) {
            mechanism.echoError("Age value '" + age + "' is not valid. Must be between 0 and " + this.getMax() + " for material '" + ((MaterialTag)this.object).name() + "'.");
            return;
        }
        BlockData data = this.getBlockData();
        if (data instanceof TurtleEgg) {
            TurtleEgg turtle = (TurtleEgg)data;
            turtle.setHatch(age);
        } else if (data instanceof Sapling) {
            Sapling sapling = (Sapling)data;
            sapling.setStage(age);
        } else if (data instanceof Ageable) {
            Ageable ageable = (Ageable)data;
            ageable.setAge(age);
        } else if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && data instanceof Hatchable) {
            Hatchable hatchable = (Hatchable)data;
            hatchable.setHatch(age);
        }
    }

    @Override
    public String getPropertyId() {
        return "age";
    }

    public static void register() {
        PropertyParser.registerStaticTag(MaterialAge.class, ElementTag.class, "maximum_age", (attribute, prop) -> new ElementTag(prop.getMax()), "maximum_plant_growth");
        MaterialAge.autoRegister("age", MaterialAge.class, ElementTag.class, true, "plant_growth");
    }

    public int getCurrent() {
        BlockData data = this.getBlockData();
        if (data instanceof TurtleEgg) {
            TurtleEgg turtle = (TurtleEgg)data;
            return turtle.getHatch();
        }
        if (data instanceof Sapling) {
            Sapling sapling = (Sapling)data;
            return sapling.getStage();
        }
        if (data instanceof Ageable) {
            Ageable age = (Ageable)data;
            return age.getAge();
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && data instanceof Hatchable) {
            Hatchable hatchable = (Hatchable)data;
            return hatchable.getHatch();
        }
        throw new Unreachable();
    }

    public int getMax() {
        BlockData data = this.getBlockData();
        if (data instanceof TurtleEgg) {
            TurtleEgg turtle = (TurtleEgg)data;
            return turtle.getMaximumHatch();
        }
        if (data instanceof Sapling) {
            Sapling sapling = (Sapling)data;
            return sapling.getMaximumStage();
        }
        if (data instanceof Ageable) {
            Ageable age = (Ageable)data;
            return age.getMaximumAge();
        }
        if (NMSHandler.getVersion().isAtLeast(NMSVersion.v1_20) && data instanceof Hatchable) {
            Hatchable hatchable = (Hatchable)data;
            return hatchable.getMaximumHatch();
        }
        throw new Unreachable();
    }
}

