/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgSubType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.bukkit.entity.Entity;

public class FakeInternalDataCommand
extends AbstractCommand {
    public FakeInternalDataCommand() {
        this.setName("fakeinternaldata");
        this.setSyntax("fakeinternaldata [entity:<entity>] [data:<map>|...] (for:<player>|...) (speed:<duration>)");
        this.setRequiredArguments(2, 4);
        this.autoCompile();
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="entity") @ArgPrefixed EntityTag inputEntity, @ArgName(value="data") @ArgPrefixed @ArgSubType(value=MapTag.class) List<MapTag> data, @ArgName(value="for") @ArgPrefixed @ArgDefaultNull @ArgSubType(value=PlayerTag.class) List<PlayerTag> forPlayers, @ArgName(value="speed") @ArgPrefixed @ArgDefaultText(value="0s") DurationTag speed) {
        List<Object> sendTo;
        if (forPlayers != null) {
            sendTo = new ArrayList(forPlayers.size());
            for (PlayerTag player : forPlayers) {
                sendTo.add(player.getPlayerEntity());
            }
        } else if (Utilities.entryHasPlayer(scriptEntry)) {
            sendTo = List.of(Utilities.getEntryPlayer(scriptEntry).getPlayerEntity());
        } else {
            throw new InvalidArgumentsRuntimeException("Must specify players to fake the internal data for.");
        }
        Entity entity = inputEntity.getBukkitEntity();
        if (data.size() == 1) {
            NMSHandler.packetHelper.sendEntityDataPacket(sendTo, entity, NMSHandler.entityHelper.convertInternalEntityDataValues(entity, data.get(0)));
            return;
        }
        ArrayList<List<Object>> frames = new ArrayList<List<Object>>(data.size());
        for (MapTag frame : data) {
            frames.add(NMSHandler.entityHelper.convertInternalEntityDataValues(entity, frame));
        }
        long delayNanos = TimeUnit.MILLISECONDS.toNanos(speed.getMillis());
        DenizenCore.runAsync(() -> {
            long expectedTime = System.nanoTime();
            for (List frame : frames) {
                if (sendTo.isEmpty()) break;
                NMSHandler.packetHelper.sendEntityDataPacket(sendTo, entity, frame);
                LockSupport.parkNanos(delayNanos + (expectedTime - System.nanoTime()));
                expectedTime += delayNanos;
            }
        });
    }
}

