/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_21.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemComponentsPatch;
import com.denizenscript.denizen.objects.properties.item.ItemRawNBT;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftBlastingRecipe;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftCampfireRecipe;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftFurnaceRecipe;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftShapedRecipe;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftShapelessRecipe;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftSmithingTransformRecipe;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftSmithingTrimRecipe;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftSmokingRecipe;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftStonecuttingRecipe;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftTransmuteRecipe;
import org.bukkit.craftbukkit.v1_21_R4.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.TransmuteRecipe;
import org.bukkit.map.MapView;

public class ItemHelperImpl
extends ItemHelper {
    public static final Field Item_components = ReflectionHelper.getFields(dag.class).get(ReflectionMappingsInfo.Item_components, ki.class);
    public static final Field RecipeManager_featureFlagSet = ReflectionHelper.getFields(dfi.class).getFirstOfType(cvs.class);
    public Object recipeManagerFeatureFlagSetCache = null;
    public static final int DATA_VERSION_1_20_4 = 3700;
    public static final ua EMPTY_TAG = new ua();
    public static final Field AdventureModePredicate_predicates = ReflectionHelper.getFields(cyl.class).get((Object)ReflectionMappingsInfo.AdventureModePredicate_predicates);
    public static Class<?> PaperPotionMix_CLASS = null;
    public static Map<NamespacedKey, ItemHelper.BrewingRecipe> customBrewingRecipes = null;

    public static dfg<?> getNMSRecipe(NamespacedKey key) {
        alq nmsKey = alq.a((alq)mi.bv, (alr)CraftNamespacedKey.toMinecraft((NamespacedKey)key));
        return ((CraftServer)Bukkit.getServer()).getServer().aI().b(nmsKey).orElse(null);
    }

    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, (String)"maxStack").invoke(material, size);
            dag nmsItem = (dag)mh.g.a(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey()));
            ki currentComponents = nmsItem.f();
            Item_components.set(nmsItem, ki.a((ki)currentComponents, (ki)ki.a().a(kl.c, (Object)size).a()));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public static dfi getRecipeManager() {
        return ((CraftServer)Bukkit.getServer()).getServer().aI();
    }

    public void blockRecipeFinalization() {
        try {
            dfi manager = ItemHelperImpl.getRecipeManager();
            Object flags = RecipeManager_featureFlagSet.get(manager);
            if (flags != null) {
                this.recipeManagerFeatureFlagSetCache = flags;
                RecipeManager_featureFlagSet.set(manager, null);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void restoreRecipeFinalization() {
        try {
            dfi manager = ItemHelperImpl.getRecipeManager();
            if (this.recipeManagerFeatureFlagSetCache != null) {
                RecipeManager_featureFlagSet.set(manager, this.recipeManagerFeatureFlagSetCache);
                manager.finalizeRecipeLoading();
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void removeRecipes(List<NamespacedKey> keys) {
        this.blockRecipeFinalization();
        dfi manager = ItemHelperImpl.getRecipeManager();
        for (NamespacedKey key : keys) {
            alq nmsKey = alq.a((alq)mi.bv, (alr)CraftNamespacedKey.toMinecraft((NamespacedKey)key));
            manager.removeRecipe(nmsKey);
        }
        this.restoreRecipeFinalization();
    }

    public Integer burnTime(Material material) {
        return MinecraftServer.getServer().bo().b(new dak((dki)CraftMagicNumbers.getItem((Material)material)));
    }

    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c2, ItemStack[] item, boolean exact) {
        if (item.length == 1 && item[0].getType() == Material.AIR) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.AIR));
        } else if (exact) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static dex itemArrayToRecipe(ItemStack[] items, boolean exact) {
        if (!exact) {
            return dex.a(Arrays.stream(items).map(item -> CraftMagicNumbers.getItem((Material)item.getType())));
        }
        return dex.ofStacks(Arrays.stream(items).map(CraftItemStack::asNMSCopy).toList());
    }

    public static alq<dfb<?>> createRecipeKey(String name) {
        return alq.a((alq)mi.bv, (alr)alr.a((String)"denizen", (String)name));
    }

    public void registerFurnaceRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, float exp, int time, String type, boolean exact, String category) {
        den categoryValue;
        alq<dfb<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dex itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        den den2 = categoryValue = category == null ? den.c : den.valueOf((String)CoreUtilities.toUpperCase((String)category));
        Object recipe = type.equalsIgnoreCase("smoker") ? new dga(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new dek(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new dem(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : new dfv(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time)));
        dfg holder = new dfg(key, (dfb)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, boolean exact) {
        alq<dfb<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dex itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        dgb recipe = new dgb(group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        dfg holder = new dfg(key, (dfb)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerSmithingRecipe(String keyName, ItemStack result, ItemStack[] baseItem, boolean baseExact, ItemStack[] upgradeItem, boolean upgradeExact, ItemStack[] templateItem, boolean templateExact) {
        alq<dfb<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dex templateItemRecipe = ItemHelperImpl.itemArrayToRecipe(templateItem, templateExact);
        dex baseItemRecipe = ItemHelperImpl.itemArrayToRecipe(baseItem, baseExact);
        dex upgradeItemRecipe = ItemHelperImpl.itemArrayToRecipe(upgradeItem, upgradeExact);
    }

    public void registerShapelessRecipe(String keyName, String group, ItemStack result, List<ItemStack[]> ingredients, boolean[] exact, String category) {
        alq<dfb<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        ArrayList<dex> ingredientList = new ArrayList<dex>();
        deo categoryValue = category == null ? deo.d : deo.valueOf((String)CoreUtilities.toUpperCase((String)category));
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        dfr recipe = new dfr(group, categoryValue, CraftItemStack.asNMSCopy((ItemStack)result), (List)jp.a(null, (Object[])ingredientList.toArray(new dex[0])));
        dfg holder = new dfg(key, (dfb)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerOtherRecipe(Recipe recipe) {
        CraftRecipe toAdd;
        if (recipe instanceof CraftRecipe) {
            CraftRecipe craft;
            toAdd = craft = (CraftRecipe)recipe;
        } else if (recipe instanceof ShapedRecipe) {
            toAdd = CraftShapedRecipe.fromBukkitRecipe((ShapedRecipe)((ShapedRecipe)recipe));
        } else if (recipe instanceof ShapelessRecipe) {
            toAdd = CraftShapelessRecipe.fromBukkitRecipe((ShapelessRecipe)((ShapelessRecipe)recipe));
        } else if (recipe instanceof FurnaceRecipe) {
            toAdd = CraftFurnaceRecipe.fromBukkitRecipe((FurnaceRecipe)((FurnaceRecipe)recipe));
        } else if (recipe instanceof BlastingRecipe) {
            toAdd = CraftBlastingRecipe.fromBukkitRecipe((BlastingRecipe)((BlastingRecipe)recipe));
        } else if (recipe instanceof CampfireRecipe) {
            toAdd = CraftCampfireRecipe.fromBukkitRecipe((CampfireRecipe)((CampfireRecipe)recipe));
        } else if (recipe instanceof SmokingRecipe) {
            toAdd = CraftSmokingRecipe.fromBukkitRecipe((SmokingRecipe)((SmokingRecipe)recipe));
        } else if (recipe instanceof StonecuttingRecipe) {
            toAdd = CraftStonecuttingRecipe.fromBukkitRecipe((StonecuttingRecipe)((StonecuttingRecipe)recipe));
        } else if (recipe instanceof SmithingTransformRecipe) {
            toAdd = CraftSmithingTransformRecipe.fromBukkitRecipe((SmithingTransformRecipe)((SmithingTransformRecipe)recipe));
        } else if (recipe instanceof SmithingTrimRecipe) {
            toAdd = CraftSmithingTrimRecipe.fromBukkitRecipe((SmithingTrimRecipe)((SmithingTrimRecipe)recipe));
        } else {
            if (!(recipe instanceof TransmuteRecipe)) {
                if (recipe instanceof ComplexRecipe) {
                    throw new UnsupportedOperationException("Cannot add custom complex recipe");
                }
                return;
            }
            toAdd = CraftTransmuteRecipe.fromBukkitRecipe((TransmuteRecipe)((TransmuteRecipe)recipe));
        }
        toAdd.addToCraftingManager();
    }

    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).K().a().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    public JsonObject getRawHoverComponentsJson(ItemStack item) {
        kj nmsComponents = CraftItemStack.asNMSCopy((ItemStack)item).d();
        if (nmsComponents.d()) {
            return null;
        }
        return ((JsonElement)kj.b.encodeStart((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)JsonOps.INSTANCE), (Object)nmsComponents).getOrThrow()).getAsJsonObject();
    }

    public ItemStack applyRawHoverComponentsJson(ItemStack item, JsonObject components) {
        return (ItemStack)kj.b.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)JsonOps.INSTANCE), (Object)components).mapOrElse(nmsComponents -> {
            dak nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
            nmsItem.b(nmsComponents);
            return CraftItemStack.asCraftMirror((dak)nmsItem);
        }, error -> {
            Debug.echoError((String)("Invalid hover item data '" + String.valueOf(components) + "': " + error.message()));
            return item;
        });
    }

    public PlayerProfile getSkullSkin(ItemStack is) {
        dak itemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        ddk profile = (ddk)itemStack.a(kl.ak);
        if (profile != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.e().get((Object)"textures"), null);
            return new PlayerProfile((String)profile.c().orElse(null), (UUID)profile.d().orElse(null), property != null ? property.value() : null, property != null ? property.signature() : null);
        }
        return null;
    }

    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        dak nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.b(kl.ak, (Object)new ddk(gameProfile));
        return CraftItemStack.asBukkitCopy((dak)nmsItemStack);
    }

    public ItemStack addNbtData(ItemStack itemStack, String key, Tag value) {
        dak nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.a(kl.b, (Object)dcs.a, customData -> {
            CompoundTag updatedTag = CompoundTagImpl.fromNMSTag(customData.e()).createBuilder().put(key, value).build();
            return dcs.a((ua)((CompoundTagImpl)updatedTag).toNMSTag());
        });
        return CraftItemStack.asBukkitCopy((dak)nmsItemStack);
    }

    public CompoundTag getNbtData(ItemStack itemStack) {
        dak nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && !nmsItemStack.f()) {
            return CompoundTagImpl.fromNMSTag((ua)nmsItemStack.a((ji.a)CraftRegistry.getMinecraftRegistry()));
        }
        return new CompoundTagImpl(new HashMap<String, Tag>());
    }

    public ItemStack setNbtData(ItemStack itemStack, CompoundTag compoundTag) {
        dak nmsItemStack = dak.a((ji.a)CraftRegistry.getMinecraftRegistry(), (va)((CompoundTagImpl)compoundTag).toNMSTag()).orElse(dak.l);
        return CraftItemStack.asBukkitCopy((dak)nmsItemStack);
    }

    public CompoundTag getCustomData(ItemStack item) {
        dcs customData = (dcs)CraftItemStack.asNMSCopy((ItemStack)item).a(kl.b);
        return customData != null ? CompoundTagImpl.fromNMSTag(customData.e()) : null;
    }

    public ItemStack setCustomData(ItemStack item, CompoundTag data) {
        dak nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (data == null) {
            nmsItemStack.e(kl.b);
        } else {
            nmsItemStack.b(kl.b, (Object)dcs.a((ua)((CompoundTagImpl)data).toNMSTag()));
        }
        return CraftItemStack.asBukkitCopy((dak)nmsItemStack);
    }

    public ItemStack setPartialOldNbt(ItemStack item, CompoundTag oldTag) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        ua nmsOldTag = new ua();
        nmsOldTag.a("id", item.getType().getKey().toString());
        nmsOldTag.a("Count", (byte)item.getAmount());
        nmsOldTag.a("tag", (va)((CompoundTagImpl)oldTag).toNMSTag());
        ua nmsUpdatedTag = (ua)MinecraftServer.getServer().L.update(bjm.t, new Dynamic((DynamicOps)uo.a, (Object)nmsOldTag), 3700, currentDataVersion).getValue();
        ua nmsCurrentTag = (ua)CraftItemStack.asNMSCopy((ItemStack)item).a((ji.a)CraftRegistry.getMinecraftRegistry());
        ua nmsMergedTag = nmsCurrentTag.a(nmsUpdatedTag);
        return CraftItemStack.asBukkitCopy((dak)((dak)dak.a((ji.a)CraftRegistry.getMinecraftRegistry(), (va)nmsMergedTag).orElseThrow()));
    }

    public CompoundTag getEntityData(ItemStack item) {
        dcs entityData = (dcs)CraftItemStack.asNMSCopy((ItemStack)item).a(kl.Y);
        return entityData != null ? CompoundTagImpl.fromNMSTag(entityData.e()) : null;
    }

    public ItemStack setEntityData(ItemStack item, CompoundTag entityNbt, EntityType entityType) {
        ua nmsEntityNbt = EMPTY_TAG;
        if (!(entityNbt == null || entityNbt.isEmpty() || entityNbt.containsKey("id") && entityNbt.size() <= 1)) {
            nmsEntityNbt = ((CompoundTagImpl)entityNbt).toNMSTag();
            nmsEntityNbt.a("id", entityType.getKey().toString());
        }
        dak nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        dcs.a((kk)kl.Y, (dak)nmsItemStack, (ua)nmsEntityNbt);
        return CraftItemStack.asBukkitCopy((dak)nmsItemStack);
    }

    public MapTag getRawComponentsPatch(ItemStack item, boolean excludeHandled) {
        dak nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        kj patch = nmsItemStack.d();
        if (excludeHandled) {
            patch = patch.a(componentType -> {
                alr componentId = mh.am.b(componentType);
                return ItemComponentsPatch.propertyHandledComponents.contains(componentId.toString());
            });
        }
        if (patch.d()) {
            return new MapTag();
        }
        alp registryOps = CraftRegistry.getMinecraftRegistry().a((DynamicOps)uo.a);
        ua nmsPatch = (ua)kj.b.encodeStart((DynamicOps)registryOps, (Object)patch).getOrThrow();
        MapTag rawComponents = (MapTag)ItemRawNBT.jnbtTagToObject((Tag)CompoundTagImpl.fromNMSTag(nmsPatch));
        rawComponents.putObject("denizen:__data_version", (ObjectTag)new ElementTag(CraftMagicNumbers.INSTANCE.getDataVersion()));
        return rawComponents;
    }

    public ItemStack setRawComponentsPatch(ItemStack item, MapTag rawComponentsMap, int dataVersion, Consumer<String> errorHandler) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        Tag rawComponents = ItemRawNBT.convertObjectToNbt((String)rawComponentsMap.identify(), (TagContext)CoreUtilities.errorButNoDebugContext, (String)"");
        ua nmsRawComponents = ((CompoundTagImpl)rawComponents).toNMSTag();
        alp registryOps = CraftRegistry.getMinecraftRegistry().a((DynamicOps)uo.a);
        if (dataVersion < currentDataVersion) {
            ua legacyItemData = new ua();
            legacyItemData.a("id", item.getType().getKey().toString());
            legacyItemData.a("count", item.getAmount());
            legacyItemData.a("components", (va)nmsRawComponents);
            ua nmsUpdatedTag = (ua)MinecraftServer.getServer().L.update(bjm.t, new Dynamic((DynamicOps)registryOps, (Object)legacyItemData), dataVersion, currentDataVersion).getValue();
            nmsRawComponents = nmsUpdatedTag.m("components").orElseGet(ua::new);
        }
        dak nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        kj.b.parse((DynamicOps)registryOps, (Object)nmsRawComponents).ifError(error -> errorHandler.accept(error.message())).ifSuccess(arg_0 -> ((dak)nmsItemStack).b(arg_0));
        return CraftItemStack.asBukkitCopy((dak)nmsItemStack);
    }

    public List<Material> getCanPlaceOn(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (kk<cyl>)kl.m);
    }

    public ItemStack setCanPlaceOn(ItemStack item, List<Material> canPlaceOn) {
        return this.setAdventureModePredicateMaterials(item, (kk<cyl>)kl.m, canPlaceOn);
    }

    public List<Material> getCanBreak(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (kk<cyl>)kl.n);
    }

    public ItemStack setCanBreak(ItemStack item, List<Material> canBreak) {
        return this.setAdventureModePredicateMaterials(item, (kk<cyl>)kl.n, canBreak);
    }

    private List<Material> getAdventureModePredicateMaterials(ItemStack item, kk<cyl> nmsComponent) {
        List nmsPredicates;
        cyl nmsAdventurePredicate = (cyl)CraftItemStack.asNMSCopy((ItemStack)item).a(nmsComponent);
        if (nmsAdventurePredicate == null) {
            return null;
        }
        try {
            nmsPredicates = (List)AdventureModePredicate_predicates.get(nmsAdventurePredicate);
        }
        catch (Throwable e) {
            Debug.echoError((Throwable)e);
            return null;
        }
        ArrayList<Material> materials = new ArrayList<Material>();
        for (az nmsPredicate : nmsPredicates) {
            nmsPredicate.b().ifPresent(nmsHolderSet -> {
                for (jg nmsHolder : nmsHolderSet) {
                    materials.add(CraftMagicNumbers.getMaterial((dno)((dno)nmsHolder.a())));
                }
            });
        }
        return materials;
    }

    private ItemStack setAdventureModePredicateMaterials(ItemStack item, kk<cyl> nmsComponent, List<Material> materials) {
        dak nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        cyl nmsAdventurePredicate = (cyl)nmsItemStack.a(nmsComponent);
        if (materials == null) {
            if (nmsAdventurePredicate == null) {
                return item;
            }
            nmsItemStack.e(nmsComponent);
            return CraftItemStack.asBukkitCopy((dak)nmsItemStack);
        }
        return CraftItemStack.asBukkitCopy((dak)nmsItemStack);
    }

    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().h == null) {
            ((CraftInventoryPlayer)inventory).getInventory().a(slot, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }

    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        dak nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        xg nmsDisplayName = (xg)nmsItemStack.a(kl.g);
        return FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsDisplayName));
    }

    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        dak nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        ddd nmsLore = (ddd)nmsItemStack.a(kl.j);
        ArrayList<String> outList = new ArrayList<String>(nmsLore.a().size());
        for (xg nmsLoreLine : nmsLore.a()) {
            outList.add(FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsLoreLine)));
        }
        return outList;
    }

    public void setDisplayName(ItemTag item, String name) {
        dak nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (name == null || name.isEmpty()) {
            nmsItemStack.e(kl.g);
        } else {
            nmsItemStack.b(kl.g, (Object)Handler.componentToNMS(FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE)));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((dak)nmsItemStack));
    }

    public void setLore(ItemTag item, List<String> lore) {
        dak nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (lore == null || lore.isEmpty()) {
            nmsItemStack.e(kl.j);
        } else {
            ArrayList<xg> nmsLore = new ArrayList<xg>(lore.size());
            for (String loreLine : lore) {
                nmsLore.add(Handler.componentToNMS(FormattedTextHelper.parse((String)loreLine, (ChatColor)ChatColor.WHITE)));
            }
            nmsItemStack.b(kl.j, (Object)new ddd(nmsLore));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((dak)nmsItemStack));
    }

    public static ebq getCorrectStateForFluidBlock(dkj world, ebq blockState, iw blockPos) {
        eya fluid = blockState.y();
        return !fluid.c() && !blockState.c((djn)world, blockPos, jc.b) ? fluid.g() : blockState;
    }

    public static void renderFullMap(ezv worldmap, int xMin, int zMin, int xMax, int zMax) {
        asb world = ((CraftWorld)worldmap.mapView.getWorld()).getHandle();
        int scale = 1 << worldmap.g;
        int mapX = worldmap.d;
        int mapZ = worldmap.e;
        for (int x = xMin; x < xMax; ++x) {
            double d0 = 0.0;
            for (int z = zMin; z < zMax; ++z) {
                eye materialmapcolor;
                int k2 = (mapX / scale + x - 64) * scale;
                int l2 = (mapZ / scale + z - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                edx chunk = world.m(new iw(k2, 0, l2));
                if (chunk.E()) continue;
                djo chunkcoordintpair = chunk.f();
                int i3 = k2 & 0xF;
                int j3 = l2 & 0xF;
                int k3 = 0;
                double d1 = 0.0;
                if (world.F_().h()) {
                    int l3 = k2 + l2 * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)dnq.j.m().a((djn)world, iw.c), 10);
                    } else {
                        multiset.add((Object)dnq.b.m().a((djn)world, iw.c), 100);
                    }
                    d1 = 100.0;
                } else {
                    iw.a blockposition_mutableblockposition = new iw.a();
                    iw.a blockposition_mutableblockposition1 = new iw.a();
                    for (int i4 = 0; i4 < scale; ++i4) {
                        for (int j4 = 0; j4 < scale; ++j4) {
                            ebq iblockdata;
                            int k4 = chunk.a(ehp.a.b, i4 + i3, j4 + j3) + 1;
                            if (k4 <= world.K_() + 1) {
                                iblockdata = dnq.I.m();
                            } else {
                                do {
                                    blockposition_mutableblockposition.d(chunkcoordintpair.d() + i4 + i3, --k4, chunkcoordintpair.e() + j4 + j3);
                                } while ((iblockdata = chunk.a_((iw)blockposition_mutableblockposition)).a((djn)world, (iw)blockposition_mutableblockposition) == eye.a && k4 > world.K_());
                                if (k4 > world.K_() && !iblockdata.y().c()) {
                                    ebq iblockdata1;
                                    int l4 = k4 - 1;
                                    blockposition_mutableblockposition1.g((kb)blockposition_mutableblockposition);
                                    do {
                                        blockposition_mutableblockposition1.q(l4--);
                                        iblockdata1 = chunk.a_((iw)blockposition_mutableblockposition1);
                                        ++k3;
                                    } while (l4 > world.K_() && !iblockdata1.y().c());
                                    iblockdata = ItemHelperImpl.getCorrectStateForFluidBlock((dkj)world, iblockdata, (iw)blockposition_mutableblockposition);
                                }
                            }
                            worldmap.a((djn)world, chunkcoordintpair.d() + i4 + i3, chunkcoordintpair.e() + j4 + j3);
                            d1 += (double)k4 / (double)(scale * scale);
                            multiset.add((Object)iblockdata.a((djn)world, (iw)blockposition_mutableblockposition));
                        }
                    }
                }
                k3 /= scale * scale;
                double d2 = (d1 - d0) * 4.0 / (double)(scale + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int b0 = 1;
                if (d2 > 0.6) {
                    b0 = 2;
                }
                if (d2 < -0.6) {
                    b0 = 0;
                }
                if ((materialmapcolor = (eye)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)eye.a)) == eye.m) {
                    d2 = (double)k3 * 0.1 + (double)(x + z & 1) * 0.2;
                    b0 = 1;
                    if (d2 < 0.5) {
                        b0 = 2;
                    }
                    if (d2 > 0.9) {
                        b0 = 0;
                    }
                }
                d0 = d1;
                worldmap.a(x, z, (byte)(materialmapcolor.al * 4 + b0));
            }
        }
    }

    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        ezv worldmap = ((CraftServer)Bukkit.getServer()).getServer().a(dkj.i).a(new ezt(mapId));
        if (worldmap == null) {
            return false;
        }
        ItemHelperImpl.renderFullMap(worldmap, xMin, zMin, xMax, zMax);
        return true;
    }

    public BlockData getPlacedBlock(Material material) {
        dag nmsItem = mh.g.b(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElse(null);
        if (nmsItem instanceof cys) {
            dno block = ((cys)nmsItem).c();
            return CraftBlockData.fromData((ebq)block.m());
        }
        return null;
    }

    public boolean isValidMix(ItemStack input, ItemStack ingredient) {
        dak nmsInput = CraftItemStack.asNMSCopy((ItemStack)input);
        dak nmsIngredient = CraftItemStack.asNMSCopy((ItemStack)ingredient);
        return MinecraftServer.getServer().bn().a(nmsInput, nmsIngredient);
    }

    public Map<NamespacedKey, ItemHelper.BrewingRecipe> getCustomBrewingRecipes() {
        if (customBrewingRecipes == null) {
            customBrewingRecipes = Maps.transformValues((Map)((Map)ReflectionHelper.getFieldValue(dcf.class, (String)"customMixes", (Object)MinecraftServer.getServer().bn())), paperMix -> {
                if (PaperPotionMix_CLASS == null) {
                    PaperPotionMix_CLASS = paperMix.getClass();
                }
                RecipeChoice ingredient = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"ingredient", (Object)paperMix));
                RecipeChoice input = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"input", (Object)paperMix));
                ItemStack result = CraftItemStack.asBukkitCopy((dak)((dak)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"result", (Object)paperMix)));
                return new ItemHelper.BrewingRecipe(input, ingredient, result);
            });
        }
        return customBrewingRecipes;
    }

    private RecipeChoice convertChoice(Predicate<dak> nmsPredicate) {
        if (nmsPredicate instanceof dex) {
            dex ingredient = (dex)nmsPredicate;
            return CraftRecipe.toBukkit((dex)ingredient);
        }
        return PaperAPITools.instance.createPredicateRecipeChoice(item -> nmsPredicate.test(CraftItemStack.asNMSCopy((ItemStack)item)));
    }

    public byte[] renderMap(MapView mapView, Player player) {
        return ((CraftMapView)mapView).render((CraftPlayer)((CraftPlayer)player)).buffer;
    }

    public int getFoodPoints(Material itemType) {
        return ((cvy)CraftMagicNumbers.getItem((Material)itemType).f().a(kl.v)).a();
    }

    public DyeColor getShieldColor(ItemStack item) {
        czi nmsColor = (czi)CraftItemStack.asNMSCopy((ItemStack)item).a(kl.an);
        return nmsColor != null ? DyeColor.getByWoolData((byte)((byte)nmsColor.a())) : null;
    }

    public ItemStack setShieldColor(ItemStack item, DyeColor color) {
        dak nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (color != null) {
            nmsItemStack.b(kl.an, (Object)czi.a((int)color.getWoolData()));
        } else {
            nmsItemStack.e(kl.an);
        }
        return CraftItemStack.asBukkitCopy((dak)nmsItemStack);
    }
}

