/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.v1_21.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class DisguisePacketHandlers {
    private static boolean antiDuplicate = false;

    public static void registerHandlers() {
        DisguisePacketHandlers.registerPacketHandler(afz.class, afz::b, DisguisePacketHandlers::processEntityDataPacket);
        DisguisePacketHandlers.registerPacketHandler(ahe.class, ahe::b, DisguisePacketHandlers::processAttributesPacket);
        DisguisePacketHandlers.registerPacketHandler(acr.class, acr::b, DisguisePacketHandlers::sendDisguiseForPacket);
        DisguisePacketHandlers.registerPacketHandler(agy.class, agy::b, DisguisePacketHandlers::processTeleportPacket);
        DisguisePacketHandlers.registerPacketHandler(aek.c.class, aek::a, DisguisePacketHandlers::processMoveEntityRotPacket);
        DisguisePacketHandlers.registerPacketHandler(aek.b.class, aek::a, DisguisePacketHandlers::processMoveEntityPosRotPacket);
    }

    public static <T extends zw<acq>> void registerPacketHandler(Class<T> packetType, ToIntFunction<T> idGetter, DisguisePacketHandler<T> handler) {
        DisguisePacketHandlers.registerPacketHandler(packetType, (T packet, dmu level) -> level.a(idGetter.applyAsInt(packet)), handler);
    }

    public static <T extends zw<acq>> void registerPacketHandler(Class<T> packetType, BiFunction<T, dmu, bzm> entityGetter, DisguisePacketHandler<T> handler) {
        DenizenNetworkManagerImpl.registerPacketHandler(packetType, (networkManager, packet) -> {
            if (DisguiseCommand.disguises.isEmpty() || antiDuplicate) {
                return packet;
            }
            bzm entity = (bzm)entityGetter.apply((Object)packet, (dmu)networkManager.player.y());
            if (entity == null) {
                return packet;
            }
            Map playerMap = (Map)DisguiseCommand.disguises.get(entity.cK());
            if (playerMap == null) {
                return packet;
            }
            DisguiseCommand.TrackedDisguise disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(networkManager.player.cK());
            if (disguise == null) {
                disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(null);
            }
            if (disguise == null || !disguise.isActive) {
                return packet;
            }
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("DISGUISED packet " + packet.getClass().getName() + " for entity " + entity.ar() + " to player " + networkManager.player.cM());
            }
            try {
                return handler.handle(networkManager, packet, disguise);
            }
            catch (Exception e2) {
                antiDuplicate = false;
                throw e2;
            }
        });
    }

    public static afz processEntityDataPacket(DenizenNetworkManagerImpl networkManager, afz entityDataPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (entityDataPacket.b() == networkManager.player.ar()) {
            if (!disguise.shouldFake) {
                return entityDataPacket;
            }
            for (all.c dataValue : entityDataPacket.e()) {
                if (dataValue.a() != 0) continue;
                ArrayList<all.c<Byte>> newData = new ArrayList<all.c<Byte>>(entityDataPacket.e());
                newData.remove(dataValue);
                byte flags = (Byte)dataValue.c();
                flags = (byte)(flags | 0x20);
                newData.add(PacketHelperImpl.createEntityData(PacketHelperImpl.ENTITY_DATA_ACCESSOR_FLAGS, flags));
                return new afz(entityDataPacket.b(), newData);
            }
        } else {
            List data = ((CraftEntity)disguise.toOthers.entity.entity).getHandle().au().c();
            return data != null ? new afz(entityDataPacket.b(), data) : null;
        }
        return entityDataPacket;
    }

    public static ahe processAttributesPacket(DenizenNetworkManagerImpl networkManager, ahe attributesPacket, DisguiseCommand.TrackedDisguise disguise) {
        FakeEntity fake = attributesPacket.b() == networkManager.player.ar() ? disguise.fakeToSelf : disguise.toOthers;
        return fake == null || fake.entity.entity instanceof LivingEntity ? attributesPacket : null;
    }

    public static agy processTeleportPacket(DenizenNetworkManagerImpl networkManager, agy teleportEntityPacket, DisguiseCommand.TrackedDisguise disguise) throws IllegalAccessException {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            caz oldChange = teleportEntityPacket.e();
            return new agy(teleportEntityPacket.b(), new caz(oldChange.a(), oldChange.b(), EntityAttachmentHelper.normalizeAngle((float)(oldChange.c() + 180.0f)), oldChange.d()), teleportEntityPacket.f(), teleportEntityPacket.g());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, teleportEntityPacket, disguise);
    }

    public static aek.c processMoveEntityRotPacket(DenizenNetworkManagerImpl networkManager, aek.c rotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new aek.c(disguise.entity.getBukkitEntity().getEntityId(), EntityAttachmentHelper.compressAngle((float)(rotPacket.g() + 180.0f)), bcb.g((float)rotPacket.h()), rotPacket.k());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, rotPacket, disguise);
    }

    public static aek.b processMoveEntityPosRotPacket(DenizenNetworkManagerImpl networkManager, aek.b posRotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new aek.b(disguise.entity.getBukkitEntity().getEntityId(), posRotPacket.b(), posRotPacket.e(), posRotPacket.f(), EntityAttachmentHelper.compressAngle((float)(posRotPacket.g() + 180.0f)), bcb.g((float)posRotPacket.h()), posRotPacket.k());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, posRotPacket, disguise);
    }

    public static <T extends zw<acq>> T sendDisguiseForPacket(DenizenNetworkManagerImpl networkManager, T packet, DisguiseCommand.TrackedDisguise disguise) {
        antiDuplicate = true;
        disguise.sendTo(List.of(new PlayerTag(networkManager.player.cK())));
        antiDuplicate = false;
        return null;
    }

    @FunctionalInterface
    public static interface DisguisePacketHandler<T extends zw<acq>> {
        public T handle(DenizenNetworkManagerImpl var1, T var2, DisguiseCommand.TrackedDisguise var3) throws Exception;
    }
}

