/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.v1_20.Handler;
import com.denizenscript.denizen.nms.v1_20.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.scripts.commands.entity.RenameCommand;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerRespawnEvent;

public class ProfileEditorImpl
extends ProfileEditor {
    public static final String EMPTY_NAME = "";
    public static final UUID NIL_UUID = new UUID(0L, 0L);
    public static final Field ClientboundPlayerInfoUpdatePacket_entries = ReflectionHelper.getFields(aeo.class).getFirstOfType(List.class);

    protected void updatePlayer(Player player, boolean isSkinChanging) {
        arg nmsPlayer = ((CraftPlayer)player).getHandle();
        UUID uuid = player.getUniqueId();
        aen removePlayerInfoPacket = new aen(List.of(uuid));
        aeo addPlayerInfoPacket = aeo.a(List.of(nmsPlayer));
        for (Player otherPlayer : Bukkit.getServer().getOnlinePlayers()) {
            PacketHelperImpl.send(otherPlayer, removePlayerInfoPacket);
            PacketHelperImpl.send(otherPlayer, addPlayerInfoPacket);
        }
        for (Player otherPlayer : NMSHandler.entityHelper.getPlayersThatSee((Entity)player)) {
            if (otherPlayer.getUniqueId().equals(uuid)) continue;
            PacketHelperImpl.forceRespawnPlayerEntity((Entity)player, otherPlayer);
        }
        if (isSkinChanging) {
            ((CraftServer)Bukkit.getServer()).getHandle().respawn(nmsPlayer, (arf)nmsPlayer.dP(), true, player.getLocation(), false, PlayerRespawnEvent.RespawnReason.PLUGIN);
        }
        player.updateInventory();
    }

    public static void registerHandlers() {
        DenizenNetworkManagerImpl.registerPacketHandler(aeo.class, ProfileEditorImpl::processPlayerInfoUpdatePacket);
    }

    public static aeo processPlayerInfoUpdatePacket(DenizenNetworkManagerImpl networkManager, aeo playerInfoUpdatePacket) {
        if (ProfileEditor.mirrorUUIDs.isEmpty() && !RenameCommand.hasAnyDynamicRenames() && fakeProfiles.isEmpty()) {
            return playerInfoUpdatePacket;
        }
        EnumSet actions = playerInfoUpdatePacket.b();
        if (!actions.contains(aeo.a.a) && !actions.contains(aeo.a.f)) {
            return playerInfoUpdatePacket;
        }
        boolean any = false;
        for (aeo.b entry : playerInfoUpdatePacket.e()) {
            if (!ProfileEditorImpl.shouldChange(entry)) continue;
            any = true;
            break;
        }
        if (!any) {
            return playerInfoUpdatePacket;
        }
        GameProfile ownProfile = networkManager.player.gb();
        ArrayList<aeo.b> modifiedEntries = new ArrayList<aeo.b>(playerInfoUpdatePacket.e().size());
        for (aeo.b entry : playerInfoUpdatePacket.e()) {
            if (!ProfileEditorImpl.shouldChange(entry)) {
                modifiedEntries.add(entry);
                continue;
            }
            String rename = RenameCommand.getCustomNameFor((UUID)entry.a(), (Player)networkManager.player.getBukkitEntity(), (boolean)false);
            GameProfile baseProfile = fakeProfiles.containsKey(entry.a()) ? ProfileEditorImpl.getGameProfile((PlayerProfile)fakeProfiles.get(entry.a())) : entry.b();
            GameProfile modifiedProfile = new GameProfile(baseProfile.getId(), rename != null ? (rename.length() > 16 ? rename.substring(0, 16) : rename) : baseProfile.getName());
            if (ProfileEditor.mirrorUUIDs.contains(entry.a())) {
                modifiedProfile.getProperties().putAll((Multimap)ownProfile.getProperties());
            } else {
                modifiedProfile.getProperties().putAll((Multimap)(Denizen.supportsPaper ? entry.b().getProperties() : baseProfile.getProperties()));
            }
            String listRename = RenameCommand.getCustomNameFor((UUID)entry.a(), (Player)networkManager.player.getBukkitEntity(), (boolean)true);
            xp displayName = listRename != null ? Handler.componentToNMS(FormattedTextHelper.parse((String)listRename, (ChatColor)ChatColor.WHITE)) : entry.f();
            aeo.b modifiedEntry = new aeo.b(entry.a(), modifiedProfile, entry.c(), entry.d(), entry.e(), displayName, entry.g());
            modifiedEntries.add(modifiedEntry);
        }
        return ProfileEditorImpl.createInfoPacket(actions, modifiedEntries);
    }

    public static boolean shouldChange(aeo.b entry) {
        return ProfileEditor.mirrorUUIDs.contains(entry.a()) || RenameCommand.customNames.containsKey(entry.a()) || fakeProfiles.containsKey(entry.a());
    }

    public static aeo createInfoPacket(EnumSet<aeo.a> actions, List<aeo.b> entries) {
        aeo playerInfoUpdatePacket = new aeo(actions, List.of());
        try {
            ClientboundPlayerInfoUpdatePacket_entries.set(playerInfoUpdatePacket, entries);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        return playerInfoUpdatePacket;
    }

    public static GameProfile getGameProfileNoProperties(PlayerProfile playerProfile) {
        UUID uuid = playerProfile.getUniqueId();
        String name = playerProfile.getName();
        return new GameProfile(uuid != null ? uuid : NIL_UUID, name != null ? name : EMPTY_NAME);
    }

    public static GameProfile getGameProfile(PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfileNoProperties(playerProfile);
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        return gameProfile;
    }
}

