/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_21.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemComponentsPatch;
import com.denizenscript.denizen.objects.properties.item.ItemRawNBT;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.PaperAPITools;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftBlastingRecipe;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftCampfireRecipe;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftFurnaceRecipe;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftShapedRecipe;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftShapelessRecipe;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftSmithingTransformRecipe;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftSmithingTrimRecipe;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftSmokingRecipe;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftStonecuttingRecipe;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftTransmuteRecipe;
import org.bukkit.craftbukkit.v1_21_R5.map.CraftMapView;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.TransmuteRecipe;
import org.bukkit.map.MapView;

public class ItemHelperImpl
extends ItemHelper {
    public static final Field Item_components = ReflectionHelper.getFields(dcr.class).get(ReflectionMappingsInfo.Item_components, kn.class);
    public static final Field RecipeManager_featureFlagSet = ReflectionHelper.getFields(dht.class).getFirstOfType(cyd.class);
    public Object recipeManagerFeatureFlagSetCache = null;
    public static final int DATA_VERSION_1_20_4 = 3700;
    public static final ui EMPTY_TAG = new ui();
    public static final Field AdventureModePredicate_predicates = ReflectionHelper.getFields(daw.class).get(ReflectionMappingsInfo.AdventureModePredicate_predicates);
    public static Class<?> PaperPotionMix_CLASS = null;
    public static Map<NamespacedKey, ItemHelper.BrewingRecipe> customBrewingRecipes = null;

    public static dhr<?> getNMSRecipe(NamespacedKey key) {
        amd nmsKey = amd.a((amd)mn.bA, (ame)CraftNamespacedKey.toMinecraft((NamespacedKey)key));
        return ((CraftServer)Bukkit.getServer()).getServer().aI().b(nmsKey).orElse(null);
    }

    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, (String)"maxStack").invoke(material, size);
            dcr nmsItem = (dcr)mm.g.a(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey()));
            kn currentComponents = nmsItem.f();
            Item_components.set(nmsItem, kn.a((kn)currentComponents, (kn)kn.a().a(kq.c, (Object)size).a()));
        }
        catch (Throwable ex2) {
            Debug.echoError((Throwable)ex2);
        }
    }

    public static dht getRecipeManager() {
        return ((CraftServer)Bukkit.getServer()).getServer().aI();
    }

    public static ui serializeNmsItem(dcv nmsItem) {
        return (ui)dcv.b.encodeStart((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)uw.a), (Object)nmsItem).getOrThrow();
    }

    public static dcv parseNmsItem(ui nmsTag) {
        return (dcv)dcv.b.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)uw.a), (Object)nmsTag).getOrThrow();
    }

    public void blockRecipeFinalization() {
        try {
            dht manager = ItemHelperImpl.getRecipeManager();
            Object flags = RecipeManager_featureFlagSet.get(manager);
            if (flags != null) {
                this.recipeManagerFeatureFlagSetCache = flags;
                RecipeManager_featureFlagSet.set(manager, null);
            }
        }
        catch (Throwable ex2) {
            Debug.echoError((Throwable)ex2);
        }
    }

    public void restoreRecipeFinalization() {
        try {
            dht manager = ItemHelperImpl.getRecipeManager();
            if (this.recipeManagerFeatureFlagSetCache != null) {
                RecipeManager_featureFlagSet.set(manager, this.recipeManagerFeatureFlagSetCache);
                manager.finalizeRecipeLoading();
            }
        }
        catch (Throwable ex2) {
            Debug.echoError((Throwable)ex2);
        }
    }

    public void removeRecipes(List<NamespacedKey> keys) {
        this.blockRecipeFinalization();
        dht manager = ItemHelperImpl.getRecipeManager();
        for (NamespacedKey key : keys) {
            amd nmsKey = amd.a((amd)mn.bA, (ame)CraftNamespacedKey.toMinecraft((NamespacedKey)key));
            manager.removeRecipe(nmsKey);
        }
        this.restoreRecipeFinalization();
    }

    public Integer burnTime(Material material) {
        return MinecraftServer.getServer().bo().b(new dcv((dmt)CraftMagicNumbers.getItem((Material)material)));
    }

    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c2, ItemStack[] item, boolean exact) {
        if (item.length == 1 && item[0].getType() == Material.AIR) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.AIR));
        } else if (exact) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static dhi itemArrayToRecipe(ItemStack[] items, boolean exact) {
        if (!exact) {
            return dhi.a(Arrays.stream(items).map(item -> CraftMagicNumbers.getItem((Material)item.getType())));
        }
        return dhi.ofStacks(Arrays.stream(items).map(CraftItemStack::asNMSCopy).toList());
    }

    public static amd<dhm<?>> createRecipeKey(String name) {
        return amd.a((amd)mn.bA, (ame)ame.a((String)"denizen", (String)name));
    }

    public void registerFurnaceRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, float exp, int time, String type, boolean exact, String category) {
        dgy categoryValue;
        amd<dhm<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dhi itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        dgy dgy2 = categoryValue = category == null ? dgy.c : dgy.valueOf((String)CoreUtilities.toUpperCase((String)category));
        Object recipe = type.equalsIgnoreCase("smoker") ? new dil(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new dgv(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new dgx(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : new dig(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time)));
        dhr holder = new dhr(key, (dhm)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, boolean exact) {
        amd<dhm<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dhi itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        dim recipe = new dim(group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        dhr holder = new dhr(key, (dhm)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerSmithingRecipe(String keyName, ItemStack result, ItemStack[] baseItem, boolean baseExact, ItemStack[] upgradeItem, boolean upgradeExact, ItemStack[] templateItem, boolean templateExact) {
        amd<dhm<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        dhi templateItemRecipe = ItemHelperImpl.itemArrayToRecipe(templateItem, templateExact);
        dhi baseItemRecipe = ItemHelperImpl.itemArrayToRecipe(baseItem, baseExact);
        dhi upgradeItemRecipe = ItemHelperImpl.itemArrayToRecipe(upgradeItem, upgradeExact);
    }

    public void registerShapelessRecipe(String keyName, String group, ItemStack result, List<ItemStack[]> ingredients, boolean[] exact, String category) {
        amd<dhm<?>> key = ItemHelperImpl.createRecipeKey(keyName);
        ArrayList<dhi> ingredientList = new ArrayList<dhi>();
        dgz categoryValue = category == null ? dgz.d : dgz.valueOf((String)CoreUtilities.toUpperCase((String)category));
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        dic recipe = new dic(group, categoryValue, CraftItemStack.asNMSCopy((ItemStack)result), (List)ju.a(null, (Object[])ingredientList.toArray(new dhi[0])));
        dhr holder = new dhr(key, (dhm)recipe);
        ItemHelperImpl.getRecipeManager().addRecipe(holder);
    }

    public void registerOtherRecipe(Recipe recipe) {
        CraftRecipe toAdd;
        if (recipe instanceof CraftRecipe) {
            CraftRecipe craft;
            toAdd = craft = (CraftRecipe)recipe;
        } else if (recipe instanceof ShapedRecipe) {
            toAdd = CraftShapedRecipe.fromBukkitRecipe((ShapedRecipe)((ShapedRecipe)recipe));
        } else if (recipe instanceof ShapelessRecipe) {
            toAdd = CraftShapelessRecipe.fromBukkitRecipe((ShapelessRecipe)((ShapelessRecipe)recipe));
        } else if (recipe instanceof FurnaceRecipe) {
            toAdd = CraftFurnaceRecipe.fromBukkitRecipe((FurnaceRecipe)((FurnaceRecipe)recipe));
        } else if (recipe instanceof BlastingRecipe) {
            toAdd = CraftBlastingRecipe.fromBukkitRecipe((BlastingRecipe)((BlastingRecipe)recipe));
        } else if (recipe instanceof CampfireRecipe) {
            toAdd = CraftCampfireRecipe.fromBukkitRecipe((CampfireRecipe)((CampfireRecipe)recipe));
        } else if (recipe instanceof SmokingRecipe) {
            toAdd = CraftSmokingRecipe.fromBukkitRecipe((SmokingRecipe)((SmokingRecipe)recipe));
        } else if (recipe instanceof StonecuttingRecipe) {
            toAdd = CraftStonecuttingRecipe.fromBukkitRecipe((StonecuttingRecipe)((StonecuttingRecipe)recipe));
        } else if (recipe instanceof SmithingTransformRecipe) {
            toAdd = CraftSmithingTransformRecipe.fromBukkitRecipe((SmithingTransformRecipe)((SmithingTransformRecipe)recipe));
        } else if (recipe instanceof SmithingTrimRecipe) {
            toAdd = CraftSmithingTrimRecipe.fromBukkitRecipe((SmithingTrimRecipe)((SmithingTrimRecipe)recipe));
        } else {
            if (!(recipe instanceof TransmuteRecipe)) {
                if (recipe instanceof ComplexRecipe) {
                    throw new UnsupportedOperationException("Cannot add custom complex recipe");
                }
                return;
            }
            toAdd = CraftTransmuteRecipe.fromBukkitRecipe((TransmuteRecipe)((TransmuteRecipe)recipe));
        }
        toAdd.addToCraftingManager();
    }

    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).K().a().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    public JsonObject getRawHoverComponentsJson(ItemStack item) {
        ko nmsComponents = CraftItemStack.asNMSCopy((ItemStack)item).d();
        if (nmsComponents.d()) {
            return null;
        }
        return ((JsonElement)ko.b.encodeStart((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)JsonOps.INSTANCE), (Object)nmsComponents).getOrThrow()).getAsJsonObject();
    }

    public ItemStack applyRawHoverComponentsJson(ItemStack item, JsonObject components) {
        return (ItemStack)ko.b.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)JsonOps.INSTANCE), (Object)components).mapOrElse(nmsComponents -> {
            dcv nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
            nmsItem.b(nmsComponents);
            return CraftItemStack.asCraftMirror((dcv)nmsItem);
        }, error -> {
            Debug.echoError((String)("Invalid hover item data '" + String.valueOf(components) + "': " + error.message()));
            return item;
        });
    }

    public PlayerProfile getSkullSkin(ItemStack is) {
        dcv itemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        dfv profile = (dfv)itemStack.a(kq.ak);
        if (profile != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.f().get((Object)"textures"), null);
            return new PlayerProfile((String)profile.d().orElse(null), (UUID)profile.e().orElse(null), property != null ? property.value() : null, property != null ? property.signature() : null);
        }
        return null;
    }

    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        dcv nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.b(kq.ak, (Object)new dfv(gameProfile));
        return CraftItemStack.asBukkitCopy((dcv)nmsItemStack);
    }

    public ItemStack addNbtData(ItemStack itemStack, String key, Tag value) {
        dcv nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.a(kq.b, (Object)dfd.a, customData -> {
            CompoundTag updatedTag = CompoundTagImpl.fromNMSTag(customData.e()).createBuilder().put(key, value).build();
            return dfd.a((ui)((CompoundTagImpl)updatedTag).toNMSTag());
        });
        return CraftItemStack.asBukkitCopy((dcv)nmsItemStack);
    }

    public CompoundTag getNbtData(ItemStack itemStack) {
        dcv nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && !nmsItemStack.f()) {
            return CompoundTagImpl.fromNMSTag(ItemHelperImpl.serializeNmsItem(nmsItemStack));
        }
        return new CompoundTagImpl(new HashMap<String, Tag>());
    }

    public ItemStack setNbtData(ItemStack itemStack, CompoundTag compoundTag) {
        return CraftItemStack.asBukkitCopy((dcv)ItemHelperImpl.parseNmsItem(((CompoundTagImpl)compoundTag).toNMSTag()));
    }

    public CompoundTag getCustomData(ItemStack item) {
        dfd customData = (dfd)CraftItemStack.asNMSCopy((ItemStack)item).a(kq.b);
        return customData != null ? CompoundTagImpl.fromNMSTag(customData.e()) : null;
    }

    public ItemStack setCustomData(ItemStack item, CompoundTag data) {
        dcv nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        if (data == null) {
            nmsItemStack.e(kq.b);
        } else {
            nmsItemStack.b(kq.b, (Object)dfd.a((ui)((CompoundTagImpl)data).toNMSTag()));
        }
        return CraftItemStack.asBukkitCopy((dcv)nmsItemStack);
    }

    public ItemStack setPartialOldNbt(ItemStack item, CompoundTag oldTag) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        ui nmsOldTag = new ui();
        nmsOldTag.a("id", item.getType().getKey().toString());
        nmsOldTag.a("Count", (byte)item.getAmount());
        nmsOldTag.a("tag", (vi)((CompoundTagImpl)oldTag).toNMSTag());
        ui nmsUpdatedTag = (ui)MinecraftServer.getServer().L.update(blp.u, new Dynamic((DynamicOps)uw.a, (Object)nmsOldTag), 3700, currentDataVersion).getValue();
        ui nmsCurrentTag = ItemHelperImpl.serializeNmsItem(CraftItemStack.asNMSCopy((ItemStack)item));
        ui nmsMergedTag = nmsCurrentTag.a(nmsUpdatedTag);
        return CraftItemStack.asBukkitCopy((dcv)ItemHelperImpl.parseNmsItem(nmsMergedTag));
    }

    public CompoundTag getEntityData(ItemStack item) {
        dfd entityData = (dfd)CraftItemStack.asNMSCopy((ItemStack)item).a(kq.Y);
        return entityData != null ? CompoundTagImpl.fromNMSTag(entityData.e()) : null;
    }

    public ItemStack setEntityData(ItemStack item, CompoundTag entityNbt, EntityType entityType) {
        ui nmsEntityNbt = EMPTY_TAG;
        if (!(entityNbt == null || entityNbt.isEmpty() || entityNbt.containsKey("id") && entityNbt.size() <= 1)) {
            nmsEntityNbt = ((CompoundTagImpl)entityNbt).toNMSTag();
            nmsEntityNbt.a("id", entityType.getKey().toString());
        }
        dcv nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        dfd.a((kp)kq.Y, (dcv)nmsItemStack, (ui)nmsEntityNbt);
        return CraftItemStack.asBukkitCopy((dcv)nmsItemStack);
    }

    public MapTag getRawComponentsPatch(ItemStack item, boolean excludeHandled) {
        dcv nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        ko patch = nmsItemStack.d();
        if (excludeHandled) {
            patch = patch.a(componentType -> {
                ame componentId = mm.am.b(componentType);
                return ItemComponentsPatch.propertyHandledComponents.contains(componentId.toString());
            });
        }
        if (patch.d()) {
            return new MapTag();
        }
        amc registryOps = CraftRegistry.getMinecraftRegistry().a((DynamicOps)uw.a);
        ui nmsPatch = (ui)ko.b.encodeStart((DynamicOps)registryOps, (Object)patch).getOrThrow();
        MapTag rawComponents = (MapTag)ItemRawNBT.jnbtTagToObject((Tag)CompoundTagImpl.fromNMSTag(nmsPatch));
        rawComponents.putObject("denizen:__data_version", (ObjectTag)new ElementTag(CraftMagicNumbers.INSTANCE.getDataVersion()));
        return rawComponents;
    }

    public ItemStack setRawComponentsPatch(ItemStack item, MapTag rawComponentsMap, int dataVersion, Consumer<String> errorHandler) {
        int currentDataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        Tag rawComponents = ItemRawNBT.convertObjectToNbt((String)rawComponentsMap.identify(), (TagContext)CoreUtilities.errorButNoDebugContext, (String)"");
        ui nmsRawComponents = ((CompoundTagImpl)rawComponents).toNMSTag();
        amc registryOps = CraftRegistry.getMinecraftRegistry().a((DynamicOps)uw.a);
        if (dataVersion < currentDataVersion) {
            ui legacyItemData = new ui();
            legacyItemData.a("id", item.getType().getKey().toString());
            legacyItemData.a("count", item.getAmount());
            legacyItemData.a("components", (vi)nmsRawComponents);
            ui nmsUpdatedTag = (ui)MinecraftServer.getServer().L.update(blp.u, new Dynamic((DynamicOps)registryOps, (Object)legacyItemData), dataVersion, currentDataVersion).getValue();
            nmsRawComponents = nmsUpdatedTag.m("components").orElseGet(ui::new);
        }
        dcv nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        ko.b.parse((DynamicOps)registryOps, (Object)nmsRawComponents).ifError(error -> errorHandler.accept(error.message())).ifSuccess(arg_0 -> ((dcv)nmsItemStack).b(arg_0));
        return CraftItemStack.asBukkitCopy((dcv)nmsItemStack);
    }

    public List<Material> getCanPlaceOn(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (kp<daw>)kq.m);
    }

    public ItemStack setCanPlaceOn(ItemStack item, List<Material> canPlaceOn) {
        return this.setAdventureModePredicateMaterials(item, (kp<daw>)kq.m, canPlaceOn);
    }

    public List<Material> getCanBreak(ItemStack item) {
        return this.getAdventureModePredicateMaterials(item, (kp<daw>)kq.n);
    }

    public ItemStack setCanBreak(ItemStack item, List<Material> canBreak) {
        return this.setAdventureModePredicateMaterials(item, (kp<daw>)kq.n, canBreak);
    }

    private List<Material> getAdventureModePredicateMaterials(ItemStack item, kp<daw> nmsComponent) {
        List nmsPredicates;
        daw nmsAdventurePredicate = (daw)CraftItemStack.asNMSCopy((ItemStack)item).a(nmsComponent);
        if (nmsAdventurePredicate == null) {
            return null;
        }
        try {
            nmsPredicates = (List)AdventureModePredicate_predicates.get(nmsAdventurePredicate);
        }
        catch (Throwable e2) {
            Debug.echoError((Throwable)e2);
            return null;
        }
        ArrayList<Material> materials = new ArrayList<Material>();
        for (az nmsPredicate : nmsPredicates) {
            nmsPredicate.b().ifPresent(nmsHolderSet -> {
                for (jl nmsHolder : nmsHolderSet) {
                    materials.add(CraftMagicNumbers.getMaterial((dpz)((dpz)nmsHolder.a())));
                }
            });
        }
        return materials;
    }

    private ItemStack setAdventureModePredicateMaterials(ItemStack item, kp<daw> nmsComponent, List<Material> materials) {
        dcv nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item);
        daw nmsAdventurePredicate = (daw)nmsItemStack.a(nmsComponent);
        if (materials == null) {
            if (nmsAdventurePredicate == null) {
                return item;
            }
            nmsItemStack.e(nmsComponent);
            return CraftItemStack.asBukkitCopy((dcv)nmsItemStack);
        }
        az nmsPredicate = new az(Optional.of(jp.a(material -> (jl)mm.e.c(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElseThrow(), materials)), Optional.empty(), Optional.empty(), bo.a);
        nmsItemStack.b(nmsComponent, (Object)new daw(List.of(nmsPredicate)));
        return CraftItemStack.asBukkitCopy((dcv)nmsItemStack);
    }

    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().j == null) {
            ((CraftInventoryPlayer)inventory).getInventory().a(slot, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }

    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        dcv nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        xo nmsDisplayName = (xo)nmsItemStack.a(kq.g);
        return FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsDisplayName));
    }

    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        dcv nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        dfo nmsLore = (dfo)nmsItemStack.a(kq.j);
        ArrayList<String> outList = new ArrayList<String>(nmsLore.a().size());
        for (xo nmsLoreLine : nmsLore.a()) {
            outList.add(FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(nmsLoreLine)));
        }
        return outList;
    }

    public void setDisplayName(ItemTag item, String name) {
        dcv nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (name == null || name.isEmpty()) {
            nmsItemStack.e(kq.g);
        } else {
            nmsItemStack.b(kq.g, (Object)Handler.componentToNMS(FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE)));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((dcv)nmsItemStack));
    }

    public void setLore(ItemTag item, List<String> lore) {
        dcv nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        if (lore == null || lore.isEmpty()) {
            nmsItemStack.e(kq.j);
        } else {
            ArrayList<xo> nmsLore = new ArrayList<xo>(lore.size());
            for (String loreLine : lore) {
                nmsLore.add(Handler.componentToNMS(FormattedTextHelper.parse((String)loreLine, (ChatColor)ChatColor.WHITE)));
            }
            nmsItemStack.b(kq.j, (Object)new dfo(nmsLore));
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((dcv)nmsItemStack));
    }

    public static eeb getCorrectStateForFluidBlock(dmu world, eeb blockState, jb blockPos) {
        fal fluid = blockState.y();
        return !fluid.c() && !blockState.c((dly)world, blockPos, jh.b) ? fluid.g() : blockState;
    }

    public static void renderFullMap(fcg worldmap, int xMin, int zMin, int xMax, int zMax) {
        aub world = ((CraftWorld)worldmap.mapView.getWorld()).getHandle();
        int scale = 1 << worldmap.g;
        int mapX = worldmap.d;
        int mapZ = worldmap.e;
        for (int x = xMin; x < xMax; ++x) {
            double d0 = 0.0;
            for (int z = zMin; z < zMax; ++z) {
                fap materialmapcolor;
                int k2 = (mapX / scale + x - 64) * scale;
                int l2 = (mapZ / scale + z - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                egi chunk = world.m(new jb(k2, 0, l2));
                if (chunk.F()) continue;
                dlz chunkcoordintpair = chunk.f();
                int i3 = k2 & 0xF;
                int j3 = l2 & 0xF;
                int k3 = 0;
                double d1 = 0.0;
                if (world.G_().h()) {
                    int l3 = k2 + l2 * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)dqb.j.m().a((dly)world, jb.c), 10);
                    } else {
                        multiset.add((Object)dqb.b.m().a((dly)world, jb.c), 100);
                    }
                    d1 = 100.0;
                } else {
                    jb.a blockposition_mutableblockposition = new jb.a();
                    jb.a blockposition_mutableblockposition1 = new jb.a();
                    for (int i4 = 0; i4 < scale; ++i4) {
                        for (int j4 = 0; j4 < scale; ++j4) {
                            eeb iblockdata;
                            int k4 = chunk.a(eka.a.b, i4 + i3, j4 + j3) + 1;
                            if (k4 <= world.L_() + 1) {
                                iblockdata = dqb.I.m();
                            } else {
                                do {
                                    blockposition_mutableblockposition.d(chunkcoordintpair.d() + i4 + i3, --k4, chunkcoordintpair.e() + j4 + j3);
                                } while ((iblockdata = chunk.a_((jb)blockposition_mutableblockposition)).a((dly)world, (jb)blockposition_mutableblockposition) == fap.a && k4 > world.L_());
                                if (k4 > world.L_() && !iblockdata.y().c()) {
                                    eeb iblockdata1;
                                    int l4 = k4 - 1;
                                    blockposition_mutableblockposition1.g((kg)blockposition_mutableblockposition);
                                    do {
                                        blockposition_mutableblockposition1.q(l4--);
                                        iblockdata1 = chunk.a_((jb)blockposition_mutableblockposition1);
                                        ++k3;
                                    } while (l4 > world.L_() && !iblockdata1.y().c());
                                    iblockdata = ItemHelperImpl.getCorrectStateForFluidBlock((dmu)world, iblockdata, (jb)blockposition_mutableblockposition);
                                }
                            }
                            worldmap.a((dly)world, chunkcoordintpair.d() + i4 + i3, chunkcoordintpair.e() + j4 + j3);
                            d1 += (double)k4 / (double)(scale * scale);
                            multiset.add((Object)iblockdata.a((dly)world, (jb)blockposition_mutableblockposition));
                        }
                    }
                }
                k3 /= scale * scale;
                double d2 = (d1 - d0) * 4.0 / (double)(scale + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int b0 = 1;
                if (d2 > 0.6) {
                    b0 = 2;
                }
                if (d2 < -0.6) {
                    b0 = 0;
                }
                if ((materialmapcolor = (fap)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)fap.a)) == fap.m) {
                    d2 = (double)k3 * 0.1 + (double)(x + z & 1) * 0.2;
                    b0 = 1;
                    if (d2 < 0.5) {
                        b0 = 2;
                    }
                    if (d2 > 0.9) {
                        b0 = 0;
                    }
                }
                d0 = d1;
                worldmap.a(x, z, (byte)(materialmapcolor.al * 4 + b0));
            }
        }
    }

    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        fcg worldmap = ((CraftServer)Bukkit.getServer()).getServer().a(dmu.i).a(new fce(mapId));
        if (worldmap == null) {
            return false;
        }
        ItemHelperImpl.renderFullMap(worldmap, xMin, zMin, xMax, zMax);
        return true;
    }

    public BlockData getPlacedBlock(Material material) {
        dcr nmsItem = mm.g.b(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElse(null);
        if (nmsItem instanceof dbd) {
            dpz block = ((dbd)nmsItem).c();
            return CraftBlockData.fromData((eeb)block.m());
        }
        return null;
    }

    public boolean isValidMix(ItemStack input, ItemStack ingredient) {
        dcv nmsInput = CraftItemStack.asNMSCopy((ItemStack)input);
        dcv nmsIngredient = CraftItemStack.asNMSCopy((ItemStack)ingredient);
        return MinecraftServer.getServer().bn().a(nmsInput, nmsIngredient);
    }

    public Map<NamespacedKey, ItemHelper.BrewingRecipe> getCustomBrewingRecipes() {
        if (customBrewingRecipes == null) {
            customBrewingRecipes = Maps.transformValues((Map)((Map)ReflectionHelper.getFieldValue(deq.class, (String)"customMixes", (Object)MinecraftServer.getServer().bn())), paperMix -> {
                if (PaperPotionMix_CLASS == null) {
                    PaperPotionMix_CLASS = paperMix.getClass();
                }
                RecipeChoice ingredient = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"ingredient", (Object)paperMix));
                RecipeChoice input = this.convertChoice((Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"input", (Object)paperMix));
                ItemStack result = CraftItemStack.asBukkitCopy((dcv)((dcv)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"result", (Object)paperMix)));
                return new ItemHelper.BrewingRecipe(input, ingredient, result);
            });
        }
        return customBrewingRecipes;
    }

    private RecipeChoice convertChoice(Predicate<dcv> nmsPredicate) {
        if (nmsPredicate instanceof dhi) {
            dhi ingredient = (dhi)nmsPredicate;
            return CraftRecipe.toBukkit((dhi)ingredient);
        }
        return PaperAPITools.instance.createPredicateRecipeChoice(item -> nmsPredicate.test(CraftItemStack.asNMSCopy((ItemStack)item)));
    }

    public byte[] renderMap(MapView mapView, Player player) {
        return ((CraftMapView)mapView).render((CraftPlayer)((CraftPlayer)player)).buffer;
    }

    public int getFoodPoints(Material itemType) {
        return ((cyj)CraftMagicNumbers.getItem((Material)itemType).f().a(kq.v)).a();
    }
}

