/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.interfaces;

import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.shaded.net.adventure.nbt.CompoundBinaryTag;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Bell;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;

public interface BlockHelper {
    public void applyPhysics(Location var1);

    public PlayerProfile getPlayerProfile(Skull var1);

    public void setPlayerProfile(Skull var1, PlayerProfile var2);

    public CompoundBinaryTag getNbtData(Block var1);

    public void setNbtData(Block var1, CompoundBinaryTag var2);

    public boolean setBlockResistance(Material var1, float var2);

    public float getBlockResistance(Material var1);

    default public PistonPushReaction getPushReaction(Material mat) {
        return PistonPushReaction.VALUES[mat.createBlockData().getPistonMoveReaction().ordinal()];
    }

    public void setPushReaction(Material var1, PistonPushReaction var2);

    public float getBlockStrength(Material var1);

    public void setBlockStrength(Material var1, float var2);

    public static String getMaterialNameFromBlockData(String text) {
        int openBracket = text.indexOf(91);
        String material = text;
        if (openBracket > 0) {
            material = text.substring(0, openBracket);
        }
        if (material.startsWith("minecraft:")) {
            material = material.substring("minecraft:".length());
        }
        return material;
    }

    default public BlockData parseBlockData(String text) {
        int openBracket = text.indexOf(91);
        String material = text;
        String otherData = null;
        if (openBracket > 0) {
            material = text.substring(0, openBracket);
            otherData = text.substring(openBracket);
        }
        return Material.matchMaterial((String)material).createBlockData(otherData);
    }

    default public void makeBlockStateRaw(BlockState state) {
    }

    public void doRandomTick(Location var1);

    public Instrument getInstrumentFor(Material var1);

    default public void ringBell(Bell bell) {
        bell.ring();
    }

    public int getExpDrop(Block var1, ItemStack var2);

    default public void setSpawnerCustomRules(CreatureSpawner spawner, int skyMin, int skyMax, int blockMin, int blockMax) {
        throw new UnsupportedOperationException();
    }

    default public void setSpawnerSpawnedType(CreatureSpawner spawner, EntityTag entity) {
        spawner.setSpawnedType(entity.getBukkitEntityType());
    }

    default public Color getMapColor(Block block) {
        return block.getBlockData().getMapColor();
    }

    default public void setVanillaTags(Material material, Set<NamespacedKey> tags) {
        throw new UnsupportedOperationException();
    }

    public static enum PistonPushReaction {
        NORMAL,
        DESTROY,
        BLOCK,
        IGNORE,
        PUSH_ONLY;

        public static final PistonPushReaction[] VALUES;

        static {
            VALUES = PistonPushReaction.values();
        }
    }
}

