/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptFormattingContext;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.scripts.commands.generator.ArgRaw;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.FormatScriptContainer;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugSubmitter;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class DebugCommand
extends AbstractCommand
implements Holdable {
    public static final String DEBUG_FORMAT = ScriptFormattingContext.registerFormatType("debug");
    public static final String ERROR_FORMAT = ScriptFormattingContext.registerFormatType("error");

    public DebugCommand() {
        this.setName("debug");
        this.setSyntax("debug (<type>) [<message>] (name:<name>) (format:<format>)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = true;
        this.generateDebug = false;
        this.autoCompile();
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.add(DebugType.values());
        tab.add("start", "submit", "cancel");
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgRaw @ArgLinear @ArgName(value="debug") String debug, @ArgName(value="type") @ArgDefaultText(value="output") DebugType dbType, @ArgPrefixed @ArgName(value="name") @ArgDefaultNull String name, @ArgName(value="format") @ArgPrefixed @ArgDefaultNull ScriptTag formatScript) {
        ScriptFormattingContext formattingContext = null;
        ScriptContainer scriptContainer = scriptEntry.getScriptContainer();
        if (formatScript != null) {
            FormatScriptContainer formatScriptContainer;
            Object object = formatScript.getContainer();
            if (!(object instanceof FormatScriptContainer) || (formatScriptContainer = (FormatScriptContainer)object).getFormatTag() == null) {
                Debug.echoError("Invalid 'format:' script specified: must be a format script container.");
                return;
            }
            formattingContext = formatScriptContainer.getAsFormattingContext();
        } else if (scriptContainer != null) {
            formattingContext = scriptContainer.getFormattingContext();
        }
        if (name == null) {
            String string = name = scriptContainer != null ? scriptContainer.getOriginalName() : "DebugCommand";
        }
        if (dbType != DebugType.RECORD) {
            scriptEntry.setFinished(true);
        }
        block0 : switch (dbType.ordinal()) {
            case 0: {
                Debug.echoDebug(null, formattingContext == null ? debug : formattingContext.format(DEBUG_FORMAT, debug, scriptEntry));
                break;
            }
            case 1: {
                Debug.echoDebug((Debuggable)scriptEntry, debug);
                break;
            }
            case 2: {
                Debug.echoDebug(scriptEntry, Debug.DebugElement.Header, debug);
                break;
            }
            case 3: {
                Debug.echoDebug(scriptEntry, Debug.DebugElement.Footer, debug);
                break;
            }
            case 4: {
                Debug.echoDebug(scriptEntry, Debug.DebugElement.Spacer, debug);
                break;
            }
            case 5: {
                Debug.log(name, debug);
                break;
            }
            case 6: {
                Debug.echoApproval(debug);
                break;
            }
            case 7: {
                String formatted;
                String string = formatted = formattingContext != null ? formattingContext.formatOrNull(ERROR_FORMAT, debug, scriptEntry) : null;
                if (formatted != null) {
                    Debug.echoDebug(null, formatted);
                    break;
                }
                Debug.echoError(scriptEntry, debug);
                break;
            }
            case 8: {
                if (!scriptEntry.dbCallShouldDebug()) break;
                Debug.report((Debuggable)scriptEntry, name, debug);
                break;
            }
            case 9: {
                Debug.echoError(scriptEntry, new RuntimeException(debug));
                break;
            }
            case 10: {
                String form = CoreUtilities.toLowerCase(debug);
                switch (form) {
                    case "start": {
                        Debug.echoDebug((Debuggable)scriptEntry, "Starting debug recording...");
                        Debug.startRecording();
                        scriptEntry.setFinished(true);
                        break block0;
                    }
                    case "cancel": {
                        Debug.echoDebug((Debuggable)scriptEntry, "Stopping debug recording...");
                        Debug.stopRecording();
                        scriptEntry.setFinished(true);
                        break block0;
                    }
                    case "submit": {
                        DebugSubmitter.submitCurrentRecording(s -> {
                            if (s == null) {
                                Debug.echoDebug((Debuggable)scriptEntry, "Submit failed.");
                            } else if (s.equals("disabled")) {
                                Debug.echoDebug((Debuggable)scriptEntry, "Submit failed: not recording");
                            } else {
                                Debug.echoDebug((Debuggable)scriptEntry, "Submitted to " + s);
                                scriptEntry.saveObject("submitted", new ElementTag((String)s));
                            }
                            scriptEntry.setFinished(true);
                        });
                        break block0;
                    }
                }
                Debug.echoError("Debug 'record' command failed: unknown record form '" + form + "'");
                scriptEntry.setFinished(true);
            }
        }
    }

    public static enum DebugType {
        OUTPUT,
        DEBUG,
        HEADER,
        FOOTER,
        SPACER,
        LOG,
        APPROVAL,
        ERROR,
        REPORT,
        EXCEPTION,
        RECORD;

    }
}

