/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.containers;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.ScriptEntrySet;
import com.denizenscript.denizencore.scripts.ScriptFormattingContext;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.tags.ParseableTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScriptContainer
implements Debuggable {
    public ScriptFormattingContext formattingContext;
    public Boolean enabledCache = null;
    public boolean canRunScripts = true;
    YamlConfiguration contents;
    private String name;
    public ScriptEntrySet baseEntries = null;
    private Map<String, ScriptEntrySet> scriptsMap = new HashMap<String, ScriptEntrySet>();
    private Boolean shouldDebug = null;

    public ScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        if (configurationSection == null) {
            Debug.echoError("Null configuration section while generating a ScriptContainer?!");
            throw new RuntimeException("Null configuration section while generating a ScriptContainer");
        }
        this.contents = configurationSection;
        configurationSection.forceLoweredRootKey("type");
        configurationSection.forceLoweredRootKey("debug");
        configurationSection.forceLoweredRootKey("script");
        configurationSection.forceLoweredRootKey("speed");
        configurationSection.forceLoweredRootKey("enabled");
        this.name = CoreUtilities.toUpperCase(scriptContainerName);
        this.formattingContext = ScriptFormattingContext.parseFromConfiguration(this);
    }

    public <T extends ObjectTag> T tagObject(String text, Class<T> type) {
        TagContext context = DenizenCore.implementation.getTagContext(this);
        return TagManager.tagObject(text, context).asType(type, context);
    }

    public String tag(String text) {
        return TagManager.tag(text, DenizenCore.implementation.getTagContext(this));
    }

    public ParseableTag getCachedTag(String path) {
        String rawString = this.getString(path);
        return rawString != null ? TagManager.parseTextToTag(rawString, DenizenCore.implementation.getTagContext(this)) : null;
    }

    public boolean shouldEnable() {
        if (this.enabledCache != null) {
            return this.enabledCache;
        }
        String enabledText = this.contents.getString("enabled");
        if (enabledText == null) {
            this.enabledCache = true;
            return this.enabledCache;
        }
        String result = this.tag(enabledText);
        this.enabledCache = result == null || CoreUtilities.equalsIgnoreCase(result, "true");
        return this.enabledCache;
    }

    public void postCheck() {
    }

    public ScriptFormattingContext getFormattingContext() {
        return this.formattingContext;
    }

    public YamlConfiguration getContents() {
        return this.contents;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return ScriptHelper.getSource(this.getName());
    }

    public String getRelativeFileName() {
        try {
            String fn = this.getFileName();
            if (fn == null) {
                return "(Error: script source is missing?)";
            }
            fn = fn.replace(DenizenCore.implementation.getScriptFolder().getParentFile().getCanonicalPath(), "");
            while (fn.startsWith("/")) {
                fn = fn.substring(1);
            }
            return fn;
        }
        catch (Exception e) {
            Debug.echoError(e);
            return this.getFileName();
        }
    }

    public String getOriginalName() {
        return ScriptHelper.getOriginalName(this.getName());
    }

    public ScriptTag getAsScriptArg() {
        return new ScriptTag(this);
    }

    public String getContainerType() {
        String type = this.contents.getString("type");
        return type == null ? null : CoreUtilities.toUpperCase(type);
    }

    public boolean contains(String path) {
        return this.contents.contains(path);
    }

    public boolean containsScriptSection(String path) {
        return this.contains(path, List.class, "script section");
    }

    public boolean contains(String path, Class type) {
        return this.contains(path, type, DebugInternals.getClassNameOpti(type));
    }

    public boolean contains(String path, Class type, String typeName) {
        Object o = this.contents.get(path);
        if (o == null) {
            return false;
        }
        if (type.isAssignableFrom(o.getClass())) {
            return true;
        }
        if (type == YamlConfiguration.class) {
            return o instanceof Map;
        }
        Debug.echoError("Script '<Y>" + this.getName() + "<W>' contains path '<Y>" + path + "<W>' but it is not required type '<Y>" + typeName + "<W>'");
        return false;
    }

    public String getString(String path) {
        return this.contents.getString(path);
    }

    public String getString(String path, String def) {
        return this.contents.getString(path, def);
    }

    public String getString(String path, String def, boolean parseTags) {
        String str = this.contents.getString(path);
        if (str == null) {
            return def;
        }
        return parseTags ? this.tag(str) : str;
    }

    public List<String> getStringList(String path) {
        return this.getStringList(path, false);
    }

    public List<String> getStringList(String path, boolean parseTags) {
        Object obj = this.contents.get(path);
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            List<String> strs = YamlConfiguration.patchListNonsense(list);
            ArrayList<String> output = new ArrayList<String>(strs.size());
            for (String str : strs) {
                str = ScriptBuilder.stripLinePrefix(str);
                if (parseTags) {
                    str = this.tag(str);
                }
                output.add(str);
            }
            return output;
        }
        if (parseTags) {
            return this.tagObject(obj.toString(), ListTag.class);
        }
        return null;
    }

    public YamlConfiguration getConfigurationSection(String path) {
        if (path.isEmpty()) {
            return this.contents;
        }
        return this.contents.getConfigurationSection(path);
    }

    public void set(String path, Object object) {
        this.contents.set(path, object);
    }

    public List<ScriptEntry> getBaseEntries(ScriptEntryData data) {
        if (this.baseEntries == null) {
            this.baseEntries = this.getSetFor("script");
        }
        return ScriptContainer.cleanDup(data, this.baseEntries);
    }

    public static List<ScriptEntry> cleanDup(ScriptEntryData data, ScriptEntrySet set) {
        if (set == null) {
            return null;
        }
        set = set.duplicate();
        for (ScriptEntry entry : set.entries) {
            entry.entryData = data.clone();
            entry.updateContext();
            entry.entryData.scriptEntry = entry;
        }
        return set.entries;
    }

    public List<ScriptEntry> getEntries(ScriptEntryData data, String path) {
        if (path == null) {
            path = "script";
        }
        return ScriptContainer.cleanDup(data, this.getSetFor(path));
    }

    public ScriptEntrySet getSetFor(String path) {
        ScriptEntrySet got = this.scriptsMap.get(path);
        if (got != null) {
            return got;
        }
        List<Object> stringEntries = this.contents.getList(path);
        if (stringEntries == null || stringEntries.isEmpty()) {
            return null;
        }
        List<ScriptEntry> entries = ScriptBuilder.buildScriptEntries(stringEntries, this, null);
        if (entries == null) {
            return null;
        }
        got = new ScriptEntrySet(entries);
        this.scriptsMap.put(path, got);
        return got;
    }

    @Override
    public boolean shouldDebug() {
        if (this.shouldDebug == null) {
            this.shouldDebug = !this.contents.contains("debug") ? Boolean.valueOf(CoreConfiguration.defaultDebugMode) : Boolean.valueOf(!CoreUtilities.equalsIgnoreCase(this.contents.getString("debug"), "false"));
        }
        return this.shouldDebug;
    }

    public String toString() {
        return "s@" + CoreUtilities.toLowerCase(this.getName());
    }

    public void handlePseudoTagBasesDeprecation(String key, String ... tags) {
        String value = this.getString(key);
        if (value == null) {
            return;
        }
        for (String tag : tags) {
            if (!value.contains(tag)) continue;
            Deprecations.pseudoTagBases.warn(this);
            return;
        }
    }
}

