/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19.impl.network.handlers;

import com.denizenscript.denizen.events.player.PlayerHearsSoundScriptEvent;
import com.denizenscript.denizen.events.player.PlayerReceivesActionbarScriptEvent;
import com.denizenscript.denizen.events.player.PlayerReceivesMessageScriptEvent;
import com.denizenscript.denizen.events.player.PlayerReceivesPacketScriptEvent;
import com.denizenscript.denizen.events.player.PlayerReceivesTablistUpdateScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizen.nms.v1_19.Handler;
import com.denizenscript.denizen.nms.v1_19.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_19.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_19.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_19.impl.blocks.BlockLightImpl;
import com.denizenscript.denizen.nms.v1_19.impl.entities.EntityFakePlayerImpl;
import com.denizenscript.denizen.nms.v1_19.impl.network.handlers.AbstractListenerPlayInImpl;
import com.denizenscript.denizen.nms.v1_19.impl.network.handlers.DenizenPacketListenerImpl;
import com.denizenscript.denizen.nms.v1_19.impl.network.handlers.FakeBlockHelper;
import com.denizenscript.denizen.nms.v1_19.impl.network.packets.PacketOutChatImpl;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.entity.FakeEquipCommand;
import com.denizenscript.denizen.scripts.commands.entity.GlowCommand;
import com.denizenscript.denizen.scripts.commands.entity.InvisibleCommand;
import com.denizenscript.denizen.scripts.commands.entity.RenameCommand;
import com.denizenscript.denizen.scripts.commands.entity.SneakCommand;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.blocks.ChunkCoordinate;
import com.denizenscript.denizen.utilities.blocks.FakeBlock;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizen.utilities.entity.HideEntitiesHelper;
import com.denizenscript.denizen.utilities.packets.DenizenPacketHandler;
import com.denizenscript.denizen.utilities.packets.HideParticles;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptCodeGen;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.base.Joiner;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R3.CraftParticle;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class DenizenNetworkManagerImpl
extends NetworkManager {
    public final NetworkManager oldManager;
    public final DenizenPacketListenerImpl packetListener;
    public final EntityPlayer player;
    public int packetsSent;
    public int packetsReceived;
    public static Field ENTITY_ID_PACKVELENT = ReflectionHelper.getFields(PacketPlayOutEntityVelocity.class).get(ReflectionMappingsInfo.ClientboundSetEntityMotionPacket_id, Integer.TYPE);
    public static Field ENTITY_ID_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_id, Integer.TYPE);
    public static Field POS_X_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_x, Double.TYPE);
    public static Field POS_Y_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_y, Double.TYPE);
    public static Field POS_Z_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_z, Double.TYPE);
    public static Field YAW_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_yRot, Byte.TYPE);
    public static Field PITCH_PACKTELENT = ReflectionHelper.getFields(PacketPlayOutEntityTeleport.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_xRot, Byte.TYPE);
    public static Field POS_X_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_xa, Short.TYPE);
    public static Field POS_Y_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_ya, Short.TYPE);
    public static Field POS_Z_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_za, Short.TYPE);
    public static Field YAW_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_yRot, Byte.TYPE);
    public static Field PITCH_PACKENT = ReflectionHelper.getFields(PacketPlayOutEntity.class).get(ReflectionMappingsInfo.ClientboundMoveEntityPacket_xRot, Byte.TYPE);
    public static Field SECTIONPOS_MULTIBLOCKCHANGE = ReflectionHelper.getFields(PacketPlayOutMultiBlockChange.class).get(ReflectionMappingsInfo.ClientboundSectionBlocksUpdatePacket_sectionPos, SectionPosition.class);
    public static Field OFFSETARRAY_MULTIBLOCKCHANGE = ReflectionHelper.getFields(PacketPlayOutMultiBlockChange.class).get(ReflectionMappingsInfo.ClientboundSectionBlocksUpdatePacket_positions, short[].class);
    public static Field BLOCKARRAY_MULTIBLOCKCHANGE = ReflectionHelper.getFields(PacketPlayOutMultiBlockChange.class).get(ReflectionMappingsInfo.ClientboundSectionBlocksUpdatePacket_states, IBlockData[].class);
    public static boolean tablistBreakOnlyOnce = false;
    private boolean antiDuplicate = false;
    public static Vector VECTOR_ZERO = new Vector(0, 0, 0);
    private static final Field protocolDirectionField = ReflectionHelper.getFields(NetworkManager.class).get(ReflectionMappingsInfo.Connection_receiving, EnumProtocolDirection.class);
    private static final Field ServerGamePacketListener_ConnectionField = ReflectionHelper.getFields(PlayerConnection.class).get(ReflectionMappingsInfo.ServerGamePacketListenerImpl_connection);
    private static final MethodHandle ServerGamePacketListener_ConnectionSetter = ReflectionHelper.getFinalSetter(PlayerConnection.class, ReflectionMappingsInfo.ServerGamePacketListenerImpl_connection);

    public static PacketDataSerializer copyPacket(Packet<?> original) {
        try {
            PacketDataSerializer copier = new PacketDataSerializer(Unpooled.buffer());
            original.a(copier);
            return copier;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public DenizenNetworkManagerImpl(EntityPlayer entityPlayer, NetworkManager oldManager) {
        super(DenizenNetworkManagerImpl.getProtocolDirection(oldManager));
        this.oldManager = oldManager;
        this.m = oldManager.m;
        this.packetListener = (DenizenPacketListenerImpl)((Object)NetworkInterceptCodeGen.generateAppropriateInterceptor((Object)this, entityPlayer, DenizenPacketListenerImpl.class, AbstractListenerPlayInImpl.class, PlayerConnection.class));
        oldManager.a((PacketListener)this.packetListener);
        this.player = this.packetListener.b;
    }

    public static NetworkManager getConnection(EntityPlayer player) {
        try {
            return (NetworkManager)ServerGamePacketListener_ConnectionField.get(player.b);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            throw new RuntimeException("Failed to get connection from player due to reflection error", ex);
        }
    }

    public static DenizenNetworkManagerImpl getNetworkManager(EntityPlayer player) {
        return (DenizenNetworkManagerImpl)DenizenNetworkManagerImpl.getConnection(player);
    }

    public static DenizenNetworkManagerImpl getNetworkManager(Player player) {
        return DenizenNetworkManagerImpl.getNetworkManager(((CraftPlayer)player).getHandle());
    }

    public static void setNetworkManager(Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        PlayerConnection playerConnection = entityPlayer.b;
        DenizenNetworkManagerImpl.setNetworkManager(playerConnection, new DenizenNetworkManagerImpl(entityPlayer, DenizenNetworkManagerImpl.getConnection(entityPlayer)));
    }

    public static void enableNetworkManager() {
        for (World w : Bukkit.getWorlds()) {
            for (PlayerChunkMap.EntityTracker tracker : ((CraftWorld)w).getHandle().k().a.L.values()) {
                ArrayList connections = new ArrayList(tracker.f);
                tracker.f.clear();
                for (ServerPlayerConnection connection : connections) {
                    tracker.f.add(connection.f().b);
                }
            }
        }
    }

    public int hashCode() {
        return this.oldManager.hashCode();
    }

    public boolean equals(Object c2) {
        return this.oldManager.equals(c2);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelRegistered(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelUnregistered(ctx);
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        this.oldManager.channelActive(channelhandlercontext);
    }

    public void a(EnumProtocol enumprotocol) {
        this.oldManager.a(enumprotocol);
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) {
        this.oldManager.channelInactive(channelhandlercontext);
    }

    public boolean isSharable() {
        return this.oldManager.isSharable();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.handlerRemoved(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) {
        this.oldManager.exceptionCaught(channelhandlercontext, throwable);
    }

    protected void a(ChannelHandlerContext channelhandlercontext, Packet packet) {
        if (this.oldManager.m.isOpen()) {
            try {
                packet.a((PacketListener)this.packetListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void a(PacketListener packetlistener) {
        this.oldManager.a(packetlistener);
    }

    public void a(Packet<?> packet) {
        this.a(packet, null);
    }

    public static void doPacketOutput(String text) {
        if (!NMSHandler.debugPackets) {
            return;
        }
        if (NMSHandler.debugPacketFilter == null || NMSHandler.debugPacketFilter.trim().isEmpty() || CoreUtilities.toLowerCase(text).contains(NMSHandler.debugPacketFilter)) {
            Debug.log(text);
        }
    }

    public void debugOutputPacket(Packet<?> packet) {
        if (packet instanceof PacketPlayOutEntityMetadata) {
            StringBuilder output = new StringBuilder(128);
            output.append("Packet: ClientboundSetEntityDataPacket sent to ").append(this.player.cu()).append(" for entity ID: ").append(((PacketPlayOutEntityMetadata)packet).a()).append(": ");
            List list = ((PacketPlayOutEntityMetadata)packet).c();
            if (list == null) {
                output.append("None");
            } else {
                for (DataWatcher.b data : list) {
                    output.append('[').append(data.a()).append(": ").append(data.c()).append("], ");
                }
            }
            DenizenNetworkManagerImpl.doPacketOutput(output.toString());
        } else if (packet instanceof PacketPlayOutEntityVelocity) {
            PacketPlayOutEntityVelocity velPacket = (PacketPlayOutEntityVelocity)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundSetEntityMotionPacket sent to " + this.player.cu() + " for entity ID: " + velPacket.a() + ": " + velPacket.c() + "," + velPacket.d() + "," + velPacket.e());
        } else if (packet instanceof PacketPlayOutSpawnEntity) {
            PacketPlayOutSpawnEntity addEntityPacket = (PacketPlayOutSpawnEntity)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundAddEntityPacket sent to " + this.player.cu() + " for entity ID: " + addEntityPacket.a() + ": uuid: " + String.valueOf(addEntityPacket.c()) + ", type: " + String.valueOf(addEntityPacket.d()) + ", at: " + addEntityPacket.e() + "," + addEntityPacket.f() + "," + addEntityPacket.g() + ", data: " + addEntityPacket.n());
        } else if (packet instanceof PacketPlayOutMap) {
            PacketPlayOutMap mapPacket = (PacketPlayOutMap)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundMapItemDataPacket sent to " + this.player.cu() + " for map ID: " + mapPacket.a() + ", scale: " + mapPacket.c() + ", locked: " + mapPacket.d());
        } else if (packet instanceof PacketPlayOutEntityDestroy) {
            PacketPlayOutEntityDestroy removePacket = (PacketPlayOutEntityDestroy)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundRemoveEntitiesPacket sent to " + this.player.cu() + " for entities: " + removePacket.a().stream().map(Object::toString).collect(Collectors.joining(", ")));
        } else if (packet instanceof ClientboundPlayerInfoUpdatePacket) {
            ClientboundPlayerInfoUpdatePacket playerInfoPacket = (ClientboundPlayerInfoUpdatePacket)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundPlayerInfoPacket sent to " + this.player.cu() + " of types " + String.valueOf(playerInfoPacket.a()) + " for player profiles: " + playerInfoPacket.c().stream().map(p -> "mode=" + String.valueOf(p.e()) + "/latency=" + p.d() + "/display=" + String.valueOf(p.f()) + "/name=" + p.b().getName() + "/id=" + String.valueOf(p.b().getId()) + "/" + p.b().getProperties().asMap().entrySet().stream().map(e2 -> (String)e2.getKey() + "=" + ((Collection)e2.getValue()).stream().map(v -> v.getValue() + ";" + v.getSignature()).collect(Collectors.joining(";;;"))).collect(Collectors.joining("/"))).collect(Collectors.joining(", ")));
        } else {
            DenizenNetworkManagerImpl.doPacketOutput("Packet: " + packet.getClass().getCanonicalName() + " sent to " + this.player.cu());
        }
    }

    public void a(Packet<?> packet, PacketSendListener genericfuturelistener) {
        if (!Bukkit.isPrimaryThread()) {
            if (Settings.cache_warnOnAsyncPackets && !(packet instanceof ClientboundSystemChatPacket) && !(packet instanceof ClientboundPlayerChatPacket) && !(packet instanceof PacketPlayOutTabComplete)) {
                Debug.echoError("Warning: packet sent off main thread! This is completely unsupported behavior! Denizen network interceptor ignoring packet to avoid crash. Packet class: " + packet.getClass().getCanonicalName() + " sent to " + this.player.cu() + " identify the sender of the packet from the stack trace:");
                try {
                    throw new RuntimeException("Trace");
                }
                catch (Exception ex) {
                    Debug.echoError(ex);
                }
            }
            this.oldManager.a(packet, genericfuturelistener);
            return;
        }
        if (NMSHandler.debugPackets) {
            this.debugOutputPacket(packet);
        }
        ++this.packetsSent;
        if (packet instanceof ClientboundBundlePacket) {
            ClientboundBundlePacket bundlePacket = (ClientboundBundlePacket)packet;
            Iterator iter = bundlePacket.a().iterator();
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                if (!this.processPacket((Packet)iter.next(), genericfuturelistener)) continue;
                iter.remove();
                --count;
            }
            if (count == 0) {
                return;
            }
        } else if (this.processPacket(packet, genericfuturelistener)) {
            return;
        }
        this.oldManager.a(packet, genericfuturelistener);
    }

    public boolean processPacket(Packet<?> packet, PacketSendListener genericfuturelistener) {
        if (this.processAttachToForPacket(packet) || this.processHiddenEntitiesForPacket(packet) || this.processMirrorForPacket(packet) || this.processParticlesForPacket(packet) || this.processSoundPacket(packet) || this.processPacketHandlerForPacket(packet, genericfuturelistener) || this.processTablistPacket(packet, genericfuturelistener) || this.processActionbarPacket(packet, genericfuturelistener) || this.processDisguiseForPacket(packet, genericfuturelistener) || this.processMetadataChangesForPacket(packet, genericfuturelistener) || this.processEquipmentForPacket(packet, genericfuturelistener) || this.processShowFakeForPacket(packet, genericfuturelistener)) {
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("DENIED PACKET " + packet.getClass().getCanonicalName() + " DENIED FROM SEND TO " + this.player.cu());
            }
            return true;
        }
        if (PlayerReceivesPacketScriptEvent.instance.eventData.isEnabled && PlayerReceivesPacketScriptEvent.fireFor((Player)this.player.getBukkitEntity(), packet)) {
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("DENIED PACKET " + packet.getClass().getCanonicalName() + " DENIED FROM SEND TO " + this.player.cu() + " due to event");
            }
            return true;
        }
        this.processBlockLightForPacket(packet);
        this.processFakePlayerSpawnForPacket(packet);
        return false;
    }

    public boolean processTablistPacket(Packet<?> packet, PacketSendListener genericfuturelistener) {
        if (!PlayerReceivesTablistUpdateScriptEvent.instance.eventData.isEnabled) {
            return false;
        }
        if (packet instanceof ClientboundPlayerInfoUpdatePacket) {
            ClientboundPlayerInfoUpdatePacket infoPacket = (ClientboundPlayerInfoUpdatePacket)packet;
            Object mode = "";
            for (ClientboundPlayerInfoUpdatePacket.a action : infoPacket.a()) {
                switch (action) {
                    case a: {
                        mode = "add";
                        break;
                    }
                    case e: {
                        mode = ((String)mode).isEmpty() ? "update_latency" : (String)mode + "|update_latency";
                        break;
                    }
                    case c: {
                        mode = ((String)mode).isEmpty() ? "update_gamemode" : (String)mode + "|update_gamemode";
                        break;
                    }
                    case f: {
                        mode = ((String)mode).isEmpty() ? "update_display" : (String)mode + "|update_display";
                        break;
                    }
                    case d: {
                        mode = ((String)mode).isEmpty() ? "update_listed" : (String)mode + "|update_listed";
                        break;
                    }
                    case b: {
                        mode = ((String)mode).isEmpty() ? "initialize_chat" : (String)mode + "|initialize_chat";
                    }
                }
            }
            if (((String)mode).isEmpty()) {
                if (!tablistBreakOnlyOnce) {
                    tablistBreakOnlyOnce = true;
                    Debug.echoError("Tablist packet processing failed: unknown action " + Joiner.on((String)", ").join((Iterable)infoPacket.a()));
                }
                return false;
            }
            boolean isOverriding = false;
            for (ClientboundPlayerInfoUpdatePacket.b update : infoPacket.c()) {
                GameProfile profile = update.b();
                String texture = null;
                String signature = null;
                if (profile.getProperties().containsKey((Object)"textures")) {
                    Property property = (Property)profile.getProperties().get((Object)"textures").stream().findFirst().get();
                    texture = property.getValue();
                    signature = property.getSignature();
                }
                String modeText = update.e() == null ? null : update.e().name();
                PlayerReceivesTablistUpdateScriptEvent.TabPacketData data = new PlayerReceivesTablistUpdateScriptEvent.TabPacketData((String)mode, profile.getId(), update.c(), profile.getName(), update.f() == null ? null : FormattedTextHelper.stringify(Handler.componentToSpigot(update.f())), modeText, texture, signature, update.d());
                PlayerReceivesTablistUpdateScriptEvent.fire((Player)this.player.getBukkitEntity(), data);
                if (data.modified) {
                    if (!isOverriding) {
                        ClientboundPlayerInfoUpdatePacket.b priorUpdate;
                        isOverriding = true;
                        Iterator iterator = infoPacket.c().iterator();
                        while (iterator.hasNext() && (priorUpdate = (ClientboundPlayerInfoUpdatePacket.b)iterator.next()) != update) {
                            this.oldManager.a((Packet)ProfileEditorImpl.createInfoPacket(infoPacket.a(), Collections.singletonList(priorUpdate)));
                        }
                    }
                    if (data.cancelled) continue;
                    GameProfile newProfile = new GameProfile(data.id, data.name);
                    if (data.texture != null) {
                        newProfile.getProperties().put((Object)"textures", (Object)new Property("textures", data.texture, data.signature));
                    }
                    ClientboundPlayerInfoUpdatePacket.b entry = new ClientboundPlayerInfoUpdatePacket.b(newProfile.getId(), newProfile, data.isListed, data.latency, data.gamemode == null ? null : EnumGamemode.a((String)CoreUtilities.toLowerCase(data.gamemode)), data.display == null ? null : Handler.componentToNMS(FormattedTextHelper.parse(data.display, ChatColor.WHITE)), update.g());
                    this.oldManager.a((Packet)ProfileEditorImpl.createInfoPacket(infoPacket.a(), Collections.singletonList(entry)), genericfuturelistener);
                    continue;
                }
                if (!isOverriding) continue;
                this.oldManager.a((Packet)ProfileEditorImpl.createInfoPacket(infoPacket.a(), Collections.singletonList(update)), genericfuturelistener);
            }
            return isOverriding;
        }
        if (packet instanceof ClientboundPlayerInfoRemovePacket) {
            ClientboundPlayerInfoRemovePacket removePacket = (ClientboundPlayerInfoRemovePacket)packet;
            boolean modified = false;
            ArrayList altIds = new ArrayList(((ClientboundPlayerInfoRemovePacket)packet).a());
            for (UUID id : ((ClientboundPlayerInfoRemovePacket)packet).a()) {
                PlayerReceivesTablistUpdateScriptEvent.TabPacketData data = new PlayerReceivesTablistUpdateScriptEvent.TabPacketData("remove", id, false, null, null, null, null, null, 0);
                PlayerReceivesTablistUpdateScriptEvent.fire((Player)this.player.getBukkitEntity(), data);
                if (!data.modified || !data.cancelled) continue;
                modified = true;
                altIds.remove(id);
            }
            if (modified) {
                this.oldManager.a((Packet)new ClientboundPlayerInfoRemovePacket(altIds), genericfuturelistener);
                return true;
            }
        }
        return false;
    }

    public boolean processActionbarPacket(Packet<?> packet, PacketSendListener genericfuturelistener) {
        if (!PlayerReceivesActionbarScriptEvent.instance.loaded) {
            return false;
        }
        if (packet instanceof ClientboundSetActionBarTextPacket) {
            ClientboundSetActionBarTextPacket actionbarPacket = (ClientboundSetActionBarTextPacket)packet;
            PlayerReceivesActionbarScriptEvent event = PlayerReceivesActionbarScriptEvent.instance;
            IChatBaseComponent baseComponent = actionbarPacket.a();
            event.reset();
            event.message = new ElementTag(FormattedTextHelper.stringify(Handler.componentToSpigot(baseComponent)));
            event.rawJson = new ElementTag(IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)baseComponent));
            event.system = new ElementTag(false);
            event.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)this.player.getBukkitEntity());
            event = (PlayerReceivesActionbarScriptEvent)event.triggerNow();
            if (event.cancelled) {
                return true;
            }
            if (event.modified) {
                IChatMutableComponent component = Handler.componentToNMS(event.altMessageDetermination);
                ClientboundSetActionBarTextPacket newPacket = new ClientboundSetActionBarTextPacket((IChatBaseComponent)component);
                this.oldManager.a((Packet)newPacket, genericfuturelistener);
                return true;
            }
        }
        return false;
    }

    public boolean processSoundPacket(Packet<?> packet) {
        if (!PlayerHearsSoundScriptEvent.instance.eventData.isEnabled) {
            return false;
        }
        if (packet instanceof PacketPlayOutNamedSoundEffect) {
            PacketPlayOutNamedSoundEffect spacket = (PacketPlayOutNamedSoundEffect)packet;
            return PlayerHearsSoundScriptEvent.instance.run((Player)this.player.getBukkitEntity(), ((SoundEffect)spacket.a().a()).a().a(), spacket.c().name(), false, null, new Location(this.player.getBukkitEntity().getWorld(), spacket.d(), spacket.e(), spacket.f()), spacket.g(), spacket.h());
        }
        if (packet instanceof PacketPlayOutEntitySound) {
            PacketPlayOutEntitySound spacket = (PacketPlayOutEntitySound)packet;
            net.minecraft.world.entity.Entity entity = this.player.x().a(spacket.d());
            if (entity == null) {
                return false;
            }
            return PlayerHearsSoundScriptEvent.instance.run((Player)this.player.getBukkitEntity(), ((SoundEffect)spacket.a().a()).a().a(), spacket.c().name(), false, (Entity)entity.getBukkitEntity(), null, spacket.e(), spacket.f());
        }
        return false;
    }

    public boolean processEquipmentForPacket(Packet<?> packet, PacketSendListener genericfuturelistener) {
        if (FakeEquipCommand.overrides.isEmpty()) {
            return false;
        }
        try {
            if (packet instanceof PacketPlayOutEntityEquipment) {
                int eid = ((PacketPlayOutEntityEquipment)packet).a();
                net.minecraft.world.entity.Entity ent = this.player.H.a(eid);
                if (ent == null) {
                    return false;
                }
                FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor(ent.cs(), (Player)this.player.getBukkitEntity());
                if (override == null) {
                    return false;
                }
                ArrayList<Pair> equipment = new ArrayList<Pair>(((PacketPlayOutEntityEquipment)packet).c());
                PacketPlayOutEntityEquipment newPacket = new PacketPlayOutEntityEquipment(eid, equipment);
                for (int i = 0; i < equipment.size(); ++i) {
                    Pair pair = (Pair)equipment.get(i);
                    net.minecraft.world.item.ItemStack use = (net.minecraft.world.item.ItemStack)pair.getSecond();
                    switch ((EnumItemSlot)pair.getFirst()) {
                        case a: {
                            use = override.hand == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.hand.getItemStack());
                            break;
                        }
                        case b: {
                            use = override.offhand == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.offhand.getItemStack());
                            break;
                        }
                        case e: {
                            use = override.chest == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.chest.getItemStack());
                            break;
                        }
                        case f: {
                            use = override.head == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.head.getItemStack());
                            break;
                        }
                        case d: {
                            use = override.legs == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.legs.getItemStack());
                            break;
                        }
                        case c: {
                            use = override.boots == null ? use : CraftItemStack.asNMSCopy((ItemStack)override.boots.getItemStack());
                        }
                    }
                    equipment.set(i, new Pair((Object)((EnumItemSlot)pair.getFirst()), (Object)use));
                }
                this.oldManager.a((Packet)newPacket, genericfuturelistener);
                return true;
            }
            if (packet instanceof PacketPlayOutEntityStatus) {
                net.minecraft.world.entity.Entity ent = ((PacketPlayOutEntityStatus)packet).a(this.player.H);
                if (!(ent instanceof EntityLiving)) {
                    return false;
                }
                FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor(ent.cs(), (Player)this.player.getBukkitEntity());
                if (override == null || override.hand == null && override.offhand == null) {
                    return false;
                }
                if (((PacketPlayOutEntityStatus)packet).a() != 55) {
                    return false;
                }
                ArrayList<Pair> equipment = new ArrayList<Pair>();
                net.minecraft.world.item.ItemStack hand = override.hand != null ? CraftItemStack.asNMSCopy((ItemStack)override.hand.getItemStack()) : ((EntityLiving)ent).eK();
                net.minecraft.world.item.ItemStack offhand = override.offhand != null ? CraftItemStack.asNMSCopy((ItemStack)override.offhand.getItemStack()) : ((EntityLiving)ent).eL();
                equipment.add(new Pair((Object)EnumItemSlot.a, (Object)hand));
                equipment.add(new Pair((Object)EnumItemSlot.b, (Object)offhand));
                PacketPlayOutEntityEquipment newPacket = new PacketPlayOutEntityEquipment(ent.af(), equipment);
                this.oldManager.a((Packet)newPacket, genericfuturelistener);
                return true;
            }
            if (packet instanceof PacketPlayOutWindowItems) {
                FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor(this.player.cs(), (Player)this.player.getBukkitEntity());
                if (override == null) {
                    return false;
                }
                int window = ((PacketPlayOutWindowItems)packet).a();
                if (window != 0) {
                    return false;
                }
                NonNullList items = (NonNullList)((PacketPlayOutWindowItems)packet).c();
                if (override.head != null) {
                    items.set(5, (Object)CraftItemStack.asNMSCopy((ItemStack)override.head.getItemStack()));
                }
                if (override.chest != null) {
                    items.set(6, (Object)CraftItemStack.asNMSCopy((ItemStack)override.chest.getItemStack()));
                }
                if (override.legs != null) {
                    items.set(7, (Object)CraftItemStack.asNMSCopy((ItemStack)override.legs.getItemStack()));
                }
                if (override.boots != null) {
                    items.set(8, (Object)CraftItemStack.asNMSCopy((ItemStack)override.boots.getItemStack()));
                }
                if (override.offhand != null) {
                    items.set(45, (Object)CraftItemStack.asNMSCopy((ItemStack)override.offhand.getItemStack()));
                }
                if (override.hand != null) {
                    items.set(this.player.fJ().l + 36, (Object)CraftItemStack.asNMSCopy((ItemStack)override.hand.getItemStack()));
                }
                PacketPlayOutWindowItems newPacket = new PacketPlayOutWindowItems(window, ((PacketPlayOutWindowItems)packet).e(), items, ((PacketPlayOutWindowItems)packet).d());
                this.oldManager.a((Packet)newPacket, genericfuturelistener);
                return true;
            }
            if (packet instanceof PacketPlayOutSetSlot) {
                FakeEquipCommand.EquipmentOverride override = FakeEquipCommand.getOverrideFor(this.player.cs(), (Player)this.player.getBukkitEntity());
                if (override == null) {
                    return false;
                }
                int window = ((PacketPlayOutSetSlot)packet).a();
                if (window != 0) {
                    return false;
                }
                int slot = ((PacketPlayOutSetSlot)packet).c();
                ItemStack item = null;
                if (slot == 5 && override.head != null) {
                    item = override.head.getItemStack();
                } else if (slot == 6 && override.chest != null) {
                    item = override.chest.getItemStack();
                } else if (slot == 7 && override.legs != null) {
                    item = override.legs.getItemStack();
                } else if (slot == 8 && override.boots != null) {
                    item = override.boots.getItemStack();
                } else if (slot == 45 && override.offhand != null) {
                    item = override.offhand.getItemStack();
                } else if (slot == this.player.fJ().l + 36 && override.hand != null) {
                    item = override.hand.getItemStack();
                }
                if (item == null) {
                    return false;
                }
                PacketPlayOutSetSlot newPacket = new PacketPlayOutSetSlot(window, ((PacketPlayOutSetSlot)packet).e(), slot, CraftItemStack.asNMSCopy((ItemStack)item));
                this.oldManager.a((Packet)newPacket, genericfuturelistener);
                return true;
            }
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        return false;
    }

    public boolean processParticlesForPacket(Packet<?> packet) {
        if (HideParticles.hidden.isEmpty()) {
            return false;
        }
        try {
            if (packet instanceof PacketPlayOutWorldParticles) {
                HashSet<Particle> hidden = HideParticles.hidden.get(this.player.cs());
                if (hidden == null) {
                    return false;
                }
                ParticleParam particle = ((PacketPlayOutWorldParticles)packet).k();
                Particle bukkitParticle = CraftParticle.toBukkit((ParticleParam)particle);
                return hidden.contains(bukkitParticle);
            }
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        return false;
    }

    public boolean processDisguiseForPacket(Packet<?> packet, PacketSendListener genericfuturelistener) {
        if (DisguiseCommand.disguises.isEmpty() || this.antiDuplicate) {
            return false;
        }
        try {
            PacketPlayOutEntity moveEntityPacket;
            net.minecraft.world.entity.Entity e2;
            int entityID = -1;
            if (packet instanceof PacketPlayOutEntityMetadata) {
                PacketPlayOutEntityMetadata entityDataPacket = (PacketPlayOutEntityMetadata)packet;
                entityID = entityDataPacket.a();
            }
            if (packet instanceof PacketPlayOutUpdateAttributes) {
                PacketPlayOutUpdateAttributes updateAttributesPacket = (PacketPlayOutUpdateAttributes)packet;
                entityID = updateAttributesPacket.a();
            }
            if (packet instanceof PacketPlayOutNamedEntitySpawn) {
                PacketPlayOutNamedEntitySpawn addPlayerPacket = (PacketPlayOutNamedEntitySpawn)packet;
                entityID = addPlayerPacket.a();
            } else if (packet instanceof PacketPlayOutSpawnEntity) {
                PacketPlayOutSpawnEntity addEntityPacket = (PacketPlayOutSpawnEntity)packet;
                entityID = addEntityPacket.a();
            } else if (packet instanceof PacketPlayOutEntityTeleport) {
                PacketPlayOutEntityTeleport teleportEntityPacket = (PacketPlayOutEntityTeleport)packet;
                entityID = teleportEntityPacket.a();
            } else if (packet instanceof PacketPlayOutEntity && (e2 = (moveEntityPacket = (PacketPlayOutEntity)packet).a(this.player.H)) != null) {
                entityID = e2.af();
            }
            if (entityID == -1) {
                return false;
            }
            net.minecraft.world.entity.Entity entity = this.player.x().a(entityID);
            if (entity == null) {
                return false;
            }
            HashMap<UUID, DisguiseCommand.TrackedDisguise> playerMap = DisguiseCommand.disguises.get(entity.cs());
            if (playerMap == null) {
                return false;
            }
            DisguiseCommand.TrackedDisguise disguise = playerMap.get(this.player.cs());
            if (disguise == null && (disguise = playerMap.get(null)) == null) {
                return false;
            }
            if (!disguise.isActive) {
                return false;
            }
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("DISGUISED packet " + packet.getClass().getName() + " for entity " + entityID + " to player " + this.player.cu());
            }
            if (packet instanceof PacketPlayOutEntityMetadata) {
                PacketPlayOutEntityMetadata metadataPacket = (PacketPlayOutEntityMetadata)packet;
                if (entityID == this.player.af()) {
                    if (!disguise.shouldFake) {
                        return false;
                    }
                    data = metadataPacket.c();
                    for (DataWatcher.b dataValue : data) {
                        if (dataValue.a() != 0) continue;
                        data = new ArrayList<DataWatcher.b>(data);
                        data.remove(dataValue);
                        byte flags = (Byte)dataValue.c();
                        flags = (byte)(flags | 0x20);
                        data.add(new DataWatcher.b(dataValue.a(), dataValue.b(), (Object)flags));
                        PacketPlayOutEntityMetadata altPacket = new PacketPlayOutEntityMetadata(metadataPacket.a(), data);
                        PacketPlayOutEntityMetadata updatedPacket = this.getModifiedMetadataFor(altPacket);
                        this.oldManager.a((Packet)(updatedPacket == null ? altPacket : updatedPacket), genericfuturelistener);
                        return true;
                    }
                } else {
                    data = ((CraftEntity)disguise.toOthers.entity.entity).getHandle().aj().c();
                    if (data != null) {
                        this.oldManager.a((Packet)new PacketPlayOutEntityMetadata(entityID, (List)data), genericfuturelistener);
                    }
                    return true;
                }
                return false;
            }
            if (packet instanceof PacketPlayOutUpdateAttributes) {
                FakeEntity fake;
                FakeEntity fakeEntity = fake = entityID == this.player.af() ? disguise.fakeToSelf : disguise.toOthers;
                if (fake == null) {
                    return false;
                }
                return !(fake.entity.entity instanceof LivingEntity);
            }
            if (packet instanceof PacketPlayOutEntityTeleport) {
                if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
                    pOld = (PacketPlayOutEntityTeleport)packet;
                    PacketPlayOutEntityTeleport pNew = new PacketPlayOutEntityTeleport(entity);
                    ENTITY_ID_PACKTELENT.setInt(pNew, pOld.a());
                    POS_X_PACKTELENT.setDouble(pNew, pOld.c());
                    POS_Y_PACKTELENT.setDouble(pNew, pOld.d());
                    POS_Z_PACKTELENT.setDouble(pNew, pOld.e());
                    YAW_PACKTELENT.setByte(pNew, EntityAttachmentHelper.adaptedCompressedAngle(pOld.f(), 180.0f));
                    PITCH_PACKTELENT.setByte(pNew, pOld.g());
                    this.oldManager.a((Packet)pNew, genericfuturelistener);
                    return true;
                }
            } else if (packet instanceof PacketPlayOutEntity && disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
                pOld = (PacketPlayOutEntity)packet;
                PacketPlayOutEntity.PacketPlayOutEntityLook pNew = null;
                if (packet instanceof PacketPlayOutEntity.PacketPlayOutEntityLook) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutEntityLook(entityID, EntityAttachmentHelper.adaptedCompressedAngle(pOld.e(), 180.0f), pOld.f(), pOld.i());
                } else if (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(entityID, pOld.a(), pOld.c(), pOld.d(), EntityAttachmentHelper.adaptedCompressedAngle(pOld.e(), 180.0f), pOld.f(), pOld.i());
                }
                if (pNew != null) {
                    this.oldManager.a(pNew, genericfuturelistener);
                    return true;
                }
                return false;
            }
            this.antiDuplicate = true;
            disguise.sendTo(List.of(new PlayerTag(this.player.cs())));
            this.antiDuplicate = false;
            return true;
        }
        catch (Throwable ex) {
            this.antiDuplicate = false;
            Debug.echoError(ex);
            return false;
        }
    }

    public PacketPlayOutEntityMetadata getModifiedMetadataFor(PacketPlayOutEntityMetadata metadataPacket) {
        if (!RenameCommand.hasAnyDynamicRenames() && SneakCommand.forceSetSneak.isEmpty() && InvisibleCommand.helper.noOverrides() && GlowCommand.helper.noOverrides()) {
            return null;
        }
        try {
            boolean shouldModifyFlags;
            net.minecraft.world.entity.Entity entity = this.player.H.a(metadataPacket.a());
            if (entity == null) {
                return null;
            }
            String nameToApply = RenameCommand.getCustomNameFor(entity.cs(), (Player)this.player.getBukkitEntity(), false);
            Boolean forceSneak = SneakCommand.shouldSneak(entity.cs(), this.player.cs());
            Boolean isInvisible = InvisibleCommand.helper.getState((Entity)entity.getBukkitEntity(), this.player.cs(), true);
            Boolean isGlowing = GlowCommand.helper.getState((Entity)entity.getBukkitEntity(), this.player.cs(), true);
            boolean bl = shouldModifyFlags = isInvisible != null || forceSneak != null || isGlowing != null;
            if (nameToApply == null && !shouldModifyFlags) {
                return null;
            }
            ArrayList<DataWatcher.b> data = new ArrayList<DataWatcher.b>(metadataPacket.c().size());
            Byte currentFlags = null;
            for (DataWatcher.b dataValue : metadataPacket.c()) {
                if (dataValue.a() == 0 && shouldModifyFlags) {
                    currentFlags = (Byte)dataValue.c();
                    continue;
                }
                if (nameToApply != null && (dataValue.a() == 2 || dataValue.a() == 3)) continue;
                data.add(dataValue);
            }
            if (shouldModifyFlags) {
                byte flags = currentFlags == null ? ((Byte)entity.aj().a(PacketHelperImpl.ENTITY_DATA_ACCESSOR_FLAGS)).byteValue() : currentFlags.byteValue();
                flags = this.applyEntityDataFlag(flags, forceSneak, 2);
                flags = this.applyEntityDataFlag(flags, isInvisible, 32);
                flags = this.applyEntityDataFlag(flags, isGlowing, 64);
                data.add(DataWatcher.b.a(PacketHelperImpl.ENTITY_DATA_ACCESSOR_FLAGS, (Object)flags));
            }
            if (nameToApply != null) {
                data.add(DataWatcher.b.a(PacketHelperImpl.ENTITY_DATA_ACCESSOR_CUSTOM_NAME, Optional.of(Handler.componentToNMS(FormattedTextHelper.parse(nameToApply, ChatColor.WHITE)))));
                data.add(DataWatcher.b.a(PacketHelperImpl.ENTITY_DATA_ACCESSOR_CUSTOM_NAME_VISIBLE, (Object)true));
            }
            return new PacketPlayOutEntityMetadata(metadataPacket.a(), data);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    public byte applyEntityDataFlag(byte currentFlags, Boolean value, int flag) {
        if (value == null) {
            return currentFlags;
        }
        return (byte)(value != false ? currentFlags | flag : currentFlags & ~flag);
    }

    public boolean processMetadataChangesForPacket(Packet<?> packet, PacketSendListener genericfuturelistener) {
        if (!(packet instanceof PacketPlayOutEntityMetadata)) {
            return false;
        }
        PacketPlayOutEntityMetadata entityDataPacket = (PacketPlayOutEntityMetadata)packet;
        PacketPlayOutEntityMetadata altPacket = this.getModifiedMetadataFor(entityDataPacket);
        if (altPacket == null) {
            return false;
        }
        this.oldManager.a((Packet)altPacket, genericfuturelistener);
        return true;
    }

    public void tryProcessMovePacketForAttach(PacketPlayOutEntity packet, net.minecraft.world.entity.Entity e2) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = EntityAttachmentHelper.toEntityToData.get(e2.cs());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                PacketPlayOutEntity.PacketPlayOutRelEntityMove pNew;
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(this.player.cs());
                if (!attMap.attached.isValid() || att == null) continue;
                int newId = att.attached.getBukkitEntity().getEntityId();
                if (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMove) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(newId, packet.a(), packet.c(), packet.d(), packet.i());
                } else if (packet instanceof PacketPlayOutEntity.PacketPlayOutEntityLook) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutEntityLook(newId, packet.e(), packet.f(), packet.i());
                } else if (packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook) {
                    pNew = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(newId, packet.a(), packet.c(), packet.d(), packet.e(), packet.f(), packet.i());
                } else {
                    if (CoreConfiguration.debugVerbose) {
                        Debug.echoError("Impossible move-entity packet class: " + packet.getClass().getCanonicalName());
                    }
                    return;
                }
                if (att.positionalOffset != null) {
                    byte pitch;
                    byte yaw;
                    net.minecraft.world.entity.Entity attachedEntity;
                    boolean isRotate;
                    boolean bl = isRotate = packet instanceof PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook || packet instanceof PacketPlayOutEntity.PacketPlayOutEntityLook;
                    if (att.noRotate) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        yaw = EntityAttachmentHelper.compressAngle(attachedEntity.dw());
                        pitch = EntityAttachmentHelper.compressAngle(attachedEntity.dy());
                    } else if (isRotate) {
                        yaw = packet.e();
                        pitch = packet.f();
                    } else {
                        yaw = EntityAttachmentHelper.compressAngle(e2.dw());
                        pitch = EntityAttachmentHelper.compressAngle(e2.dy());
                    }
                    if (att.noPitch) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        pitch = EntityAttachmentHelper.compressAngle(attachedEntity.dy());
                    }
                    byte newYaw = yaw;
                    if (isRotate) {
                        newYaw = EntityAttachmentHelper.adaptedCompressedAngle(newYaw, att.positionalOffset.getYaw());
                        pitch = EntityAttachmentHelper.adaptedCompressedAngle(pitch, att.positionalOffset.getPitch());
                    }
                    Vector goalPosition = att.fixedForOffset(new Vector(e2.dl(), e2.dn(), e2.dr()), e2.dw(), e2.dy());
                    Vector oldPos = att.visiblePositions.get(this.player.cs());
                    boolean forceTele = false;
                    if (oldPos == null) {
                        oldPos = att.attached.getLocation().toVector();
                        forceTele = true;
                    }
                    Vector moveNeeded = goalPosition.clone().subtract(oldPos);
                    att.visiblePositions.put(this.player.cs(), goalPosition.clone());
                    int offX = (int)(moveNeeded.getX() * 4096.0);
                    int offY = (int)(moveNeeded.getY() * 4096.0);
                    int offZ = (int)(moveNeeded.getZ() * 4096.0);
                    if (isRotate && att.offsetRelative || forceTele || offX < Short.MIN_VALUE || offX > Short.MAX_VALUE || offY < Short.MIN_VALUE || offY > Short.MAX_VALUE || offZ < Short.MIN_VALUE || offZ > Short.MAX_VALUE) {
                        PacketPlayOutEntityTeleport newTeleportPacket = new PacketPlayOutEntityTeleport(e2);
                        ENTITY_ID_PACKTELENT.setInt(newTeleportPacket, att.attached.getBukkitEntity().getEntityId());
                        POS_X_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getX());
                        POS_Y_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getY());
                        POS_Z_PACKTELENT.setDouble(newTeleportPacket, goalPosition.getZ());
                        YAW_PACKTELENT.setByte(newTeleportPacket, newYaw);
                        PITCH_PACKTELENT.setByte(newTeleportPacket, pitch);
                        if (NMSHandler.debugPackets) {
                            DenizenNetworkManagerImpl.doPacketOutput("Attach Move-Tele Packet: " + newTeleportPacket.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + this.player.cu() + " with original yaw " + yaw + " adapted to " + newYaw);
                        }
                        this.oldManager.a((Packet)newTeleportPacket);
                        continue;
                    }
                    POS_X_PACKENT.setShort(pNew, (short)MathHelper.a((int)offX, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    POS_Y_PACKENT.setShort(pNew, (short)MathHelper.a((int)offY, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    POS_Z_PACKENT.setShort(pNew, (short)MathHelper.a((int)offZ, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE));
                    if (isRotate) {
                        YAW_PACKENT.setByte(pNew, yaw);
                        PITCH_PACKENT.setByte(pNew, pitch);
                    }
                    if (NMSHandler.debugPackets) {
                        DenizenNetworkManagerImpl.doPacketOutput("Attach Move Packet: " + pNew.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + this.player.cu() + " with original yaw " + yaw + " adapted to " + newYaw);
                    }
                    this.oldManager.a((Packet)pNew);
                    continue;
                }
                if (NMSHandler.debugPackets) {
                    DenizenNetworkManagerImpl.doPacketOutput("Attach Replica-Move Packet: " + pNew.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + this.player.cu());
                }
                this.oldManager.a((Packet)pNew);
            }
        }
        if (e2.r != null && !e2.r.isEmpty()) {
            for (net.minecraft.world.entity.Entity ent : e2.r) {
                this.tryProcessMovePacketForAttach(packet, ent);
            }
        }
    }

    public void tryProcessRotateHeadPacketForAttach(PacketPlayOutEntityHeadRotation packet, net.minecraft.world.entity.Entity e2) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = EntityAttachmentHelper.toEntityToData.get(e2.cs());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(this.player.cs());
                if (!attMap.attached.isValid() || att == null) continue;
                byte yaw = packet.a();
                net.minecraft.world.entity.Entity attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                if (att.positionalOffset != null) {
                    if (att.noRotate) {
                        yaw = EntityAttachmentHelper.compressAngle(attachedEntity.dw());
                    }
                    yaw = EntityAttachmentHelper.adaptedCompressedAngle(yaw, att.positionalOffset.getYaw());
                }
                PacketPlayOutEntityHeadRotation pNew = new PacketPlayOutEntityHeadRotation(attachedEntity, yaw);
                if (NMSHandler.debugPackets) {
                    DenizenNetworkManagerImpl.doPacketOutput("Head Rotation Packet: " + pNew.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + this.player.cu());
                }
                this.oldManager.a((Packet)pNew);
            }
        }
        if (e2.r != null && !e2.r.isEmpty()) {
            for (net.minecraft.world.entity.Entity ent : e2.r) {
                this.tryProcessRotateHeadPacketForAttach(packet, ent);
            }
        }
    }

    public void tryProcessVelocityPacketForAttach(PacketPlayOutEntityVelocity packet, net.minecraft.world.entity.Entity e2) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = EntityAttachmentHelper.toEntityToData.get(e2.cs());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(this.player.cs());
                if (!attMap.attached.isValid() || att == null) continue;
                PacketPlayOutEntityVelocity pNew = new PacketPlayOutEntityVelocity(DenizenNetworkManagerImpl.copyPacket(packet));
                ENTITY_ID_PACKVELENT.setInt(pNew, att.attached.getBukkitEntity().getEntityId());
                if (NMSHandler.debugPackets) {
                    DenizenNetworkManagerImpl.doPacketOutput("Attach Velocity Packet: " + pNew.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + this.player.cu());
                }
                this.oldManager.a((Packet)pNew);
            }
        }
        if (e2.r != null && !e2.r.isEmpty()) {
            for (net.minecraft.world.entity.Entity ent : e2.r) {
                this.tryProcessVelocityPacketForAttach(packet, ent);
            }
        }
    }

    public void tryProcessTeleportPacketForAttach(PacketPlayOutEntityTeleport packet, net.minecraft.world.entity.Entity e2, Vector relative) throws IllegalAccessException {
        EntityAttachmentHelper.EntityAttachedToMap attList = EntityAttachmentHelper.toEntityToData.get(e2.cs());
        if (attList != null) {
            for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(this.player.cs());
                if (!attMap.attached.isValid() || att == null) continue;
                PacketPlayOutEntityTeleport pNew = new PacketPlayOutEntityTeleport(DenizenNetworkManagerImpl.copyPacket(packet));
                ENTITY_ID_PACKTELENT.setInt(pNew, att.attached.getBukkitEntity().getEntityId());
                Vector resultPos = new Vector(POS_X_PACKTELENT.getDouble(pNew), POS_Y_PACKTELENT.getDouble(pNew), POS_Z_PACKTELENT.getDouble(pNew)).add(relative);
                if (att.positionalOffset != null) {
                    byte pitch;
                    byte yaw;
                    net.minecraft.world.entity.Entity attachedEntity;
                    resultPos = att.fixedForOffset(resultPos, e2.dw(), e2.dy());
                    if (att.noRotate) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        yaw = EntityAttachmentHelper.compressAngle(attachedEntity.dw());
                        pitch = EntityAttachmentHelper.compressAngle(attachedEntity.dy());
                    } else {
                        yaw = packet.f();
                        pitch = packet.g();
                    }
                    if (att.noPitch) {
                        attachedEntity = ((CraftEntity)att.attached.getBukkitEntity()).getHandle();
                        pitch = EntityAttachmentHelper.compressAngle(attachedEntity.dy());
                    }
                    byte newYaw = EntityAttachmentHelper.adaptedCompressedAngle(yaw, att.positionalOffset.getYaw());
                    pitch = EntityAttachmentHelper.adaptedCompressedAngle(pitch, att.positionalOffset.getPitch());
                    POS_X_PACKTELENT.setDouble(pNew, resultPos.getX());
                    POS_Y_PACKTELENT.setDouble(pNew, resultPos.getY());
                    POS_Z_PACKTELENT.setDouble(pNew, resultPos.getZ());
                    YAW_PACKTELENT.setByte(pNew, newYaw);
                    PITCH_PACKTELENT.setByte(pNew, pitch);
                    if (NMSHandler.debugPackets) {
                        DenizenNetworkManagerImpl.doPacketOutput("Attach Teleport Packet: " + pNew.getClass().getCanonicalName() + " for " + String.valueOf(att.attached.getUUID()) + " sent to " + this.player.cu() + " with raw yaw " + yaw + " adapted to " + newYaw);
                    }
                }
                att.visiblePositions.put(this.player.cs(), resultPos.clone());
                this.oldManager.a((Packet)pNew);
            }
        }
        if (e2.r != null && !e2.r.isEmpty()) {
            for (net.minecraft.world.entity.Entity ent : e2.r) {
                this.tryProcessTeleportPacketForAttach(packet, ent, new Vector(ent.dl() - e2.dl(), ent.dn() - e2.dn(), ent.dr() - e2.dr()));
            }
        }
    }

    public boolean processAttachToForPacket(Packet<?> packet) {
        if (EntityAttachmentHelper.toEntityToData.isEmpty()) {
            return false;
        }
        try {
            if (packet instanceof PacketPlayOutEntity) {
                PacketPlayOutEntity moveEntityPacket = (PacketPlayOutEntity)packet;
                net.minecraft.world.entity.Entity e2 = moveEntityPacket.a((net.minecraft.world.level.World)this.player.x());
                if (e2 == null) {
                    return false;
                }
                if (!e2.bL()) {
                    this.tryProcessMovePacketForAttach(moveEntityPacket, e2);
                }
                return EntityAttachmentHelper.denyOriginalPacketSend(this.player.cs(), e2.cs());
            }
            if (packet instanceof PacketPlayOutEntityHeadRotation) {
                PacketPlayOutEntityHeadRotation rotateHeadPacket = (PacketPlayOutEntityHeadRotation)packet;
                net.minecraft.world.entity.Entity e3 = rotateHeadPacket.a((net.minecraft.world.level.World)this.player.x());
                if (e3 == null) {
                    return false;
                }
                this.tryProcessRotateHeadPacketForAttach(rotateHeadPacket, e3);
                return EntityAttachmentHelper.denyOriginalPacketSend(this.player.cs(), e3.cs());
            }
            if (packet instanceof PacketPlayOutEntityVelocity) {
                PacketPlayOutEntityVelocity setEntityMotionPacket = (PacketPlayOutEntityVelocity)packet;
                int ider = setEntityMotionPacket.a();
                net.minecraft.world.entity.Entity e4 = this.player.x().a(ider);
                if (e4 == null) {
                    return false;
                }
                this.tryProcessVelocityPacketForAttach(setEntityMotionPacket, e4);
                return EntityAttachmentHelper.denyOriginalPacketSend(this.player.cs(), e4.cs());
            }
            if (packet instanceof PacketPlayOutEntityTeleport) {
                PacketPlayOutEntityTeleport teleportEntityPacket = (PacketPlayOutEntityTeleport)packet;
                int ider = teleportEntityPacket.a();
                net.minecraft.world.entity.Entity e5 = this.player.x().a(ider);
                if (e5 == null) {
                    return false;
                }
                this.tryProcessTeleportPacketForAttach(teleportEntityPacket, e5, VECTOR_ZERO);
                return EntityAttachmentHelper.denyOriginalPacketSend(this.player.cs(), e5.cs());
            }
            if (packet instanceof PacketPlayOutEntityDestroy) {
                PacketPlayOutEntityDestroy removeEntitiesPacket = (PacketPlayOutEntityDestroy)packet;
                IntListIterator intListIterator = removeEntitiesPacket.a().iterator();
                while (intListIterator.hasNext()) {
                    EntityAttachmentHelper.EntityAttachedToMap attList;
                    int id = (Integer)intListIterator.next();
                    net.minecraft.world.entity.Entity e6 = this.player.x().a(id);
                    if (e6 == null || (attList = EntityAttachmentHelper.toEntityToData.get(e6.cs())) == null) continue;
                    for (EntityAttachmentHelper.PlayerAttachMap attMap : attList.attachedToMap.values()) {
                        EntityAttachmentHelper.AttachmentData att = attMap.getAttachment(this.player.cs());
                        if (!attMap.attached.isValid() || att == null) continue;
                        att.visiblePositions.remove(this.player.cs());
                    }
                }
            }
        }
        catch (Exception ex) {
            Debug.echoError(ex);
        }
        return false;
    }

    public boolean isHidden(net.minecraft.world.entity.Entity entity) {
        return entity != null && HideEntitiesHelper.playerShouldHide(this.player.getBukkitEntity().getUniqueId(), (Entity)entity.getBukkitEntity());
    }

    public boolean processHiddenEntitiesForPacket(Packet<?> packet) {
        if (!HideEntitiesHelper.hasAnyHides()) {
            return false;
        }
        try {
            int ider = -1;
            net.minecraft.world.entity.Entity e2 = null;
            if (packet instanceof PacketPlayOutNamedEntitySpawn) {
                ider = ((PacketPlayOutNamedEntitySpawn)packet).a();
            } else if (packet instanceof PacketPlayOutSpawnEntity) {
                ider = ((PacketPlayOutSpawnEntity)packet).a();
            } else if (packet instanceof PacketPlayOutSpawnEntityExperienceOrb) {
                ider = ((PacketPlayOutSpawnEntityExperienceOrb)packet).a();
            } else if (packet instanceof PacketPlayOutEntity) {
                e2 = ((PacketPlayOutEntity)packet).a((net.minecraft.world.level.World)this.player.x());
            } else if (packet instanceof PacketPlayOutEntityMetadata) {
                ider = ((PacketPlayOutEntityMetadata)packet).a();
            } else if (packet instanceof PacketPlayOutEntityVelocity) {
                ider = ((PacketPlayOutEntityVelocity)packet).a();
            } else if (packet instanceof PacketPlayOutEntityTeleport) {
                ider = ((PacketPlayOutEntityTeleport)packet).a();
            }
            if (e2 == null && ider != -1) {
                e2 = this.player.x().a(ider);
            }
            if (e2 != null && this.isHidden(e2)) {
                return true;
            }
        }
        catch (Exception ex) {
            Debug.echoError(ex);
        }
        return false;
    }

    public void processFakePlayerSpawnForPacket(Packet<?> packet) {
        int id;
        if (packet instanceof PacketPlayOutNamedEntitySpawn && (id = ((PacketPlayOutNamedEntitySpawn)packet).a()) != -1) {
            net.minecraft.world.entity.Entity e2 = this.player.x().a(id);
            this.processFakePlayerSpawn(e2);
        }
    }

    public void processFakePlayerSpawn(net.minecraft.world.entity.Entity entity) {
        if (entity instanceof EntityFakePlayerImpl) {
            EntityFakePlayerImpl fakePlayer = (EntityFakePlayerImpl)entity;
            this.a((Packet<?>)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.a, (EntityPlayer)fakePlayer));
            Bukkit.getScheduler().runTaskLater((Plugin)NMSHandler.getJavaPlugin(), () -> this.a((Packet<?>)new ClientboundPlayerInfoRemovePacket(Collections.singletonList(fakePlayer.cs()))), 5L);
        }
    }

    public boolean processMirrorForPacket(Packet<?> packet) {
        ClientboundPlayerInfoUpdatePacket playerInfoUpdatePacket;
        return packet instanceof ClientboundPlayerInfoUpdatePacket && !ProfileEditorImpl.handleAlteredProfiles(playerInfoUpdatePacket = (ClientboundPlayerInfoUpdatePacket)packet, this);
    }

    public boolean processPacketHandlerForPacket(Packet<?> packet, PacketSendListener genericfuturelistener) {
        if (DenizenPacketHandler.instance.shouldInterceptChatPacket()) {
            PlayerReceivesMessageScriptEvent result;
            PacketOutChatImpl packetHelper = null;
            boolean isActionbar = false;
            if (packet instanceof ClientboundSystemChatPacket) {
                ClientboundSystemChatPacket chatPacket = (ClientboundSystemChatPacket)packet;
                isActionbar = chatPacket.c();
                packetHelper = new PacketOutChatImpl(chatPacket);
                if (packetHelper.rawJson == null) {
                    return false;
                }
            } else if (packet instanceof ClientboundPlayerChatPacket) {
                ClientboundPlayerChatPacket playerChatPacket = (ClientboundPlayerChatPacket)packet;
                packetHelper = new PacketOutChatImpl(playerChatPacket);
            }
            if (packetHelper != null && (result = DenizenPacketHandler.instance.sendPacket((Player)this.player.getBukkitEntity(), packetHelper)) != null) {
                if (result.cancelled) {
                    return true;
                }
                if (result.modified) {
                    this.oldManager.a((Packet)new ClientboundSystemChatPacket(result.altMessageDetermination, isActionbar), genericfuturelistener);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean processShowFakeForPacket(Packet<?> packet, PacketSendListener genericfuturelistener) {
        if (FakeBlock.blocks.isEmpty()) {
            return false;
        }
        try {
            if (packet instanceof ClientboundLevelChunkWithLightPacket) {
                FakeBlock.FakeBlockMap map = FakeBlock.blocks.get(this.player.cs());
                if (map == null) {
                    return false;
                }
                int chunkX = ((ClientboundLevelChunkWithLightPacket)packet).a();
                int chunkZ = ((ClientboundLevelChunkWithLightPacket)packet).c();
                ChunkCoordinate chunkCoord = new ChunkCoordinate(chunkX, chunkZ, this.player.x().getWorld().getName());
                List<FakeBlock> blocks = FakeBlock.getFakeBlocksFor(this.player.cs(), chunkCoord);
                if (blocks == null || blocks.isEmpty()) {
                    return false;
                }
                ClientboundLevelChunkWithLightPacket newPacket = FakeBlockHelper.handleMapChunkPacket(this.player.getBukkitEntity().getWorld(), (ClientboundLevelChunkWithLightPacket)packet, chunkX, chunkZ, blocks);
                this.oldManager.a((Packet)newPacket, genericfuturelistener);
                return true;
            }
            if (packet instanceof PacketPlayOutMultiBlockChange) {
                FakeBlock.FakeBlockMap map = FakeBlock.blocks.get(this.player.cs());
                if (map == null) {
                    return false;
                }
                SectionPosition coord = (SectionPosition)SECTIONPOS_MULTIBLOCKCHANGE.get(packet);
                ChunkCoordinate coordinateDenizen = new ChunkCoordinate(coord.u(), coord.w(), this.player.x().getWorld().getName());
                if (!map.byChunk.containsKey(coordinateDenizen)) {
                    return false;
                }
                PacketPlayOutMultiBlockChange newPacket = new PacketPlayOutMultiBlockChange(DenizenNetworkManagerImpl.copyPacket(packet));
                LocationTag location = new LocationTag((World)this.player.x().getWorld(), 0.0, 0.0, 0.0);
                short[] originalOffsetArray = (short[])OFFSETARRAY_MULTIBLOCKCHANGE.get(newPacket);
                IBlockData[] originalDataArray = (IBlockData[])BLOCKARRAY_MULTIBLOCKCHANGE.get(newPacket);
                short[] offsetArray = Arrays.copyOf(originalOffsetArray, originalOffsetArray.length);
                IBlockData[] dataArray = Arrays.copyOf(originalDataArray, originalDataArray.length);
                OFFSETARRAY_MULTIBLOCKCHANGE.set(newPacket, offsetArray);
                BLOCKARRAY_MULTIBLOCKCHANGE.set(newPacket, dataArray);
                for (int i = 0; i < offsetArray.length; ++i) {
                    short offset = offsetArray[i];
                    BlockPosition pos = coord.g(offset);
                    location.setX(pos.u());
                    location.setY(pos.v());
                    location.setZ(pos.w());
                    FakeBlock block = map.byLocation.get(location);
                    if (block == null) continue;
                    dataArray[i] = FakeBlockHelper.getNMSState(block);
                }
                this.oldManager.a((Packet)newPacket, genericfuturelistener);
                return true;
            }
            if (packet instanceof PacketPlayOutBlockChange) {
                BlockPosition pos = ((PacketPlayOutBlockChange)packet).c();
                LocationTag loc = new LocationTag((World)this.player.x().getWorld(), (double)pos.u(), (double)pos.v(), pos.w());
                FakeBlock block = FakeBlock.getFakeBlockFor(this.player.cs(), loc);
                if (block == null) return false;
                PacketPlayOutBlockChange newPacket = new PacketPlayOutBlockChange(((PacketPlayOutBlockChange)packet).c(), FakeBlockHelper.getNMSState(block));
                this.oldManager.a((Packet)newPacket, genericfuturelistener);
                return true;
            }
            if (!(packet instanceof ClientboundBlockChangedAckPacket)) return false;
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
        return false;
    }

    public void processBlockLightForPacket(Packet<?> packet) {
        if (BlockLight.lightsByChunk.isEmpty()) {
            return;
        }
        if (packet instanceof PacketPlayOutLightUpdate) {
            BlockLightImpl.checkIfLightsBrokenByPacket((PacketPlayOutLightUpdate)packet, this.player.H);
        } else if (packet instanceof PacketPlayOutBlockChange) {
            BlockLightImpl.checkIfLightsBrokenByPacket((PacketPlayOutBlockChange)packet, this.player.H);
        }
    }

    public void a() {
        this.oldManager.a();
    }

    public SocketAddress c() {
        return this.oldManager.c();
    }

    public void a(IChatBaseComponent ichatbasecomponent) {
        if (!this.player.getBukkitEntity().isOnline()) {
            return;
        }
        this.oldManager.a(ichatbasecomponent);
    }

    public boolean d() {
        return this.oldManager.d();
    }

    public EnumProtocolDirection e() {
        return this.oldManager.e();
    }

    public EnumProtocolDirection f() {
        return this.oldManager.f();
    }

    public void a(Cipher cipher, Cipher cipher1) {
        this.oldManager.a(cipher, cipher1);
    }

    public boolean g() {
        return this.oldManager.g();
    }

    public boolean h() {
        return this.oldManager.h();
    }

    public boolean i() {
        return this.oldManager.i();
    }

    public PacketListener j() {
        return this.oldManager.j();
    }

    public IChatBaseComponent k() {
        return this.oldManager.k();
    }

    public void l() {
        this.oldManager.l();
    }

    public void a(int i, boolean b2) {
        this.oldManager.a(i, b2);
    }

    public void m() {
        this.oldManager.m();
    }

    public float n() {
        return this.oldManager.n();
    }

    public float o() {
        return this.oldManager.o();
    }

    private static EnumProtocolDirection getProtocolDirection(NetworkManager networkManager) {
        EnumProtocolDirection direction = null;
        try {
            direction = (EnumProtocolDirection)protocolDirectionField.get(networkManager);
        }
        catch (Exception e2) {
            Debug.echoError(e2);
        }
        return direction;
    }

    private static void setNetworkManager(PlayerConnection playerConnection, NetworkManager networkManager) {
        try {
            ServerGamePacketListener_ConnectionSetter.invoke(playerConnection, networkManager);
        }
        catch (Throwable ex) {
            Debug.echoError(ex);
        }
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return this.oldManager.acceptInboundMessage(msg);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.oldManager.channelRead(ctx, msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelReadComplete(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.oldManager.userEventTriggered(ctx, evt);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelWritabilityChanged(ctx);
    }
}

