/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public static final MethodHandle BIOME_CLIMATESETTINGS_CONSTRUCTOR = ReflectionHelper.getConstructor(dst.b.class, (Class[])new Class[]{Boolean.TYPE, Float.TYPE, dst.d.class, Float.TYPE});
    public static final MethodHandle MAPPED_REGISTRY_REGISTRATION_INFOS = ReflectionHelper.getFields(js.class).getGetter(ReflectionMappingsInfo.MappedRegistry_registrationInfos);
    public jk.c<dst> biomeHolder;
    public awx world;

    public BiomeNMSImpl(awx world, NamespacedKey key) {
        super((World)world.getWorld(), key);
        this.world = world;
        this.biomeHolder = this.getBiomeRegistry().a(ami.a((ami)mp.aN, (amj)CraftNamespacedKey.toMinecraft((NamespacedKey)key))).orElse(null);
    }

    private js<dst> getBiomeRegistry() {
        return (js)this.world.L_().f(mp.aN);
    }

    public BiomeNMS.DownfallType getDownfallTypeAt(Location location) {
        dst.c precipitation = ((dst)this.biomeHolder.a()).a(CraftLocation.toBlockPosition((Location)location), this.world.T());
        return switch (precipitation) {
            default -> throw new IncompatibleClassChangeError();
            case dst.c.b -> BiomeNMS.DownfallType.RAIN;
            case dst.c.c -> BiomeNMS.DownfallType.SNOW;
            case dst.c.a -> BiomeNMS.DownfallType.NONE;
        };
    }

    public float getHumidity() {
        return ((dst)this.biomeHolder.a()).i.d();
    }

    public float getBaseTemperature() {
        return ((dst)this.biomeHolder.a()).h();
    }

    public float getTemperatureAt(Location location) {
        return ((dst)this.biomeHolder.a()).f(CraftLocation.toBlockPosition((Location)location), this.world.T());
    }

    public boolean hasDownfall() {
        return ((dst)this.biomeHolder.a()).c();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(cez.c);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(cez.b);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(cez.a);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(cez.f);
    }

    public int getFoliageColor() {
        if (((dst)this.biomeHolder.a()).f() != 0) {
            return ((dst)this.biomeHolder.a()).f();
        }
        float temperature = this.clampColor(this.getBaseTemperature());
        float humidity = this.clampColor(this.getHumidity());
        int temperatureValue = (int)((1.0f - temperature) * 255.0f);
        int humidityValue = (int)((1.0f - (humidity *= temperature)) * 255.0f);
        int index = temperatureValue << 8 | humidityValue;
        return index >= 65536 ? 4764952 : this.getColor(index / 256, index % 256).asRGB();
    }

    public void setClimate(boolean hasPrecipitation, float temperature, dst.d temperatureModifier, float downfall) {
        try {
            Object newClimate = BIOME_CLIMATESETTINGS_CONSTRUCTOR.invoke(hasPrecipitation, temperature, temperatureModifier, downfall);
            ReflectionHelper.setFieldValue(dst.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeHolder.a(), (Object)newClimate);
            this.setNetworkedRegistrationInfo();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHumidity(float humidity) {
        this.setClimate(this.hasDownfall(), this.getBaseTemperature(), this.getTemperatureModifier(), humidity);
    }

    public void setBaseTemperature(float baseTemperature) {
        this.setClimate(this.hasDownfall(), baseTemperature, this.getTemperatureModifier(), this.getHumidity());
    }

    public void setHasDownfall(boolean hasDownfall) {
        this.setClimate(hasDownfall, this.getBaseTemperature(), this.getTemperatureModifier(), this.getHumidity());
    }

    public void setFoliageColor(int color) {
        ReflectionHelper.setFieldValue(dsz.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_foliageColorOverride, (Object)((dst)this.biomeHolder.a()).i(), Optional.of(color));
        this.setNetworkedRegistrationInfo();
    }

    public int getFogColor() {
        return ((dst)this.biomeHolder.a()).e();
    }

    public void setFogColor(int color) {
        ReflectionHelper.setFieldValue(dsz.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_fogColor, (Object)((dst)this.biomeHolder.a()).i(), (Object)color);
        this.setNetworkedRegistrationInfo();
    }

    public int getWaterFogColor() {
        return ((dst)this.biomeHolder.a()).k();
    }

    public void setWaterFogColor(int color) {
        ReflectionHelper.setFieldValue(dsz.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_waterFogColor, (Object)((dst)this.biomeHolder.a()).i(), (Object)color);
        this.setNetworkedRegistrationInfo();
    }

    private List<EntityType> getSpawnableEntities(cez creatureType) {
        dtf mobs = ((dst)this.biomeHolder.a()).b();
        caa typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (bzz meta : typeSettingList.d()) {
            entityTypes.add(CraftEntityType.minecraftToBukkit((cee)((dtf.c)meta.a()).a()));
        }
        return entityTypes;
    }

    public void setTo(Block block) {
        elv chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getKey()).setTo(block);
            return;
        }
        ja pos = new ja(block.getX(), 0, block.getZ());
        if (this.world.D(pos) && (chunk = this.world.m(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeHolder);
            chunk.i();
        }
    }

    public dst.d getTemperatureModifier() {
        return ((dst)this.biomeHolder.a()).i.c();
    }

    private void setNetworkedRegistrationInfo() {
        try {
            Map registrationInfos = MAPPED_REGISTRY_REGISTRATION_INFOS.invokeExact(this.getBiomeRegistry());
            registrationInfos.put(this.biomeHolder.h(), jw.a);
        }
        catch (Throwable e2) {
            Debug.echoError((String)"Failed to set biome registration info, changes may not be synced correctly.");
            Debug.echoError((Throwable)e2);
        }
    }
}

